/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.chart.period;

import java.util.Date;
import org.json.JSONObject;
import org.silverpeas.chart.AbstractAxisChart;
import org.silverpeas.chart.ChartType;
import org.silverpeas.chart.period.PeriodChartItem;
import org.silverpeas.date.Period;
import org.silverpeas.date.PeriodType;

public class PeriodChart
extends AbstractAxisChart<Period, Number, PeriodChartItem> {
    private PeriodType defaultPeriodType = PeriodType.unknown;

    public static PeriodChart fromTitle(String title) {
        return (PeriodChart)new PeriodChart().withTitle(title);
    }

    public static PeriodChart withoutTitle() {
        return new PeriodChart();
    }

    private PeriodChart() {
    }

    @Override
    public ChartType getType() {
        return ChartType.period;
    }

    public PeriodType getDefaultPeriodType() {
        return this.defaultPeriodType;
    }

    public PeriodChart setDefaultPeriodType(PeriodType defaultPeriodType) {
        this.defaultPeriodType = defaultPeriodType;
        return this;
    }

    @Override
    protected void computeExtraDataAsJson(JSONObject jsonChart) {
        super.computeExtraDataAsJson(jsonChart);
        jsonChart.put("defaultPeriodType", (Object)this.defaultPeriodType.getName());
    }

    public PeriodChartItem forX(Date dateReference, PeriodType periodType) {
        if (periodType == PeriodType.unknown) {
            throw new IllegalArgumentException("The period type must be known");
        }
        return this.forX(Period.from(dateReference, periodType));
    }

    @Override
    public PeriodChartItem forX(Period period) {
        if (period.getPeriodType() != PeriodType.unknown && period.getPeriodType().ordinal() > this.getDefaultPeriodType().ordinal()) {
            this.setDefaultPeriodType(period.getPeriodType());
        }
        return (PeriodChartItem)super.forX(period);
    }
}

