/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.notification.message;

import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.I18NHelper;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.ResourceLocator;
import org.silverpeas.cache.service.CacheServiceFactory;
import org.silverpeas.notification.message.ErrorMessage;
import org.silverpeas.notification.message.InfoMessage;
import org.silverpeas.notification.message.Message;
import org.silverpeas.notification.message.MessageContainer;
import org.silverpeas.notification.message.MessageListener;
import org.silverpeas.notification.message.SevereMessage;
import org.silverpeas.notification.message.SuccessMessage;
import org.silverpeas.notification.message.WarningMessage;

public class MessageManager {
    public static String initialize() {
        String registredKey = CacheServiceFactory.getApplicationCacheService().add(new MessageContainer());
        CacheServiceFactory.getRequestCacheService().put(MessageManager.class, registredKey);
        return registredKey;
    }

    public static void destroy() {
        CacheServiceFactory.getRequestCacheService().remove(MessageManager.class);
    }

    public static void addListener(MessageListener listener) {
        MessageManager.addListener(MessageManager.getRegistredKey(), listener);
    }

    protected static void addListener(String registredKey, MessageListener listener) {
        MessageContainer container = MessageManager.getMessageContainer(registredKey);
        if (container != null) {
            container.addListener(listener);
        }
    }

    public static void setLanguage(String language) {
        MessageManager.setLanguage(MessageManager.getRegistredKey(), language);
    }

    public static String getLanguage() {
        return MessageManager.getLanguage(MessageManager.getRegistredKey());
    }

    protected static void setLanguage(String registredKey, String language) {
        MessageContainer container = MessageManager.getMessageContainer(registredKey);
        if (container != null) {
            container.setLanguage(language);
        }
    }

    protected static String getLanguage(String registredKey) {
        MessageContainer container = MessageManager.getMessageContainer(registredKey);
        if (container != null) {
            return container.getLanguage();
        }
        return I18NHelper.defaultLanguage;
    }

    public static void clear(String registredKey) {
        CacheServiceFactory.getApplicationCacheService().remove(registredKey);
    }

    public static String getRegistredKey() {
        return CacheServiceFactory.getRequestCacheService().get(MessageManager.class, String.class);
    }

    public static ResourceLocator getResourceLocator(String propertyFileBaseName) {
        return MessageManager.getResourceLocator(MessageManager.getRegistredKey(), propertyFileBaseName, null);
    }

    protected static ResourceLocator getResourceLocator(String registredKey, String propertyFileBaseName, String language) {
        MessageContainer container = MessageManager.getMessageContainer(registredKey);
        if (container == null) {
            SilverTrace.error("notification", "MessageManager.getResourceLocator", "MESSAGE_MANAGER.NOT_INITIALIZED", "ResourceLocator : " + propertyFileBaseName);
            return null;
        }
        return container.getResourceLocator(propertyFileBaseName, StringUtil.isDefined(language) ? language : container.getLanguage());
    }

    public static MessageContainer getMessageContainer(String registredKey) {
        return CacheServiceFactory.getApplicationCacheService().get(registredKey, MessageContainer.class);
    }

    public static Message addError(String message) {
        return MessageManager.addError(MessageManager.getRegistredKey(), message);
    }

    protected static Message addError(String registredKey, String message) {
        return MessageManager.addMessage(registredKey, new ErrorMessage(message));
    }

    public static Message addSevere(String message) {
        return MessageManager.addSevere(MessageManager.getRegistredKey(), message);
    }

    protected static Message addSevere(String registredKey, String message) {
        return MessageManager.addMessage(registredKey, new SevereMessage(message));
    }

    public static Message addWarning(String message) {
        return MessageManager.addWarning(MessageManager.getRegistredKey(), message);
    }

    protected static Message addWarning(String registredKey, String message) {
        return MessageManager.addMessage(registredKey, new WarningMessage(message));
    }

    public static Message addSuccess(String message) {
        return MessageManager.addSuccess(MessageManager.getRegistredKey(), message);
    }

    protected static Message addSuccess(String registredKey, String message) {
        return MessageManager.addMessage(registredKey, new SuccessMessage(message));
    }

    public static Message addInfo(String message) {
        return MessageManager.addInfo(MessageManager.getRegistredKey(), message);
    }

    protected static Message addInfo(String registredKey, String message) {
        return MessageManager.addMessage(registredKey, new InfoMessage(message));
    }

    private static Message addMessage(String registredKey, Message message) {
        MessageContainer container = MessageManager.getMessageContainer(registredKey);
        if (container == null) {
            SilverTrace.error("notification", "MessageManager.addMessage", "MESSAGE_MANAGER.NOT_INITIALIZED", "Type : " + (Object)((Object)message.getType()) + ", Message : " + message.getContent());
        } else {
            container.addMessage(message);
        }
        return message;
    }
}

