/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.search.indexEngine.model;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import org.silverpeas.search.indexEngine.IndexFileManager;
import org.silverpeas.search.indexEngine.model.FullIndexEntry;
import org.silverpeas.search.indexEngine.model.IndexEntryPK;
import org.silverpeas.search.indexEngine.model.IndexManager;
import org.silverpeas.search.indexEngine.model.IndexerThread;

public final class IndexEngineProxy {
    private static String indexEngine = null;

    private IndexEngineProxy() {
    }

    public static void addIndexEntry(FullIndexEntry indexEntry) {
        IndexEngineProxy.init();
        if (indexEngine != null) {
            IndexerThread.addIndexEntry(indexEntry);
        } else {
            SilverTrace.error("indexEngine", "IndexEngineProxy", "indexEngine.MSG_ADD_REQUEST_IGNORED");
        }
    }

    public static void removeIndexEntry(IndexEntryPK indexEntry) {
        IndexEngineProxy.init();
        if (indexEngine != null) {
            IndexerThread.removeIndexEntry(indexEntry);
        } else {
            SilverTrace.error("indexEngine", "IndexEngineProxy", "indexEngine.MSG_REMOVE_REQUEST_IGNORED");
        }
    }

    public static void deleteByScope(String scope) {
        IndexEngineProxy.init();
        if (indexEngine != null) {
            IndexerThread.removeIndexEntriesByScope(scope);
        } else {
            SilverTrace.error("indexEngine", "IndexEngineProxy", "indexEngine.MSG_REMOVE_REQUEST_IGNORED");
        }
    }

    private static void init() {
        String rootPath = IndexFileManager.getAbsoluteIndexPath("x", "x");
        IndexerThread.start(new IndexManager());
        indexEngine = "indexEngine";
    }
}

