/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.search.indexEngine.model;

import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.I18NHelper;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.ResourceLocator;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LimitTokenCountAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LogDocMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;
import org.silverpeas.attachment.AttachmentServiceFactory;
import org.silverpeas.search.indexEngine.IndexFileManager;
import org.silverpeas.search.indexEngine.model.DidYouMeanIndexer;
import org.silverpeas.search.indexEngine.model.FieldDescription;
import org.silverpeas.search.indexEngine.model.FileDescription;
import org.silverpeas.search.indexEngine.model.FullIndexEntry;
import org.silverpeas.search.indexEngine.model.IndexEntry;
import org.silverpeas.search.indexEngine.model.IndexEntryPK;
import org.silverpeas.search.indexEngine.model.IndexProcessor;
import org.silverpeas.search.indexEngine.model.TextDescription;
import org.silverpeas.search.indexEngine.model.WAAnalyzer;
import org.silverpeas.search.indexEngine.parser.Parser;
import org.silverpeas.search.indexEngine.parser.ParserManager;
import org.silverpeas.search.util.SearchEnginePropertiesManager;

public class IndexManager {
    public static final String ID = "id";
    public static final String KEY = "key";
    public static final String SCOPE = "scope";
    public static final String TITLE = "title";
    public static final String PREVIEW = "preview";
    public static final String KEYWORDS = "keywords";
    public static final String LANG = "lang";
    public static final String CREATIONDATE = "creationDate";
    public static final String CREATIONUSER = "creationUser";
    public static final String LASTUPDATEDATE = "updateDate";
    public static final String LASTUPDATEUSER = "updateUser";
    public static final String STARTDATE = "startDate";
    public static final String ENDDATE = "endDate";
    public static final String HEADER = "header";
    public static final String CONTENT = "content";
    public static final String THUMBNAIL = "thumbnail";
    public static final String THUMBNAIL_MIMETYPE = "thumbnailMimeType";
    public static final String THUMBNAIL_DIRECTORY = "thumbnailDirectory";
    public static final String SERVER_NAME = "serverName";
    public static final String EMBEDDED_FILE_IDS = "embeddedFileIds";
    public static final String FIELDS_FOR_FACETS = "fieldsForFacet";
    public static final String FILENAME = "filename";
    public static final String PATH = "path";
    public static final String ALIAS = "alias";
    public static final int NONE = -1;
    public static final int ADD = 0;
    public static final int REMOVE = 1;
    public static final int READD = 2;
    private Map<String, IndexWriter> indexWriters = new HashMap<String, IndexWriter>();
    private static int maxFieldLength = 10000;
    private static int mergeFactor = 10;
    private static int maxMergeDocs = Integer.MAX_VALUE;
    private static double RAMBufferSizeMB = 16.0;
    private static boolean enableDymIndexing = false;
    private static String serverName = null;

    public IndexManager() {
        SilverTrace.debug("indexEngine", "IndexManager", "indexEngine.INFO_INDEX_ENGINE_STARTED", "maxFieldLength=" + maxFieldLength + ", mergeFactor=" + mergeFactor + ", maxMergeDocs=" + maxMergeDocs);
    }

    public void addIndexEntry(FullIndexEntry indexEntry) {
        indexEntry.setServerName(serverName);
        String indexPath = this.getIndexDirectoryPath(indexEntry);
        IndexWriter writer = this.getIndexWriter(indexPath, indexEntry.getLang());
        this.removeIndexEntry(writer, indexEntry.getPK());
        this.index(writer, indexEntry);
        SilverTrace.debug("applicationIndexer", "IndexManager().addIndexEntry()", "applicationIndexer.MSG_INDEXING_COMPONENT_ITEM", "componentId = " + indexEntry.getComponent());
    }

    public void flush() {
        IndexProcessor.doFlush(new FlushIndexProcess());
    }

    private void removeIndexEntry(IndexWriter writer, IndexEntryPK indexEntry) {
        Term term = new Term(KEY, indexEntry.toString());
        try {
            writer.deleteDocuments(term);
        }
        catch (IOException e) {
            SilverTrace.error("indexEngine", "IndexManager", "indexEngine.MSG_REMOVE_REQUEST_FAILED", indexEntry.toString(), e);
        }
        SilverTrace.debug("indexEngine", "IndexManager", "indexEngine.INFO_REMOVE_REQUEST_SUCCEED", indexEntry.toString());
    }

    public void removeIndexEntry(IndexEntryPK indexEntry) {
        String indexPath = this.getIndexDirectoryPath(indexEntry);
        IndexWriter writer = this.getIndexWriter(indexPath, "");
        if (writer != null) {
            this.removeIndexEntry(writer, indexEntry);
        } else {
            SilverTrace.debug("indexEngine", "IndexManager", "indexEngine.MSG_UNKNOWN_INDEX_FILE", indexPath);
        }
    }

    private void removeIndexEntries(IndexWriter writer, String scope) {
        Term term = new Term(SCOPE, scope);
        try {
            writer.deleteDocuments(term);
        }
        catch (IOException e) {
            SilverTrace.error("indexEngine", "IndexManager", "indexEngine.MSG_UNKNOWN_INDEX_FILE", "scope = " + scope, e);
        }
    }

    void removeIndexEntries(String scope) {
        String indexPath = this.getIndexDirectoryPath("useless", scope);
        IndexWriter writer = this.getIndexWriter(indexPath, "");
        if (writer != null) {
            this.removeIndexEntries(writer, scope);
        }
    }

    public String getIndexDirectoryPath(IndexEntry indexEntry) {
        return this.getIndexDirectoryPath(indexEntry.getPK());
    }

    public String getIndexDirectoryPath(IndexEntryPK indexEntry) {
        return this.getIndexDirectoryPath(null, indexEntry.getComponent());
    }

    public String getIndexDirectoryPath(String space, String component) {
        return IndexFileManager.getAbsoluteIndexPath(space, component);
    }

    public Analyzer getAnalyzer(String language) {
        Analyzer analyzer = WAAnalyzer.getAnalyzer(language);
        if (analyzer == null) {
            analyzer = new LimitTokenCountAnalyzer((Analyzer)new StandardAnalyzer(Version.LUCENE_36), maxFieldLength);
        }
        return analyzer;
    }

    public Reader getReader(FileDescription file) {
        SilverTrace.debug("indexEngine", "IndexManager.getReader", "root.MSG_GEN_ENTER_METHOD");
        Reader reader = null;
        Parser parser = ParserManager.getParser(file.getFormat());
        if (parser != null) {
            reader = parser.getReader(file.getPath(), file.getEncoding());
        }
        SilverTrace.debug("indexEngine", "IndexManager.getReader", "root.MSG_GEN_EXIT_METHOD");
        return reader;
    }

    private IndexWriter getIndexWriter(String path, String language) {
        IndexWriter indexWriter = this.indexWriters.get(path);
        if (indexWriter == null) {
            try {
                File file = new File(path);
                if (!file.exists()) {
                    file.mkdirs();
                }
                LogDocMergePolicy policy = new LogDocMergePolicy();
                policy.setMergeFactor(mergeFactor);
                policy.setMaxMergeDocs(maxMergeDocs);
                IndexWriterConfig configuration = new IndexWriterConfig(Version.LUCENE_36, this.getAnalyzer(language)).setRAMBufferSizeMB(RAMBufferSizeMB).setMergePolicy((MergePolicy)policy);
                indexWriter = new IndexWriter((Directory)FSDirectory.open((File)file), configuration);
                this.indexWriters.put(path, indexWriter);
            }
            catch (IOException e) {
                SilverTrace.error("searchEngine", "IndexManager.getIndexReader()", "Unknown index file " + path, e);
            }
        }
        return indexWriter;
    }

    private void index(IndexWriter writer, FullIndexEntry indexEntry) {
        SilverTrace.info("indexEngine", "IndexManager.index", "root.MSG_GEN_ENTER_METHOD", "IndexEntryPK = " + indexEntry.toString());
        try {
            writer.addDocument(this.makeDocument(indexEntry));
            SilverTrace.info("indexEngine", "IndexManager.index", "indexEngine.INFO_ADD_REQUEST_SUCCEED", indexEntry.toString());
        }
        catch (Exception e) {
            SilverTrace.error("indexEngine", "IndexManager.index", "indexEngine.MSG_ADD_REQUEST_FAILED", indexEntry.toString(), e);
        }
        SilverTrace.info("indexEngine", "IndexManager.index", "root.MSG_GEN_EXIT_METHOD", "IndexEntryPK = " + indexEntry.toString());
    }

    private Document makeDocument(FullIndexEntry indexEntry) {
        String language;
        String lang;
        SilverTrace.info("indexEngine", "IndexManager.makeDocument", "root.MSG_GEN_ENTER_METHOD", "IndexEntryPK = " + indexEntry.toString());
        Document doc = new Document();
        doc.add((Fieldable)new Field(KEY, indexEntry.getPK().toString(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        doc.add((Fieldable)new Field(SCOPE, indexEntry.getPK().getComponent(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        Iterator<String> languages = indexEntry.getLanguages();
        if (indexEntry.getObjectType() != null && indexEntry.getObjectType().startsWith("Attachment")) {
            lang = indexEntry.getLang();
            if (StringUtil.isDefined(indexEntry.getTitle(lang))) {
                doc.add((Fieldable)new Field(this.getFieldName(TITLE, lang), indexEntry.getTitle(lang), Field.Store.YES, Field.Index.ANALYZED));
            }
            doc.add((Fieldable)new Field(this.getFieldName(FILENAME, lang), indexEntry.getFilename(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        } else {
            while (languages.hasNext()) {
                language = languages.next();
                if (indexEntry.getTitle(language) == null) continue;
                doc.add((Fieldable)new Field(this.getFieldName(TITLE, language), indexEntry.getTitle(language), Field.Store.YES, Field.Index.ANALYZED));
            }
        }
        languages = indexEntry.getLanguages();
        while (languages.hasNext()) {
            language = languages.next();
            if (indexEntry.getPreview(language) != null) {
                doc.add((Fieldable)new Field(this.getFieldName(PREVIEW, language), indexEntry.getPreview(language), Field.Store.YES, Field.Index.ANALYZED));
            }
            if (indexEntry.getKeywords(language) == null) continue;
            doc.add((Fieldable)new Field(this.getFieldName(KEYWORDS, language), indexEntry.getKeywords(language), Field.Store.YES, Field.Index.NO));
        }
        doc.add((Fieldable)new Field(CREATIONDATE, indexEntry.getCreationDate(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        doc.add((Fieldable)new Field(CREATIONUSER, indexEntry.getCreationUser(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        doc.add((Fieldable)new Field(LASTUPDATEDATE, indexEntry.getLastModificationDate(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        doc.add((Fieldable)new Field(LASTUPDATEUSER, indexEntry.getLastModificationUser(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        doc.add((Fieldable)new Field(STARTDATE, indexEntry.getStartDate(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        doc.add((Fieldable)new Field(ENDDATE, indexEntry.getEndDate(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        if (indexEntry.getThumbnail() != null && indexEntry.getThumbnailMimeType() != null) {
            doc.add((Fieldable)new Field(THUMBNAIL, indexEntry.getThumbnail(), Field.Store.YES, Field.Index.NO));
            doc.add((Fieldable)new Field(THUMBNAIL_MIMETYPE, indexEntry.getThumbnailMimeType(), Field.Store.YES, Field.Index.NO));
            doc.add((Fieldable)new Field(THUMBNAIL_DIRECTORY, indexEntry.getThumbnailDirectory(), Field.Store.YES, Field.Index.NO));
        }
        if (indexEntry.isIndexId()) {
            doc.add((Fieldable)new Field(CONTENT, indexEntry.getObjectId(), Field.Store.NO, Field.Index.NOT_ANALYZED));
        }
        if (!this.isWysiwyg(indexEntry)) {
            if (indexEntry.getObjectType() != null && indexEntry.getObjectType().startsWith("Attachment")) {
                lang = indexEntry.getLang();
                if (indexEntry.getTitle(lang) != null) {
                    doc.add((Fieldable)new Field(this.getFieldName(HEADER, lang), indexEntry.getTitle(lang), Field.Store.NO, Field.Index.ANALYZED));
                }
                doc.add((Fieldable)new Field(this.getFieldName(HEADER, lang), indexEntry.getFilename(), Field.Store.NO, Field.Index.NOT_ANALYZED));
                doc.add((Fieldable)new Field(this.getFieldName(HEADER, lang), indexEntry.getFilename(), Field.Store.NO, Field.Index.ANALYZED));
            } else {
                languages = indexEntry.getLanguages();
                while (languages.hasNext()) {
                    language = languages.next();
                    if (indexEntry.getTitle(language) == null) continue;
                    doc.add((Fieldable)new Field(this.getFieldName(HEADER, language), indexEntry.getTitle(language).toLowerCase(new Locale(language)), Field.Store.NO, Field.Index.ANALYZED));
                    doc.add((Fieldable)new Field(this.getFieldName(HEADER, language), indexEntry.getTitle(language).toLowerCase(new Locale(language)), Field.Store.NO, Field.Index.NOT_ANALYZED));
                }
            }
            languages = indexEntry.getLanguages();
            while (languages.hasNext()) {
                language = languages.next();
                if (indexEntry.getPreview(language) != null) {
                    doc.add((Fieldable)new Field(this.getFieldName(HEADER, language), indexEntry.getPreview(language).toLowerCase(new Locale(language)), Field.Store.NO, Field.Index.ANALYZED));
                }
                if (indexEntry.getKeywords(language) == null) continue;
                doc.add((Fieldable)new Field(this.getFieldName(HEADER, language), indexEntry.getKeywords(language).toLowerCase(new Locale(language)), Field.Store.NO, Field.Index.ANALYZED));
            }
            if (indexEntry.getObjectType() != null && indexEntry.getObjectType().startsWith("Attachment")) {
                lang = indexEntry.getLang();
                if (indexEntry.getTitle(lang) != null) {
                    doc.add((Fieldable)new Field(this.getFieldName(CONTENT, lang), indexEntry.getTitle(lang), Field.Store.NO, Field.Index.ANALYZED));
                }
                doc.add((Fieldable)new Field(this.getFieldName(CONTENT, lang), indexEntry.getFilename(), Field.Store.NO, Field.Index.NOT_ANALYZED));
                doc.add((Fieldable)new Field(this.getFieldName(CONTENT, lang), indexEntry.getFilename(), Field.Store.NO, Field.Index.ANALYZED));
            } else {
                doc.add((Fieldable)new Field(CONTENT, indexEntry.getTitle().toLowerCase(I18NHelper.defaultLocale), Field.Store.NO, Field.Index.ANALYZED));
            }
            languages = indexEntry.getLanguages();
            while (languages.hasNext()) {
                language = languages.next();
                if (indexEntry.getTitle(language) != null) {
                    doc.add((Fieldable)new Field(this.getFieldName(CONTENT, language), indexEntry.getTitle(language), Field.Store.NO, Field.Index.NOT_ANALYZED));
                }
                if (indexEntry.getPreview(language) != null) {
                    doc.add((Fieldable)new Field(this.getFieldName(CONTENT, language), indexEntry.getPreview(language).toLowerCase(new Locale(language)), Field.Store.NO, Field.Index.ANALYZED));
                }
                if (indexEntry.getKeywords(language) == null) continue;
                doc.add((Fieldable)new Field(this.getFieldName(CONTENT, language), indexEntry.getKeywords(language).toLowerCase(new Locale(language)), Field.Store.NO, Field.Index.ANALYZED));
            }
        }
        List<TextDescription> list1 = indexEntry.getTextContentList();
        for (TextDescription t : list1) {
            if (t == null || t.getContent() == null) continue;
            doc.add((Fieldable)new Field(this.getFieldName(CONTENT, t.getLang()), t.getContent(), Field.Store.NO, Field.Index.ANALYZED));
        }
        if (StringUtil.isDefined(indexEntry.getObjectId())) {
            AttachmentServiceFactory.getAttachmentService().updateIndexEntryWithDocuments(indexEntry);
        }
        List<FileDescription> list2 = indexEntry.getFileContentList();
        for (FileDescription f : list2) {
            this.addFile(doc, f);
        }
        List<FileDescription> linkedFiles = indexEntry.getLinkedFileContentList();
        for (FileDescription linkedFile : linkedFiles) {
            this.addFile(doc, linkedFile);
        }
        Set<String> linkedFileIds = indexEntry.getLinkedFileIdsSet();
        for (String linkedFileId : linkedFileIds) {
            doc.add((Fieldable)new Field(EMBEDDED_FILE_IDS, linkedFileId, Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
        List<FieldDescription> list3 = indexEntry.getFields();
        ArrayList<String> fieldsForFacets = new ArrayList<String>(list3.size());
        for (FieldDescription field : list3) {
            Field.Store storeAction;
            if (!StringUtil.isDefined(field.getContent())) continue;
            String fieldName = this.getFieldName(field.getFieldName(), field.getLang());
            if (field.isStored() || SearchEnginePropertiesManager.getFieldsNameList().contains(field.getFieldName())) {
                storeAction = Field.Store.YES;
                fieldsForFacets.add(fieldName);
            } else {
                storeAction = Field.Store.NO;
            }
            doc.add((Fieldable)new Field(fieldName, field.getContent(), storeAction, Field.Index.ANALYZED));
        }
        if (!fieldsForFacets.isEmpty()) {
            String stringForFacets = this.buildStringForFacets(fieldsForFacets);
            doc.add((Fieldable)new Field(FIELDS_FOR_FACETS, stringForFacets, Field.Store.YES, Field.Index.NO));
        }
        if (!this.isWysiwyg(indexEntry)) {
            languages = indexEntry.getLanguages();
            while (languages.hasNext()) {
                String language2 = languages.next();
                if (indexEntry.getTitle(language2) != null) {
                    doc.add((Fieldable)new Field(this.getFieldName(CONTENT, language2), indexEntry.getTitle(language2).toLowerCase(new Locale(language2)), Field.Store.NO, Field.Index.ANALYZED));
                }
                if (indexEntry.getPreview(language2) != null) {
                    doc.add((Fieldable)new Field(this.getFieldName(CONTENT, language2), indexEntry.getPreview(language2).toLowerCase(new Locale(language2)), Field.Store.NO, Field.Index.ANALYZED));
                }
                if (indexEntry.getKeywords(language2) == null) continue;
                doc.add((Fieldable)new Field(this.getFieldName(CONTENT, language2), indexEntry.getKeywords(language2).toLowerCase(new Locale(language2)), Field.Store.NO, Field.Index.ANALYZED));
            }
        }
        doc.add((Fieldable)new Field(SERVER_NAME, indexEntry.getServerName(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        if (indexEntry.getPaths() != null) {
            for (String path : indexEntry.getPaths()) {
                doc.add((Fieldable)new Field(PATH, path, Field.Store.YES, Field.Index.NOT_ANALYZED));
            }
        }
        doc.add((Fieldable)new Field(ALIAS, Boolean.toString(indexEntry.isAlias()), Field.Store.YES, Field.Index.NO));
        SilverTrace.info("indexEngine", "IndexManager.makeDocument", "root.MSG_GEN_EXIT_METHOD", "IndexEntryPK = " + indexEntry.toString());
        return doc;
    }

    private String buildStringForFacets(List<String> fieldsForFacets) {
        String fieldsForFacet = "";
        if (fieldsForFacets != null && !fieldsForFacets.isEmpty()) {
            fieldsForFacet = StringUtil.join(fieldsForFacets, (char)',');
        }
        return fieldsForFacet;
    }

    private String getFieldName(String name, String language) {
        if (!I18NHelper.isI18nContentActivated || I18NHelper.isDefaultLanguage(language)) {
            return name;
        }
        return name + "_" + language;
    }

    private void addFile(Document doc, FileDescription fileDescription) {
        SilverTrace.info("indexEngine", "IndexManager.addFile", "root.MSG_GEN_ENTER_METHOD", "file = " + fileDescription.getPath() + ", type = " + fileDescription.getFormat());
        File file = new File(fileDescription.getPath());
        if (!file.exists() || !file.isFile()) {
            return;
        }
        try {
            Reader reader = this.getReader(fileDescription);
            SilverTrace.debug("indexEngine", "IndexManager.addFile", "root.MSG_GEN_PARAM_VALUE", "reader returned");
            if (reader != null) {
                SilverTrace.debug("indexEngine", "IndexManager.addFile", "root.MSG_GEN_PARAM_VALUE", "reader is not null");
                Field field = new Field(this.getFieldName(CONTENT, fileDescription.getLang()), reader);
                SilverTrace.debug("indexEngine", "IndexManager.addFile", "root.MSG_GEN_PARAM_VALUE", "doc = " + field.name() + ", field = " + field.toString());
                doc.add((Fieldable)field);
            }
        }
        catch (Throwable e) {
            SilverTrace.error("indexEngine", "IndexManager", "indexEngine.MSG_FILE_PARSING_FAILED", fileDescription.getPath(), e);
        }
    }

    private boolean isWysiwyg(FullIndexEntry indexEntry) {
        return "Wysiwyg".equals(indexEntry.getObjectType()) && (indexEntry.getComponent().startsWith("kmelia") || indexEntry.getComponent().startsWith("kmax"));
    }

    static {
        ResourceLocator resource = new ResourceLocator("org.silverpeas.search.indexEngine.IndexEngine", "");
        maxFieldLength = resource.getInteger("lucene.maxFieldLength", maxFieldLength);
        mergeFactor = resource.getInteger("lucene.mergeFactor", mergeFactor);
        maxMergeDocs = resource.getInteger("lucene.maxMergeDocs", maxMergeDocs);
        String stringValue = resource.getString("lucene.RAMBufferSizeMB", Double.toString(16.0));
        RAMBufferSizeMB = Double.parseDouble(stringValue);
        enableDymIndexing = resource.getBoolean("enableDymIndexing", false);
        serverName = resource.getString("server.name", "Silverpeas");
    }

    private class FlushIndexProcess
    implements IndexProcessor.FlushIndexProcess {
        private FlushIndexProcess() {
        }

        @Override
        public List<String> process() {
            ArrayList<String> pathProcessed = new ArrayList<String>(IndexManager.this.indexWriters.size());
            Iterator it = IndexManager.this.indexWriters.entrySet().iterator();
            SilverTrace.debug("searchEngine", "IndexManager.getIndexReader()", MessageFormat.format("flushing manager of indexation about {0} writer(s)", IndexManager.this.indexWriters.size()));
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String path = (String)entry.getKey();
                IndexWriter writer = (IndexWriter)entry.getValue();
                pathProcessed.add(path);
                SilverTrace.debug("searchEngine", "IndexManager.getIndexReader()", MessageFormat.format("\t- closing writer of path {0}", path));
                try {
                    writer.close();
                }
                catch (IOException e) {
                    SilverTrace.error("searchEngine", "IndexManager.getIndexReader()", "Cannot close index " + path, e);
                }
                if (enableDymIndexing) {
                    DidYouMeanIndexer.createSpellIndexForAllLanguage(IndexManager.CONTENT, path);
                }
                it.remove();
            }
            return pathProcessed;
        }
    }
}

