/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.search.indexEngine.model;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class IndexReadersCache {
    private static final Object READER_MUTEX = new Object();
    private static final Map<String, IndexReader> INDEX_READERS = new HashMap<String, IndexReader>();

    private IndexReadersCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IndexReader getIndexReader(String path) {
        Object object = READER_MUTEX;
        synchronized (object) {
            File rootPath = new File(path);
            IndexReader indexReader = INDEX_READERS.get(path);
            if (indexReader == null && rootPath.exists()) {
                try {
                    indexReader = IndexReader.open((Directory)FSDirectory.open((File)rootPath));
                    INDEX_READERS.put(path, indexReader);
                }
                catch (Exception e) {
                    SilverTrace.warn("searchEngine", "IndexManager.getIndexReader()", "searchEngine.MSG_CANT_OPEN_INDEX_SEARCHER", e);
                }
            } else if (indexReader != null && !rootPath.exists()) {
                SilverTrace.warn("searchEngine", "IndexManager.getIndexReader()", "searchEngine.MSG_CANT_OPEN_INDEX_SEARCHER", "index reader exists in cache but no index path is existing! (" + path + ")");
                IndexReadersCache.closeIndexReader(path);
                indexReader = null;
            }
            return indexReader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void closeIndexReader(String path) {
        Object object = READER_MUTEX;
        synchronized (object) {
            IndexReader indexReader = INDEX_READERS.remove(path);
            if (indexReader != null) {
                try {
                    indexReader.close();
                }
                catch (IOException e) {
                    SilverTrace.warn("indexEngine", "IndexManager.removeIndexReader", "indexEngine.MSG_CANT_CLOSE_INDEX_SEARCHER", path, e);
                }
            }
        }
    }
}

