/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.util.crypto;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.silverpeas.util.crypto.CryptoException;
import org.silverpeas.util.crypto.PKS12KeyStore;

public class PKS12KeyStoreWallet {
    private static final PKS12KeyStoreWallet instance = new PKS12KeyStoreWallet();
    private static final Map<String, PKS12KeyStore> keyMap = new ConcurrentHashMap<String, PKS12KeyStore>();

    public static final PKS12KeyStoreWallet getInstance() {
        return instance;
    }

    private PKS12KeyStoreWallet() {
    }

    public void addKeyStore(String keyFilePath, String password) throws CryptoException {
        try {
            PKS12KeyStore silverkeys = new PKS12KeyStore(keyFilePath, password);
            keyMap.put(keyFilePath, silverkeys);
        }
        catch (Exception e) {
            throw new CryptoException("Cannot create a PKS#12 key store from the file '" + keyFilePath + "'", e);
        }
    }

    public PKS12KeyStore getKeyStore(String keyFilePath) throws CryptoException {
        PKS12KeyStore keyStore = keyMap.get(keyFilePath);
        if (keyStore != null) {
            return keyStore;
        }
        throw new CryptoException("PKS#12 key store not found");
    }
}

