/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.util.memory;

import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.util.ResourceLocator;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.silverpeas.notification.message.MessageManager;

public enum MemoryUnit {
    B(1, "o", "bytes"),
    KB(2, "ko", "Kb"),
    MB(3, "mo", "Mb"),
    GB(4, "go", "Gb"),
    TB(5, "to", "Tb");

    private final String bundleKey;
    private final String bundleDefault;
    private BigDecimal limit = null;
    private final int power;
    private static final Map<String, ResourceLocator> multilang;
    static BigDecimal byteMultiplier;

    private MemoryUnit(int power, String bundleKey, String bundleDefault) {
        this.bundleKey = bundleKey;
        this.bundleDefault = bundleDefault;
        this.limit = null;
        this.power = power;
    }

    protected String getBundleKey() {
        return this.bundleKey;
    }

    protected String getBundleDefault() {
        return this.bundleDefault;
    }

    public String getLabel() {
        return StringUtil.defaultStringIfNotDefined(MemoryUnit.getStringTranslation(this.getBundleKey()), this.getBundleDefault());
    }

    public BigDecimal getLimit() {
        if (this.limit == null) {
            this.limit = byteMultiplier.pow(this.power);
        }
        return this.limit;
    }

    public int getPower() {
        return this.power;
    }

    private static String getStringTranslation(String key) {
        String language = MessageManager.getLanguage();
        ResourceLocator rl = multilang.get(language);
        if (rl == null) {
            rl = new ResourceLocator("org.silverpeas.util.multilang.util", language);
            multilang.put(language, rl);
        }
        return rl.getString(key, null);
    }

    static {
        multilang = new HashMap<String, ResourceLocator>();
        byteMultiplier = new BigDecimal(String.valueOf(1024));
    }
}

