/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.util.time;

import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.util.ResourceLocator;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.silverpeas.notification.message.MessageManager;
import org.silverpeas.util.time.TimeConversionBoardKey;

public enum TimeUnit {
    MILLI("ms"),
    SEC("s"),
    MIN("m"),
    HOUR("h"),
    DAY("d"),
    WEEK("w"),
    MONTH("M"),
    YEAR("y");

    private final String bundleDefault;
    private static final Map<TimeConversionBoardKey, BigDecimal> conversionBoard;
    private static final Map<String, ResourceLocator> multilang;

    private TimeUnit(String bundleDefault) {
        this.bundleDefault = bundleDefault;
    }

    protected String getBundleKey() {
        return this.name();
    }

    protected String getBundleDefault() {
        return this.bundleDefault;
    }

    public String getLabel() {
        return StringUtil.defaultStringIfNotDefined(TimeUnit.getStringTranslation(this.getBundleKey()), this.getBundleDefault());
    }

    public BigDecimal getMultiplier(TimeUnit to) {
        return conversionBoard.get(new TimeConversionBoardKey(this, to));
    }

    private static String getStringTranslation(String key) {
        String language = MessageManager.getLanguage();
        ResourceLocator rl = multilang.get(language);
        if (rl == null) {
            rl = new ResourceLocator("org.silverpeas.util.multilang.util", language);
            multilang.put(language, rl);
        }
        return rl.getString(key, null);
    }

    static {
        conversionBoard = new HashMap<TimeConversionBoardKey, BigDecimal>();
        conversionBoard.put(new TimeConversionBoardKey(MILLI, SEC), new BigDecimal("1000"));
        conversionBoard.put(new TimeConversionBoardKey(MILLI, MIN), new BigDecimal("1000").multiply(new BigDecimal("60")));
        conversionBoard.put(new TimeConversionBoardKey(MILLI, HOUR), new BigDecimal("1000").multiply(new BigDecimal("60")).multiply(new BigDecimal("60")));
        conversionBoard.put(new TimeConversionBoardKey(MILLI, DAY), new BigDecimal("1000").multiply(new BigDecimal("60")).multiply(new BigDecimal("60")).multiply(new BigDecimal("24")));
        conversionBoard.put(new TimeConversionBoardKey(MILLI, WEEK), new BigDecimal("1000").multiply(new BigDecimal("60")).multiply(new BigDecimal("60")).multiply(new BigDecimal("24")).multiply(new BigDecimal("7")));
        conversionBoard.put(new TimeConversionBoardKey(MILLI, MONTH), new BigDecimal("1000").multiply(new BigDecimal("60")).multiply(new BigDecimal("60")).multiply(new BigDecimal("24")).multiply(new BigDecimal("365").divide(new BigDecimal("12"), 30, 5)));
        conversionBoard.put(new TimeConversionBoardKey(MILLI, YEAR), new BigDecimal("1000").multiply(new BigDecimal("60")).multiply(new BigDecimal("60")).multiply(new BigDecimal("24")).multiply(new BigDecimal("365")));
        conversionBoard.put(new TimeConversionBoardKey(SEC, MIN), new BigDecimal("60"));
        conversionBoard.put(new TimeConversionBoardKey(SEC, HOUR), new BigDecimal("60").multiply(new BigDecimal("60")));
        conversionBoard.put(new TimeConversionBoardKey(SEC, DAY), new BigDecimal("60").multiply(new BigDecimal("60")).multiply(new BigDecimal("24")));
        conversionBoard.put(new TimeConversionBoardKey(SEC, WEEK), new BigDecimal("60").multiply(new BigDecimal("60")).multiply(new BigDecimal("24")).multiply(new BigDecimal("7")));
        conversionBoard.put(new TimeConversionBoardKey(SEC, MONTH), new BigDecimal("60").multiply(new BigDecimal("60")).multiply(new BigDecimal("24")).multiply(new BigDecimal("365").divide(new BigDecimal("12"), 30, 5)));
        conversionBoard.put(new TimeConversionBoardKey(SEC, YEAR), new BigDecimal("60").multiply(new BigDecimal("60")).multiply(new BigDecimal("24")).multiply(new BigDecimal("365")));
        conversionBoard.put(new TimeConversionBoardKey(MIN, HOUR), new BigDecimal("60"));
        conversionBoard.put(new TimeConversionBoardKey(MIN, DAY), new BigDecimal("60").multiply(new BigDecimal("24")));
        conversionBoard.put(new TimeConversionBoardKey(MIN, WEEK), new BigDecimal("60").multiply(new BigDecimal("24")).multiply(new BigDecimal("7")));
        conversionBoard.put(new TimeConversionBoardKey(MIN, MONTH), new BigDecimal("60").multiply(new BigDecimal("24")).multiply(new BigDecimal("365").divide(new BigDecimal("12"), 30, 5)));
        conversionBoard.put(new TimeConversionBoardKey(MIN, YEAR), new BigDecimal("60").multiply(new BigDecimal("24")).multiply(new BigDecimal("365")));
        conversionBoard.put(new TimeConversionBoardKey(HOUR, DAY), new BigDecimal("24"));
        conversionBoard.put(new TimeConversionBoardKey(HOUR, WEEK), new BigDecimal("24").multiply(new BigDecimal("7")));
        conversionBoard.put(new TimeConversionBoardKey(HOUR, MONTH), new BigDecimal("24").multiply(new BigDecimal("365").divide(new BigDecimal("12"), 30, 5)));
        conversionBoard.put(new TimeConversionBoardKey(HOUR, YEAR), new BigDecimal("24").multiply(new BigDecimal("365")));
        conversionBoard.put(new TimeConversionBoardKey(DAY, WEEK), new BigDecimal("7"));
        conversionBoard.put(new TimeConversionBoardKey(DAY, MONTH), new BigDecimal("365").divide(new BigDecimal("12"), 30, 5));
        conversionBoard.put(new TimeConversionBoardKey(DAY, YEAR), new BigDecimal("365"));
        conversionBoard.put(new TimeConversionBoardKey(WEEK, MONTH), new BigDecimal("52").divide(new BigDecimal("12"), 30, 5));
        conversionBoard.put(new TimeConversionBoardKey(WEEK, YEAR), new BigDecimal("52"));
        conversionBoard.put(new TimeConversionBoardKey(MONTH, YEAR), new BigDecimal("12"));
        multilang = new HashMap<String, ResourceLocator>();
    }
}

