/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.viewer;

import com.stratelia.webactiv.util.DateUtil;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.silverpeas.util.data.TemporaryDataManagementSettings;
import org.silverpeas.util.data.TemporaryWorkspaceTranslation;
import org.silverpeas.viewer.ViewerContext;
import org.silverpeas.viewer.ViewerSettings;

public abstract class AbstractViewerService {
    private static final Object OBJECT_FOR_SYNC = new Object();
    private static final ConcurrentMap<String, Object> cache = new ConcurrentHashMap<String, Object>();
    public static final String PDF_DOCUMENT_EXTENSION = "pdf";

    protected File generateTmpFile(ViewerContext viewerContext, String fileExtension) {
        TemporaryWorkspaceTranslation workspace = viewerContext.getWorkspace();
        if (!workspace.exists()) {
            workspace.getRootPath().mkdirs();
        }
        return new File(workspace.getRootPath(), "file." + fileExtension);
    }

    protected File changeFileExtension(File file, String fileExtension) {
        return new File(FilenameUtils.getFullPath((String)file.getPath()) + FilenameUtils.getBaseName((String)file.getPath()) + "." + fileExtension);
    }

    protected <RETURN_VALUE extends Serializable> ViewerProcess<RETURN_VALUE> process(String processName, ViewerTreatment<RETURN_VALUE> viewerTreatment) {
        return new ViewerProcess<RETURN_VALUE>(processName, viewerTreatment);
    }

    protected abstract class ViewerTreatment<RETURN_VALUE> {
        protected ViewerTreatment() {
        }

        public abstract RETURN_VALUE execute();

        public RETURN_VALUE performAfterSuccess(RETURN_VALUE result) {
            return result;
        }
    }

    protected final class ViewerProcess<RETURN_VALUE extends Serializable> {
        private static final String CACHE_WORKSPACE_KEY_PREFIX = "workspace_viewer_services_";
        private static final String CACHE_RESULT_KEY = "cache_result";
        private final String processName;
        private final ViewerTreatment<RETURN_VALUE> viewerTreatment;

        protected ViewerProcess(String processName, ViewerTreatment<RETURN_VALUE> viewerTreatment) {
            this.processName = processName;
            this.viewerTreatment = viewerTreatment;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Pair<TemporaryWorkspaceTranslation, Semaphore> initialize(ViewerContext viewerContext) {
            Object object = OBJECT_FOR_SYNC;
            synchronized (object) {
                TemporaryWorkspaceTranslation workspace;
                block10: {
                    String workspaceCacheKey = CACHE_WORKSPACE_KEY_PREFIX + viewerContext.getViewId();
                    workspace = (TemporaryWorkspaceTranslation)cache.get(workspaceCacheKey);
                    if (workspace == null) {
                        workspace = viewerContext.getWorkspace();
                        cache.put(workspaceCacheKey, workspace);
                    }
                    if (workspace.exists()) {
                        if (workspace.lastModified() >= viewerContext.getOriginalSourceFile().lastModified()) {
                            Semaphore currentProcessing = (Semaphore)cache.get(workspace.getRootPath().getPath());
                            if (currentProcessing != null) {
                                return Pair.of((Object)workspace, (Object)currentProcessing);
                            }
                            if (workspace.get(CACHE_RESULT_KEY) == null) {
                                workspace.remove();
                                break block10;
                            } else {
                                if (ViewerSettings.isTimeToLiveEnabled()) {
                                    long fileAgeThreshold = DateUtil.getNow().getTime() - (long)((double)TemporaryDataManagementSettings.getTimeAfterThatFilesMustBeDeleted() * 0.25);
                                    if (workspace.lastModified() < fileAgeThreshold) {
                                        workspace.updateLastModifiedDate();
                                    }
                                }
                                return Pair.of((Object)workspace, (Object)new Semaphore(1));
                            }
                        }
                        workspace.remove();
                    }
                }
                viewerContext.processingCache();
                workspace.create();
                Semaphore newSemaphore = new Semaphore(1);
                cache.put(workspace.getRootPath().getPath(), newSemaphore);
                return Pair.of((Object)workspace, (Object)newSemaphore);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void finalize(ViewerContext viewerContext, Pair<TemporaryWorkspaceTranslation, Semaphore> init) {
            Object object = OBJECT_FOR_SYNC;
            synchronized (object) {
                String workspaceCacheKey = CACHE_WORKSPACE_KEY_PREFIX + viewerContext.getViewId();
                cache.remove(workspaceCacheKey);
                cache.remove(viewerContext.getWorkspace().getRootPath().getPath());
            }
            ((Semaphore)init.getValue()).release();
        }

        public RETURN_VALUE execute(ViewerContext viewerContext) {
            Object returnValue;
            viewerContext.fromInitializerProcessName(this.processName);
            if (!viewerContext.isCacheRequired()) {
                Serializable returnValue2 = (Serializable)this.viewerTreatment.execute();
                return (RETURN_VALUE)this.viewerTreatment.performAfterSuccess(returnValue2);
            }
            Pair<TemporaryWorkspaceTranslation, Semaphore> init = this.initialize(viewerContext);
            TemporaryWorkspaceTranslation workspace = (TemporaryWorkspaceTranslation)init.getKey();
            Semaphore semaphore = (Semaphore)init.getValue();
            try {
                semaphore.acquire();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            try {
                if (viewerContext.isProcessingCache()) {
                    returnValue = (Serializable)this.viewerTreatment.execute();
                    workspace.put(CACHE_RESULT_KEY, (Serializable)returnValue);
                } else {
                    returnValue = workspace.get(CACHE_RESULT_KEY);
                }
            }
            catch (RuntimeException re) {
                workspace.put(CACHE_RESULT_KEY, null);
                throw re;
            }
            finally {
                this.finalize(viewerContext, init);
            }
            return (RETURN_VALUE)((Serializable)this.viewerTreatment.performAfterSuccess(returnValue));
        }
    }
}

