/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.wysiwyg.control;

import java.util.ArrayList;
import java.util.List;
import org.silverpeas.wysiwyg.control.WysiwygContentTransformerDirective;
import org.silverpeas.wysiwyg.control.WysiwygContentTransformerProcess;
import org.silverpeas.wysiwyg.control.directive.ImageUrlAccordingToHtmlSizeDirective;
import org.silverpeas.wysiwyg.control.result.MailContentProcess;

public class WysiwygContentTransformer {
    private final String wysiwygContent;
    private final List<WysiwygContentTransformerDirective> directives = new ArrayList<WysiwygContentTransformerDirective>();

    public static WysiwygContentTransformer on(String wysiwygContent) {
        return new WysiwygContentTransformer(wysiwygContent);
    }

    private WysiwygContentTransformer(String wysiwygContent) {
        this.wysiwygContent = wysiwygContent;
    }

    public WysiwygContentTransformer modifyImageUrlAccordingToHtmlSizeDirective() {
        this.directives.add(new ImageUrlAccordingToHtmlSizeDirective());
        return this;
    }

    public String transform() {
        String transformedWysiwyg = this.wysiwygContent;
        for (WysiwygContentTransformerDirective directive : this.directives) {
            transformedWysiwyg = directive.execute(transformedWysiwyg);
        }
        return transformedWysiwyg;
    }

    public <TYPED_RESULT> TYPED_RESULT transform(WysiwygContentTransformerProcess<TYPED_RESULT> process) throws Exception {
        return process.execute(this.transform());
    }

    public MailContentProcess.MailResult toMailContent() throws Exception {
        return this.modifyImageUrlAccordingToHtmlSizeDirective().transform(new MailContentProcess());
    }
}

