/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.context;

import java.awt.Cursor;
import java.awt.Frame;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.JOptionPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import wjhk.jupload2.context.JUploadContext;
import wjhk.jupload2.context.JavascriptHandler;
import wjhk.jupload2.exception.JUploadException;
import wjhk.jupload2.gui.JUploadPanel;
import wjhk.jupload2.gui.JUploadPanelImpl;
import wjhk.jupload2.gui.JUploadTextArea;
import wjhk.jupload2.policies.UploadPolicy;
import wjhk.jupload2.policies.UploadPolicyFactory;
import wjhk.jupload2.upload.FileUploadManagerThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJUploadContext
implements JUploadContext {
    private static final String SVN_PROPERTIES_FILENAME = "/conf/svn.properties";
    Properties svnProperties = DefaultJUploadContext.getSvnProperties();
    Frame frame = null;
    JavascriptHandler jsHandler = null;
    Properties mimeTypesProperties = null;
    UploadPolicy uploadPolicy = null;
    JUploadPanel jUploadPanel = null;
    JUploadTextArea logWindow = null;
    List<Callback> unloadCallbacks = new ArrayList<Callback>(20);

    public void init(Frame frame, RootPaneContainer rootPaneContainer) {
        try {
            this.frame = frame;
            Thread.currentThread().setName(rootPaneContainer.getClass().getName());
            this.logWindow = new JUploadTextArea(20, 20, this.uploadPolicy);
            this.uploadPolicy = UploadPolicyFactory.getUploadPolicy(this);
            this.uploadPolicy.displayDebug("After UploadPolicyFactory.getUploadPolicy(this)", 80);
            this.uploadPolicy.displayDebug("Before this.logWindow.setUploadPolicy(this.uploadPolicy)", 80);
            this.logWindow.setUploadPolicy(this.uploadPolicy);
            this.uploadPolicy.displayDebug("Before new JUploadPanelImpl(this.logWindow,this.uploadPolicy)", 80);
            this.jUploadPanel = new JUploadPanelImpl(this.logWindow, this.uploadPolicy);
            this.uploadPolicy.displayDebug("Before rootPaneContainer.setContentPane(this.jUploadPanel);", 80);
            rootPaneContainer.setContentPane(this.jUploadPanel.getJComponent());
            this.uploadPolicy.displayDebug("Before new JavascriptHandler(this.uploadPolicy, this.jUploadPanel)", 80);
            this.jsHandler = new JavascriptHandler(this.uploadPolicy, this.jUploadPanel);
            this.jsHandler.start();
            this.registerUnload(this, "unload");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Error during applet initialization!\nHave a look in your Java console (" + e.getClass().getName() + ")", "Error", 0);
        }
        this.uploadPolicy.displayDebug("Before new Properties();", 80);
        this.mimeTypesProperties = new Properties();
        String mimetypePropertiesFilename = "/conf/mimetypes.properties";
        try {
            InputStream isProperties = this.getClass().getResourceAsStream("/conf/mimetypes.properties");
            this.mimeTypesProperties.load(isProperties);
            isProperties.close();
            this.uploadPolicy.displayDebug("Mime types list loaded Ok (/conf/mimetypes.properties)", 50);
        }
        catch (Exception e) {
            this.uploadPolicy.displayWarn("Unable to load the mime types list (/conf/mimetypes.properties): " + e.getClass().getName() + " (" + e.getMessage() + ")");
        }
        this.uploadPolicy.displayDebug("End of DefaultJUploadContext.init()", 80);
    }

    public void unload() {
        if (this.jsHandler != null && this.jsHandler.isAlive()) {
            this.jsHandler.interrupt();
            this.jsHandler = null;
        }
    }

    @Override
    public String getDetailedVersionMessage() {
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("V");
            sb.append(this.getVersion());
            sb.append(" [SVN-Rev: ");
            sb.append(this.getSvnRevision());
            sb.append("]");
            if (this.getBuildNumber() > 0) {
                sb.append(" build ");
                sb.append(this.getBuildNumber());
            }
            sb.append(" - ");
            sb.append(this.getBuildDate());
            return sb.toString();
        }
        catch (Exception e) {
            System.out.println(e.getClass().getName() + " in DefaultJUploadContext.getDetailedVersionMessage()");
            return this.getVersion();
        }
    }

    @Override
    public String getVersion() {
        return this.getProperty("jupload.version", "Unknown");
    }

    @Override
    public String getSvnRevision() {
        return this.getProperty("jupload.svn.revision", "Unknown");
    }

    @Override
    public String getLastModified() {
        return this.getProperty("jupload.lastSrcDirModificationDate", "Unknown");
    }

    @Override
    public String getBuildDate() {
        String defaultValue = "Unknown";
        String timestamp = this.getProperty("jupload.buildTimestamp", defaultValue);
        if (timestamp.equals(defaultValue)) {
            return defaultValue;
        }
        Locale locale = Locale.getDefault();
        if (this.uploadPolicy != null) {
            locale = this.uploadPolicy.getLocale();
        }
        MessageFormat msgFormat = new MessageFormat("{0,date,medium}", locale);
        Object[] args = new Object[]{new Date(Long.parseLong(timestamp))};
        return msgFormat.format(args);
    }

    @Override
    public int getBuildNumber() {
        return Integer.parseInt(this.getProperty("jupload.buildNumber", "0"));
    }

    private String getProperty(String propertyName, String defaultValue) {
        String value = null;
        try {
            value = this.svnProperties.getProperty(propertyName);
        }
        catch (Exception e) {
            System.out.println(e.getClass().getName() + " when getting the " + propertyName + " property (" + e.getMessage() + ")");
        }
        return value == null ? defaultValue : value;
    }

    @Override
    public JUploadTextArea getLogWindow() {
        return this.logWindow;
    }

    @Override
    public String getMimeType(String fileExtension) {
        String mimeType = this.mimeTypesProperties.getProperty(fileExtension.toLowerCase());
        return mimeType == null ? "application/octet-stream" : mimeType;
    }

    @Override
    public JUploadPanel getUploadPanel() {
        return this.jUploadPanel;
    }

    @Override
    public UploadPolicy getUploadPolicy() throws JUploadException {
        return this.uploadPolicy;
    }

    @Override
    public void setProperty(String prop, String value) {
        try {
            class PropertySetter
            implements Runnable {
                String prop;
                String value;

                PropertySetter(String prop, String value) {
                    this.prop = prop;
                    this.value = value;
                }

                public void run() {
                    try {
                        for (int i = 0; i < 20 && DefaultJUploadContext.this.uploadPolicy == null; ++i) {
                            this.wait(100L);
                        }
                        if (DefaultJUploadContext.this.uploadPolicy == null) {
                            System.out.println("uploadPolicy is null. Impossible to set " + this.prop + " to " + this.value);
                        } else {
                            DefaultJUploadContext.this.uploadPolicy.setProperty(this.prop, this.value);
                        }
                    }
                    catch (Exception e) {
                        DefaultJUploadContext.this.uploadPolicy.displayErr(e);
                    }
                }
            }
            SwingUtilities.invokeLater(new PropertySetter(prop, value));
        }
        catch (Exception e) {
            if (this.uploadPolicy != null) {
                this.uploadPolicy.displayErr(e);
            }
            System.out.println(e.getClass().getName() + ": " + e.getMessage());
        }
    }

    @Override
    public String startUpload() {
        return this.jsHandler.doCommand("startUpload");
    }

    public void displayErr(String err) {
        this.uploadPolicy.displayErr(err);
    }

    public void displayInfo(String info) {
        this.uploadPolicy.displayInfo(info);
    }

    public void displayWarn(String warn) {
        this.uploadPolicy.displayWarn(warn);
    }

    public void displayDebug(String debug, int minDebugLevel) {
        this.uploadPolicy.displayDebug(debug, minDebugLevel);
    }

    public static Properties getSvnProperties() {
        Properties properties = new Properties();
        Boolean bPropertiesLoaded = false;
        try {
            InputStream isProperties = Class.forName("wjhk.jupload2.JUploadApplet").getResourceAsStream(SVN_PROPERTIES_FILENAME);
            properties.load(isProperties);
            isProperties.close();
            bPropertiesLoaded = true;
        }
        catch (Exception e) {
            System.out.println(e.getClass().getName() + " in DefaultJUploadContext.getSvnProperties() (" + e.getMessage() + ")");
        }
        if (!bPropertiesLoaded.booleanValue()) {
            properties.setProperty("buildDate", "Unknown build date (please use the build.xml ant script)");
            properties.setProperty("lastSrcDirModificationDate", "Unknown last modification date (please use the build.xml ant script)");
            properties.setProperty("revision", "Unknown revision (please use the build.xml ant script)");
        }
        return properties;
    }

    @Override
    public void registerUnload(Object object, String method) {
        this.unloadCallbacks.add(0, new Callback(object, method));
    }

    @Override
    public synchronized void runUnload() {
        FileUploadManagerThread fileUploadManagerThread = this.getUploadPanel().getFileUploadManagerThread();
        if (fileUploadManagerThread != null) {
            fileUploadManagerThread.stopUpload();
        }
        for (Callback callback : this.unloadCallbacks) {
            try {
                callback.invoke();
            }
            catch (Exception e) {
                System.out.println(e.getClass().getName() + " while calling the callback: " + callback.getObject().getClass().getName() + "." + callback.getMethod());
                e.printStackTrace();
            }
        }
        this.unloadCallbacks.clear();
    }

    void displayDebugParameterValue(String key, String value) {
        if (this.uploadPolicy != null && this.uploadPolicy.getDebugLevel() >= 80) {
            this.uploadPolicy.displayDebug("Parameter '" + key + "' loaded. Value: " + value, 80);
        }
    }

    @Override
    public int parseInt(String value, int def) {
        int ret;
        block2: {
            ret = def;
            try {
                ret = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                ret = def;
                if (this.uploadPolicy == null) break block2;
                this.uploadPolicy.displayWarn("Invalid int value: " + value + ", using default value: " + def);
            }
        }
        return ret;
    }

    @Override
    public float parseFloat(String value, float def) {
        float ret;
        block2: {
            ret = def;
            try {
                ret = Float.parseFloat(value);
            }
            catch (NumberFormatException e) {
                ret = def;
                if (this.uploadPolicy == null) break block2;
                this.uploadPolicy.displayWarn("Invalid float value: " + value + ", using default value: " + def);
            }
        }
        return ret;
    }

    @Override
    public long parseLong(String value, long def) {
        long ret;
        block2: {
            ret = def;
            try {
                ret = Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                ret = def;
                if (this.uploadPolicy == null) break block2;
                this.uploadPolicy.displayWarn("Invalid long value: " + value + ", using default value: " + def);
            }
        }
        return ret;
    }

    @Override
    public boolean parseBoolean(String value, boolean def) {
        if (value.toUpperCase().equals("FALSE")) {
            return false;
        }
        if (value.toUpperCase().equals("TRUE")) {
            return true;
        }
        if (this.uploadPolicy != null) {
            this.uploadPolicy.displayWarn("Invalid boolean value: " + value + ", using default value: " + def);
        }
        return def;
    }

    @Override
    public Cursor setWaitCursor() {
        return this.setCursor(new Cursor(3));
    }

    @Override
    public void displayURL(String url, boolean success) {
        throw new UnsupportedOperationException("DefaultJUploadContext.setCursor()");
    }

    @Override
    public JApplet getApplet() {
        throw new UnsupportedOperationException("DefaultJUploadContext.setCursor()");
    }

    @Override
    public Frame getFrame() {
        return this.frame;
    }

    @Override
    public Cursor getCursor() {
        throw new UnsupportedOperationException("DefaultJUploadContext.setCursor()");
    }

    @Override
    public String getParameter(String key, String def) {
        throw new UnsupportedOperationException("DefaultJUploadContext.setCursor()");
    }

    @Override
    public int getParameter(String key, int def) {
        throw new UnsupportedOperationException("DefaultJUploadContext.setCursor()");
    }

    @Override
    public float getParameter(String key, float def) {
        throw new UnsupportedOperationException("DefaultJUploadContext.setCursor()");
    }

    @Override
    public long getParameter(String key, long def) {
        throw new UnsupportedOperationException("DefaultJUploadContext.setCursor()");
    }

    @Override
    public boolean getParameter(String key, boolean def) {
        throw new UnsupportedOperationException("DefaultJUploadContext.setCursor()");
    }

    @Override
    public String normalizeURL(String url) throws JUploadException {
        throw new UnsupportedOperationException("DefaultJUploadContext.setCursor()");
    }

    @Override
    public void readCookieFromNavigator(Vector<String> headers) {
        throw new UnsupportedOperationException("DefaultJUploadContext.readCookieFromNavigator()");
    }

    @Override
    public void readUserAgentFromNavigator(Vector<String> headers) {
        throw new UnsupportedOperationException("DefaultJUploadContext.readUserAgentFromNavigator()");
    }

    @Override
    public Cursor setCursor(Cursor cursor) {
        throw new UnsupportedOperationException("DefaultJUploadContext.setCursor()");
    }

    @Override
    public void showStatus(String status) {
        throw new UnsupportedOperationException("DefaultJUploadContext.showStatus()");
    }

    static class Callback {
        private String method;
        private Object object;

        Callback(Object object, String method) {
            this.object = object;
            this.method = method;
        }

        void invoke() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException {
            Object[] args = new Object[]{};
            Method[] methods = this.object.getClass().getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals(this.method)) continue;
                methods[i].invoke(this.object, args);
            }
        }

        public String getMethod() {
            return this.method;
        }

        public Object getObject() {
            return this.object;
        }
    }
}

