/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.policies;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.dnd.DropTargetDropEvent;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.swing.BoxLayout;
import wjhk.jupload2.context.JUploadContext;
import wjhk.jupload2.exception.JUploadException;
import wjhk.jupload2.gui.JUploadPanel;
import wjhk.jupload2.policies.DefaultUploadPolicy;

public class SilverpeasUploadPolicy
extends DefaultUploadPolicy {
    public static final String MESSAGE_URL = "message";
    public static final String COLOR_RED = "bgcolor_r";
    public static final String COLOR_BLUE = "bgcolor_b";
    public static final String COLOR_GREEN = "bgcolor_g";
    public static final String COLOR_ALPHA = "bgcolor_a";

    public SilverpeasUploadPolicy(JUploadContext juploadContext) throws JUploadException {
        super(juploadContext);
        this.setNbFilesPerRequest(20);
        this.displayInfo("Loading SilverpeasUploadPolicy ...");
    }

    public void addComponentsToJUploadPanel(JUploadPanel jUploadPanel) {
        this.displayInfo("Displaying SilverpeasUploadPolicy ...");
        jUploadPanel.getJComponent().setLayout(new BoxLayout(jUploadPanel.getJComponent(), 1));
        this.displayInfo("Accessing the message " + this.getMessage());
        Color color = new Color(this.getContext().getParameter(COLOR_RED, Color.LIGHT_GRAY.getRed()), this.getContext().getParameter(COLOR_GREEN, Color.LIGHT_GRAY.getGreen()), this.getContext().getParameter(COLOR_BLUE, Color.LIGHT_GRAY.getBlue()), this.getContext().getParameter(COLOR_ALPHA, Color.LIGHT_GRAY.getAlpha()));
        jUploadPanel.getJComponent().setBackground(color);
        jUploadPanel.getStatusLabel().setBackground(color);
        jUploadPanel.getUploadProgressBar().setBackground(color);
        jUploadPanel.getStatusLabel().setText(this.getMessage());
        jUploadPanel.getStatusLabel().setHorizontalAlignment(0);
        jUploadPanel.getStatusLabel().setVerticalAlignment(0);
        Dimension appletSize = this.getContext().getApplet().getSize();
        Dimension preferredAppletSize = this.getContext().getApplet().getPreferredSize();
        Dimension maxAppletSize = this.getContext().getApplet().getMaximumSize();
        jUploadPanel.getStatusLabel().setAlignmentX(0.5f);
        jUploadPanel.getStatusLabel().setAlignmentY(0.5f);
        jUploadPanel.getStatusLabel().setPreferredSize(new Dimension(preferredAppletSize.width, preferredAppletSize.height - 25));
        jUploadPanel.getStatusLabel().setSize(new Dimension(appletSize.width, appletSize.height - 25));
        jUploadPanel.getStatusLabel().setMaximumSize(new Dimension(maxAppletSize.width, maxAppletSize.height - 25));
        jUploadPanel.getStatusLabel().setMinimumSize(new Dimension(appletSize.width, appletSize.height - 25));
        jUploadPanel.getStatusLabel().setBackground(new Color(0));
        jUploadPanel.getJComponent().add(jUploadPanel.getStatusLabel());
        jUploadPanel.getJComponent().setAlignmentX(0.5f);
        jUploadPanel.getUploadProgressBar().setAlignmentX(0.5f);
        jUploadPanel.getUploadProgressBar().setAlignmentY(0.5f);
        jUploadPanel.getUploadProgressBar().setPreferredSize(new Dimension(preferredAppletSize.width, 20));
        jUploadPanel.getUploadProgressBar().setSize(new Dimension(appletSize.width, 20));
        jUploadPanel.getUploadProgressBar().setMaximumSize(new Dimension(maxAppletSize.width, 20));
        jUploadPanel.getUploadProgressBar().setMinimumSize(new Dimension(appletSize.width, 20));
        jUploadPanel.getUploadProgressBar().setStringPainted(false);
        jUploadPanel.getUploadProgressBar().setBorderPainted(false);
        jUploadPanel.getJComponent().add(jUploadPanel.getUploadProgressBar());
        jUploadPanel.showOrHideLogWindow();
        jUploadPanel.getJComponent().add(jUploadPanel.getJLogWindowPane());
        this.displayInfo("Displaying SilverpeasUploadPolicy ...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getMessage() {
        String urlContent;
        this.displayInfo("The message to be displayed is " + this.juploadContext.getParameter(MESSAGE_URL, ""));
        String content = urlContent = this.juploadContext.getParameter(MESSAGE_URL, "");
        HttpURLConnection connection = null;
        BufferedReader in = null;
        try {
            URL url = new URL(urlContent);
            connection = (HttpURLConnection)url.openConnection();
            connection.connect();
            in = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
            this.displayInfo("Getting data ...");
            CharArrayWriter text = new CharArrayWriter();
            int size = 0;
            char[] buffer = new char[8];
            while ((size = in.read(buffer)) >= 0) {
                text.write(buffer, 0, size);
            }
            content = text.toString();
        }
        catch (IOException ioex) {
            this.displayErr(ioex);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                this.displayErr(ex);
            }
            connection.disconnect();
        }
        return content;
    }

    public void afterFileDropped(DropTargetDropEvent dropEvent) {
        this.getContext().getUploadPanel().doStartUpload();
    }
}

