/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.dbbuilder;

import com.silverpeas.dbbuilder.Console;
import com.silverpeas.dbbuilder.DBBuilderDBItem;
import com.silverpeas.dbbuilder.DBBuilderDBProcPiece;
import com.silverpeas.dbbuilder.DBBuilderDynamicLibPiece;
import com.silverpeas.dbbuilder.DBBuilderFileItem;
import com.silverpeas.dbbuilder.DBBuilderItem;
import com.silverpeas.dbbuilder.DBBuilderMultipleStatementPiece;
import com.silverpeas.dbbuilder.DBBuilderPiece;
import com.silverpeas.dbbuilder.DBBuilderSingleStatementPiece;
import com.silverpeas.dbbuilder.DBXmlDocument;
import com.silverpeas.dbbuilder.VersionTag;
import com.silverpeas.dbbuilder.sql.ConnectionFactory;
import com.silverpeas.dbbuilder.sql.FileInformation;
import com.silverpeas.dbbuilder.sql.InstallSQLInstruction;
import com.silverpeas.dbbuilder.sql.MetaInstructions;
import com.silverpeas.dbbuilder.sql.RemoveSQLInstruction;
import com.silverpeas.dbbuilder.sql.SQLInstruction;
import com.silverpeas.dbbuilder.sql.UninstallInformations;
import com.silverpeas.dbbuilder.sql.UninstallSQLInstruction;
import com.silverpeas.dbbuilder.util.Action;
import com.silverpeas.dbbuilder.util.CommandLineParameters;
import com.silverpeas.dbbuilder.util.Configuration;
import com.silverpeas.dbbuilder.util.DatabaseType;
import com.silverpeas.file.FileUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.Element;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class DBBuilder {
    public static final Date TODAY = new Date();
    public static final String DBBuilderAppVersion = "V5";
    protected static Console log;
    public static final String CREATE_TABLE_TAG = "create_table";
    public static final String CREATE_INDEX_TAG = "create_index";
    public static final String CREATE_CONSTRAINT_TAG = "create_constraint";
    public static final String CREATE_DATA_TAG = "init";
    public static final String DROP_TABLE_TAG = "drop_table";
    public static final String DROP_INDEX_TAG = "drop_index";
    public static final String DROP_CONSTRAINT_TAG = "drop_constraint";
    public static final String DROP_DATA_TAG = "clean";
    private static final String[] TAGS_TO_MERGE_4_INSTALL;
    private static final String[] TAGS_TO_MERGE_4_UNINSTALL;
    private static final String[] TAGS_TO_MERGE_4_ALL;
    private static final String[] TAGS_TO_MERGE_4_OPTIMIZE;
    protected static final String FIRST_DBCONTRIBUTION_FILE = "dbbuilder-contribution.xml";
    protected static final String MASTER_DBCONTRIBUTION_FILE = "master-contribution.xml";
    protected static final String REQUIREMENT_TAG = "requirement";
    protected static final String DEPENDENCY_TAG = "dependency";
    protected static final String FILE_TAG = "file";
    protected static final String FILENAME_ATTRIB = "name";
    protected static final String PRODUCT_TAG = "product";
    protected static final String PRODUCTNAME_ATTRIB = "name";
    private static Properties dbBuilderResources;
    protected static final String DBBUILDER_MODULE = "dbbuilder";
    private static CommandLineParameters params;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Logger.getLogger("org.springframework").setLevel(Level.SEVERE);
        new ClassPathXmlApplicationContext("classpath:/spring-jdbc-datasource.xml");
        try {
            System.out.println("Start Database build using Silverpeas DBBuilder v. V5 (" + TODAY + ").");
            log = new Console("DBBuilder.log");
            DBBuilder.printMessageln(Console.NEW_LINE + "*************************************************************");
            DBBuilder.printMessageln("Start Database Build using Silverpeas DBBuilder v. V5 (" + TODAY + ").");
            dbBuilderResources = Configuration.loadResource("/com/stratelia/silverpeas/dbBuilder/settings/dbBuilderSettings.properties");
            params = new CommandLineParameters(args);
            if (params.isSimulate() && DatabaseType.ORACLE == params.getDbType()) {
                throw new Exception("Simulate mode is not allowed for Oracle target databases.");
            }
            DBBuilder.printMessageln(Console.NEW_LINE);
            DBBuilder.printMessageln("Parameters are :");
            DBBuilder.printMessage(ConnectionFactory.getConnectionInfo());
            DBBuilder.printMessageln(Console.NEW_LINE);
            DBBuilder.printMessageln("\tAction        : " + (Object)((Object)params.getAction()));
            DBBuilder.printMessageln("\tVerbose mode  : " + params.isVerbose());
            DBBuilder.printMessageln("\tSimulate mode : " + params.isSimulate());
            if (Action.ACTION_CONNECT == params.getAction()) {
                DBBuilder.printMessageln(Console.NEW_LINE);
                DBBuilder.printMessageln("Connection to database successfull.");
                System.out.println(Console.NEW_LINE + "Connection to database successfull.");
            } else {
                DBBuilder.printMessageln(Console.NEW_LINE + "DB Status before build :");
                List<String> packagesIntoDB = DBBuilder.checkDBStatus();
                MetaInstructions sqlMetaInstructions = new MetaInstructions();
                File dirXml = new File(params.getDbType().getDBContributionDir());
                DBXmlDocument destXml = new DBXmlDocument(dirXml, MASTER_DBCONTRIBUTION_FILE);
                if (!destXml.getPath().exists()) {
                    destXml.getPath().createNewFile();
                    BufferedWriter destXmlOut = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(destXml.getPath(), false), "UTF-8"));
                    destXmlOut.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    destXmlOut.newLine();
                    destXmlOut.write("<allcontributions>");
                    destXmlOut.newLine();
                    destXmlOut.write("</allcontributions>");
                    destXmlOut.newLine();
                    destXmlOut.flush();
                    destXmlOut.close();
                }
                destXml.load();
                UninstallInformations processesToCacheIntoDB = new UninstallInformations();
                Object[] listeFileXml = dirXml.listFiles();
                Arrays.sort(listeFileXml);
                ArrayList<DBXmlDocument> listeDBXmlDocument = new ArrayList<DBXmlDocument>(listeFileXml.length);
                DBBuilder.printMessageln(Console.NEW_LINE);
                DBBuilder.printMessageln("Ignored contribution files are :");
                int ignoredFiles = 0;
                for (Object f : listeFileXml) {
                    if (!((File)f).isFile() || !"xml".equals(FileUtil.getExtension((File)f)) || FIRST_DBCONTRIBUTION_FILE.equalsIgnoreCase(((File)f).getName()) || MASTER_DBCONTRIBUTION_FILE.equalsIgnoreCase(((File)f).getName())) continue;
                    DBXmlDocument fXml = new DBXmlDocument(dirXml, ((File)f).getName());
                    fXml.load();
                    if (!DBBuilder.checkRequired((File[])listeFileXml, fXml)) {
                        DBBuilder.printMessageln("\t" + ((File)f).getName() + " (because of unresolved requirements).");
                        ++ignoredFiles;
                        continue;
                    }
                    if (Action.ACTION_ENFORCE_UNINSTALL == params.getAction()) {
                        DBBuilder.printMessageln("\t" + ((File)f).getName() + " (because of " + (Object)((Object)Action.ACTION_ENFORCE_UNINSTALL) + " mode).");
                        ++ignoredFiles;
                        continue;
                    }
                    listeDBXmlDocument.add(fXml);
                }
                if (ignoredFiles == 0) {
                    DBBuilder.printMessageln("\t(none)");
                }
                HashMap packagesIntoFile = new HashMap();
                try {
                    DBXmlDocument[] bidon = DBBuilder.checkDependencies(listeDBXmlDocument);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ArrayList<DBXmlDocument> orderedlisteDBXmlDocument = listeDBXmlDocument;
                int j = 0;
                DBBuilder.printMessageln(Console.NEW_LINE);
                DBBuilder.printMessageln("Merged contribution files are :");
                DBBuilder.printMessageln(params.getAction().toString());
                if (Action.ACTION_ENFORCE_UNINSTALL != params.getAction()) {
                    DBBuilder.printMessageln("\tdbbuilder-contribution.xml");
                    ++j;
                }
                for (DBXmlDocument currentDoc : orderedlisteDBXmlDocument) {
                    DBBuilder.printMessageln("\t" + currentDoc.getName());
                    ++j;
                }
                if (j == 0) {
                    DBBuilder.printMessageln("\t(none)");
                }
                DBBuilder.printMessageln(Console.NEW_LINE);
                DBBuilder.printMessageln("Build decisions are :");
                DBXmlDocument fileXml = null;
                if (Action.ACTION_ENFORCE_UNINSTALL != params.getAction()) {
                    try {
                        fileXml = new DBXmlDocument(dirXml, FIRST_DBCONTRIBUTION_FILE);
                        fileXml.load();
                    }
                    catch (Exception e) {
                        fileXml = null;
                    }
                    if (fileXml != null) {
                        DBBuilderFileItem dbbuilderItem = new DBBuilderFileItem(fileXml);
                        packagesIntoFile.put(dbbuilderItem.getModule(), null);
                        DBBuilder.mergeActionsToDo(dbbuilderItem, destXml, processesToCacheIntoDB, sqlMetaInstructions);
                    }
                }
                for (DBXmlDocument currentDoc : orderedlisteDBXmlDocument) {
                    DBBuilderFileItem tmpdbbuilderItem = new DBBuilderFileItem(currentDoc);
                    packagesIntoFile.put(tmpdbbuilderItem.getModule(), null);
                    DBBuilder.mergeActionsToDo(tmpdbbuilderItem, destXml, processesToCacheIntoDB, sqlMetaInstructions);
                }
                ArrayList<String> itemsList = new ArrayList<String>();
                boolean foundDBBuilder = false;
                for (String p : packagesIntoDB) {
                    if (packagesIntoFile.containsKey(p)) continue;
                    if (DBBUILDER_MODULE.equalsIgnoreCase(p)) {
                        foundDBBuilder = true;
                        continue;
                    }
                    if (Action.ACTION_ENFORCE_UNINSTALL == params.getAction()) {
                        if (!p.equals(params.getModuleName())) continue;
                        itemsList.add(0, p);
                        continue;
                    }
                    itemsList.add(0, p);
                }
                if (foundDBBuilder) {
                    if (Action.ACTION_ENFORCE_UNINSTALL == params.getAction()) {
                        if (DBBUILDER_MODULE.equals(params.getModuleName())) {
                            itemsList.add(itemsList.size(), DBBUILDER_MODULE);
                        }
                    } else {
                        itemsList.add(itemsList.size(), DBBUILDER_MODULE);
                    }
                }
                for (String p : itemsList) {
                    DBBuilder.printMessageln("**** Treating " + p + " ****");
                    DBBuilderDBItem tmpdbbuilderItem = new DBBuilderDBItem(p);
                    DBBuilder.mergeActionsToDo(tmpdbbuilderItem, destXml, processesToCacheIntoDB, sqlMetaInstructions);
                }
                destXml.setName("res.txt");
                destXml.save();
                DBBuilder.printMessageln(Console.NEW_LINE + "Build parts are :");
                if (Action.ACTION_INSTALL == params.getAction()) {
                    DBBuilder.processDB(destXml, processesToCacheIntoDB, sqlMetaInstructions, TAGS_TO_MERGE_4_INSTALL);
                } else if (Action.ACTION_UNINSTALL == params.getAction() || Action.ACTION_ENFORCE_UNINSTALL == params.getAction()) {
                    DBBuilder.processDB(destXml, processesToCacheIntoDB, sqlMetaInstructions, TAGS_TO_MERGE_4_UNINSTALL);
                } else if (Action.ACTION_OPTIMIZE == params.getAction()) {
                    DBBuilder.processDB(destXml, processesToCacheIntoDB, sqlMetaInstructions, TAGS_TO_MERGE_4_OPTIMIZE);
                } else if (Action.ACTION_ALL == params.getAction()) {
                    DBBuilder.processDB(destXml, processesToCacheIntoDB, sqlMetaInstructions, TAGS_TO_MERGE_4_ALL);
                } else if (Action.ACTION_STATUS == params.getAction() || Action.ACTION_CONSTRAINTS_INSTALL == params.getAction() || Action.ACTION_CONSTRAINTS_UNINSTALL == params.getAction()) {
                    // empty if block
                }
                DBBuilder.printMessageln(Console.NEW_LINE + "Finally DB Status :");
                DBBuilder.checkDBStatus();
            }
            DBBuilder.printMessageln(Console.NEW_LINE);
            DBBuilder.printMessageln("Database build SUCCESSFULL (" + TODAY + ").");
            System.out.println(Console.NEW_LINE + "Database Build SUCCESSFULL (" + TODAY + ").");
        }
        catch (Exception e) {
            e.printStackTrace();
            DBBuilder.printError(e.getMessage(), e);
            DBBuilder.printMessageln(e.getMessage());
            DBBuilder.printMessageln(Console.NEW_LINE);
            DBBuilder.printMessageln("Database Build FAILED (" + TODAY + ").");
            System.out.println(Console.NEW_LINE + "Database Build FAILED (" + TODAY + ").");
        }
        finally {
            log.close();
        }
    }

    public static void printError(String errMsg, Exception ex) {
        log.printError(errMsg, ex);
    }

    public static void printError(String errMsg) {
        log.printError(errMsg);
    }

    public static void printMessageln(String msg) {
        log.printMessageln(msg);
    }

    public static void printMessage(String msg) {
        log.printMessage(msg);
    }

    private static boolean checkRequired(File[] listeFileXml, DBXmlDocument fXml) {
        Element root = fXml.getDocument().getRootElement();
        List listeDependencies = root.getChildren(REQUIREMENT_TAG);
        if (listeDependencies != null) {
            for (Element eltDependencies : listeDependencies) {
                List listeDependencyFiles = eltDependencies.getChildren(FILE_TAG);
                for (Element eltDependencyFile : listeDependencyFiles) {
                    String name = eltDependencyFile.getAttributeValue("name");
                    boolean found = false;
                    for (int i = 0; i < listeFileXml.length; ++i) {
                        File f = listeFileXml[i];
                        if (!f.getName().equals(name)) continue;
                        found = true;
                        i = listeFileXml.length;
                    }
                    if (found) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static DBXmlDocument[] checkDependencies(List<DBXmlDocument> tfXml) {
        HashMap hDep = new HashMap();
        for (DBXmlDocument fXml : tfXml) {
            if (fXml == null) continue;
            Element root = fXml.getDocument().getRootElement();
            String moduleNameAtt = root.getAttributeValue(PRODUCT_TAG);
            List listeDependencies = root.getChildren(DEPENDENCY_TAG);
            ArrayList<String> aDependencies = new ArrayList<String>();
            if (listeDependencies != null) {
                int j = 0;
                for (Element eltDependencies : listeDependencies) {
                    List listeDependencyFiles = eltDependencies.getChildren(PRODUCT_TAG);
                    for (Element eltDependencyFile : listeDependencyFiles) {
                        String name = eltDependencyFile.getAttributeValue("name");
                        aDependencies.add(name);
                        ++j;
                    }
                }
            }
            hDep.put(moduleNameAtt, aDependencies);
        }
        return null;
    }

    public static Properties getdbBuilderResources() {
        return dbBuilderResources;
    }

    private static void mergeActionsToDo(DBBuilderItem pdbbuilderItem, DBXmlDocument xmlFile, UninstallInformations processesToCacheIntoDB, MetaInstructions sqlMetaInstructions) {
        String package_name = pdbbuilderItem.getModule();
        String versionDB = null;
        String versionFile = null;
        try {
            versionDB = pdbbuilderItem.getVersionFromDB();
            versionFile = pdbbuilderItem.getVersionFromFile();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        String[] tags_to_merge = null;
        VersionTag[] blocks_merge = null;
        if (pdbbuilderItem instanceof DBBuilderFileItem) {
            int iversionFile;
            DBBuilderFileItem dbbuilderItem = (DBBuilderFileItem)pdbbuilderItem;
            int iversionDB = -1;
            if (!versionDB.equals("xxx")) {
                iversionDB = new Integer(versionDB);
            }
            if (iversionDB == (iversionFile = new Integer(versionFile).intValue())) {
                if (Action.ACTION_INSTALL == params.getAction() || Action.ACTION_UNINSTALL == params.getAction() || Action.ACTION_STATUS == params.getAction() || Action.ACTION_CONSTRAINTS_INSTALL == params.getAction() || Action.ACTION_CONSTRAINTS_UNINSTALL == params.getAction()) {
                    DBBuilder.printMessageln("\t" + package_name + " is up to date with version " + versionFile + ".");
                } else {
                    DBBuilder.printMessageln("\t" + package_name + " is up to date with version " + versionFile + " and will be optimized.");
                    tags_to_merge = TAGS_TO_MERGE_4_OPTIMIZE;
                    blocks_merge = new VersionTag[]{new VersionTag("current", versionFile)};
                }
            } else if (iversionDB > iversionFile) {
                DBBuilder.printMessageln("\t" + package_name + " will be ignored because this package is newer into DB than installed files.");
            } else {
                if (Action.ACTION_INSTALL == params.getAction() || Action.ACTION_ALL == params.getAction() || Action.ACTION_STATUS == params.getAction() || Action.ACTION_CONSTRAINTS_INSTALL == params.getAction() || Action.ACTION_CONSTRAINTS_UNINSTALL == params.getAction()) {
                    if (iversionDB == -1) {
                        DBBuilder.printMessageln("\t" + package_name + " will be installed with version " + versionFile + ".");
                        tags_to_merge = TAGS_TO_MERGE_4_INSTALL;
                        blocks_merge = new VersionTag[]{new VersionTag("current", versionFile)};
                        processesToCacheIntoDB.addInformation(dbbuilderItem.getModule(), package_name, dbbuilderItem.getFileXml());
                        sqlMetaInstructions.addInstruction(dbbuilderItem.getModule(), new InstallSQLInstruction(versionFile, package_name));
                    } else {
                        DBBuilder.printMessageln("\t" + package_name + " will be upgraded from " + versionDB + " to " + versionFile + ".");
                        tags_to_merge = TAGS_TO_MERGE_4_INSTALL;
                        blocks_merge = new VersionTag[iversionFile - iversionDB];
                        for (int i = 0; i < iversionFile - iversionDB; ++i) {
                            String sversionFile = "000" + (iversionDB + i);
                            sversionFile = sversionFile.substring(sversionFile.length() - 3);
                            blocks_merge[i] = new VersionTag("upgrade", sversionFile);
                        }
                        processesToCacheIntoDB.addInformation(dbbuilderItem.getModule(), package_name, dbbuilderItem.getFileXml());
                        sqlMetaInstructions.addInstruction(dbbuilderItem.getModule(), new UninstallSQLInstruction(versionFile, package_name));
                    }
                } else if (Action.ACTION_OPTIMIZE == params.getAction()) {
                    DBBuilder.printMessageln("\t" + package_name + " will be optimized.");
                    tags_to_merge = TAGS_TO_MERGE_4_OPTIMIZE;
                    blocks_merge = new VersionTag[]{new VersionTag("current", versionFile)};
                }
                if (blocks_merge != null && tags_to_merge != null) {
                    try {
                        xmlFile.mergeWith(pdbbuilderItem, tags_to_merge, blocks_merge);
                    }
                    catch (Exception e) {
                        DBBuilder.printMessage("Error with " + pdbbuilderItem.getModule() + " " + e.getMessage());
                        e.printStackTrace();
                    }
                }
            }
        } else if (pdbbuilderItem instanceof DBBuilderDBItem) {
            if (Action.ACTION_UNINSTALL == params.getAction() || Action.ACTION_ALL == params.getAction() || Action.ACTION_ENFORCE_UNINSTALL == params.getAction()) {
                DBBuilder.printMessageln("\t" + package_name + " will be uninstalled.");
                tags_to_merge = TAGS_TO_MERGE_4_UNINSTALL;
                if (!DBBUILDER_MODULE.equalsIgnoreCase(package_name)) {
                    System.out.println("delete from SR_");
                    sqlMetaInstructions.addInstruction(pdbbuilderItem.getModule(), new RemoveSQLInstruction(package_name));
                }
                if (tags_to_merge != null) {
                    try {
                        xmlFile.mergeWith(pdbbuilderItem, tags_to_merge, null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            DBBuilder.printMessageln("");
            DBBuilder.printMessageln("*** AVERTISSEMENT ***");
            DBBuilder.printMessageln("\t Le Module " + package_name + " est pr\u00e9sent en BD mais n'a pas de scripts SQL fichiers");
            DBBuilder.printMessageln("");
            System.out.println("");
            System.out.println("*** AVERTISSEMENT ***");
            System.out.println("Le Module " + package_name + " est pr\u00e9sent en BD mais n'a pas de scripts SQL fichiers");
        }
    }

    private static void processDB(DBXmlDocument xmlFile, UninstallInformations processesToCacheIntoDB, MetaInstructions sqlMetaInstructions, String[] tagsToProcess) throws Exception {
        Element root = xmlFile.getDocument().getRootElement();
        List modules = root.getChildren("module");
        for (Element module : modules) {
            Connection connection = null;
            try {
                connection = ConnectionFactory.getConnection();
                connection.setAutoCommit(false);
                DBBuilder.processSQLFiles(connection, module, tagsToProcess, sqlMetaInstructions);
                DBBuilder.cacheIntoDb(connection, processesToCacheIntoDB.getInformations(module.getAttributeValue("id")));
                if (params.isSimulate()) {
                    connection.rollback();
                    continue;
                }
                connection.commit();
            }
            catch (Exception e) {
                try {
                    if (connection != null) {
                        connection.rollback();
                    }
                }
                catch (SQLException sqlex) {
                    // empty catch block
                }
                throw e;
            }
            finally {
                try {
                    if (connection == null) continue;
                    connection.close();
                }
                catch (SQLException sqlex) {}
            }
        }
        DBBuilder.printMessageln("DB Status after build :");
        DBBuilder.checkDBStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> checkDBStatus() {
        ArrayList<String> packagesIntoDB = new ArrayList<String>();
        Connection connection = null;
        try {
            connection = ConnectionFactory.getConnection();
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery("select SR_PACKAGE, SR_VERSION from SR_PACKAGES order by SR_PACKAGE");
            while (rs.next()) {
                String srPackage = rs.getString("SR_PACKAGE");
                String srVersion = rs.getString("SR_VERSION");
                DBBuilder.printMessageln("\t" + srPackage + " v. " + srVersion);
                packagesIntoDB.add(srPackage);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException sqlex) {
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqlex) {}
            }
        }
        return packagesIntoDB;
    }

    private static void processSQLFiles(Connection connection, Element moduleRoot, String[] tagsToProcess, MetaInstructions metaInstructions) throws Exception {
        DBBuilderPiece dbBuilderPiece = null;
        for (int i = 0; i < tagsToProcess.length; ++i) {
            int nbFiles = 0;
            List listeTags = moduleRoot.getChildren(tagsToProcess[i]);
            for (Element eltTag : listeTags) {
                boolean keepdelimiter;
                String dbprocname;
                String skeepdelimiter;
                String delimiter;
                String nomTag = eltTag.getName();
                List listeRowFiles = eltTag.getChildren("row");
                for (Element eltFile : listeRowFiles) {
                    String name = eltFile.getAttributeValue("name");
                    String value = eltFile.getAttributeValue("type");
                    Integer order = new Integer(eltFile.getAttributeValue("sequence"));
                    delimiter = eltFile.getAttributeValue("delimiter");
                    skeepdelimiter = eltFile.getAttributeValue("keepdelimiter");
                    dbprocname = eltFile.getAttributeValue("dbprocname");
                    keepdelimiter = "YES".equals(skeepdelimiter);
                    DBBuilder.printMessageln("\t" + tagsToProcess[i] + " : internal-id : " + name + "\t type : " + value);
                    ++nbFiles;
                    if ("sqlstatement".equals(value)) {
                        dbBuilderPiece = new DBBuilderSingleStatementPiece(name, name + "(" + order + ")", nomTag, order, params.isVerbose());
                    } else if ("sqlstatementlist".equals(value)) {
                        dbBuilderPiece = new DBBuilderMultipleStatementPiece(name, name + "(" + order + ")", nomTag, order, params.isVerbose(), delimiter, keepdelimiter);
                    } else if ("dbprocedure".equals(value)) {
                        dbBuilderPiece = new DBBuilderDBProcPiece(name, name + "(" + order + ")", nomTag, order, params.isVerbose(), dbprocname);
                    }
                    if (dbBuilderPiece == null) continue;
                    dbBuilderPiece.setConsole(log);
                    dbBuilderPiece.executeInstructions(connection);
                }
                List listeFiles = eltTag.getChildren(FILE_TAG);
                for (Element eltFile : listeFiles) {
                    String name = DBBuilder.getCleanPath(eltFile.getAttributeValue("name"));
                    String value = eltFile.getAttributeValue("type");
                    delimiter = eltFile.getAttributeValue("delimiter");
                    skeepdelimiter = eltFile.getAttributeValue("keepdelimiter");
                    dbprocname = eltFile.getAttributeValue("dbprocname");
                    keepdelimiter = skeepdelimiter != null && skeepdelimiter.equals("YES");
                    String classname = eltFile.getAttributeValue("classname");
                    String methodname = eltFile.getAttributeValue("methodname");
                    DBBuilder.printMessageln("\t" + tagsToProcess[i] + " : name : " + name + "\t type : " + value);
                    ++nbFiles;
                    if ("sqlstatement".equals(value)) {
                        dbBuilderPiece = new DBBuilderSingleStatementPiece(Configuration.getPiecesFilesDir() + File.separatorChar + name, nomTag, params.isVerbose());
                    } else if ("sqlstatementlist".equals(value)) {
                        dbBuilderPiece = new DBBuilderMultipleStatementPiece(Configuration.getPiecesFilesDir() + File.separatorChar + name, nomTag, params.isVerbose(), delimiter, keepdelimiter);
                    } else if ("dbprocedure".equals(value)) {
                        dbBuilderPiece = new DBBuilderDBProcPiece(Configuration.getPiecesFilesDir() + File.separatorChar + name, nomTag, params.isVerbose(), dbprocname);
                    } else if ("javalib".equals(value)) {
                        dbBuilderPiece = new DBBuilderDynamicLibPiece(Configuration.getPiecesFilesDir() + File.separatorChar + name, nomTag, params.isVerbose(), classname, methodname);
                    }
                    if (dbBuilderPiece == null) continue;
                    dbBuilderPiece.executeInstructions(connection);
                }
            }
            if (nbFiles != 0) continue;
            DBBuilder.printMessageln("\t" + tagsToProcess[i] + " : (none)");
        }
        List<SQLInstruction> sqlMetaInstructions = metaInstructions.getInstructions(moduleRoot.getAttributeValue("id"));
        if (sqlMetaInstructions.isEmpty()) {
            DBBuilder.printMessageln("\tdbbuilder meta base maintenance : (none)");
        } else {
            DBBuilder.printMessageln("\tdbbuilder meta base maintenance :");
            for (SQLInstruction instruction : sqlMetaInstructions) {
                instruction.execute(connection);
            }
        }
    }

    protected static void cacheIntoDb(Connection connection, List<FileInformation> informations) throws Exception {
        DBBuilder.printMessageln(System.getProperty("line.separator") + "Uninstall stored parts are :");
        String[] tagsToProcessU = TAGS_TO_MERGE_4_UNINSTALL;
        for (FileInformation information : informations) {
            String pName = information.getSrPackage();
            DBXmlDocument xFile = information.getDocument();
            Element rootU = xFile.getDocument().getRootElement();
            int nbFilesU = 0;
            for (int i = 0; i < tagsToProcessU.length; ++i) {
                List listeTagsCU = rootU.getChildren("current");
                for (Element eltTagCU : listeTagsCU) {
                    List listeTagsU = eltTagCU.getChildren(tagsToProcessU[i]);
                    for (Element eltTagU : listeTagsU) {
                        List listeFilesU = eltTagU.getChildren(FILE_TAG);
                        Iterator iterFilesU = listeFilesU.iterator();
                        int iFile = 1;
                        while (iterFilesU.hasNext()) {
                            DBBuilderPiece pU;
                            Element eltFileU = (Element)iterFilesU.next();
                            String nameU = DBBuilder.getCleanPath(eltFileU.getAttributeValue("name"));
                            String valueU = eltFileU.getAttributeValue("type");
                            String delimiterU = eltFileU.getAttributeValue("delimiter");
                            String skeepdelimiterU = eltFileU.getAttributeValue("keepdelimiter");
                            String dbprocnameU = eltFileU.getAttributeValue("dbprocname");
                            boolean keepdelimiterU = skeepdelimiterU != null && skeepdelimiterU.equals("YES");
                            DBBuilder.printMessageln("\t" + tagsToProcessU[i] + " : name : " + nameU + "\t type : " + valueU);
                            if (valueU.equals("sqlstatement")) {
                                pU = new DBBuilderSingleStatementPiece(Configuration.getPiecesFilesDir() + File.separatorChar + nameU, tagsToProcessU[i], params.isVerbose());
                                pU.cacheIntoDB(connection, pName, iFile);
                            } else if (valueU.equals("sqlstatementlist")) {
                                pU = new DBBuilderMultipleStatementPiece(Configuration.getPiecesFilesDir() + File.separatorChar + nameU, tagsToProcessU[i], params.isVerbose(), delimiterU, keepdelimiterU);
                                pU.cacheIntoDB(connection, pName, iFile);
                            } else if (valueU.equals("dbprocedure")) {
                                pU = new DBBuilderDBProcPiece(Configuration.getPiecesFilesDir() + File.separatorChar + nameU, tagsToProcessU[i], params.isVerbose(), dbprocnameU);
                                pU.cacheIntoDB(connection, pName, iFile);
                            }
                            ++iFile;
                            ++nbFilesU;
                        }
                    }
                }
                if (nbFilesU != 0) continue;
                DBBuilder.printMessageln("\t" + tagsToProcessU[i] + " : (none)");
            }
        }
    }

    private static String getCleanPath(String name) {
        String path = name.replace('/', File.separatorChar);
        return path.replace('\\', File.separatorChar);
    }

    private DBBuilder() {
    }

    static {
        TAGS_TO_MERGE_4_INSTALL = new String[]{CREATE_TABLE_TAG, CREATE_INDEX_TAG, CREATE_CONSTRAINT_TAG, CREATE_DATA_TAG};
        TAGS_TO_MERGE_4_UNINSTALL = new String[]{DROP_CONSTRAINT_TAG, DROP_INDEX_TAG, DROP_DATA_TAG, DROP_TABLE_TAG};
        TAGS_TO_MERGE_4_ALL = new String[]{DROP_CONSTRAINT_TAG, DROP_INDEX_TAG, DROP_DATA_TAG, DROP_TABLE_TAG, CREATE_TABLE_TAG, CREATE_INDEX_TAG, CREATE_CONSTRAINT_TAG, CREATE_DATA_TAG};
        TAGS_TO_MERGE_4_OPTIMIZE = new String[]{DROP_INDEX_TAG, CREATE_INDEX_TAG};
        dbBuilderResources = new Properties();
        params = null;
    }
}

