/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.dbbuilder.sql;

import com.silverpeas.dbbuilder.sql.DbProcParameter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryExecutor {
    public static void executeUpdate(Connection connection, String query) throws SQLException {
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
            stmt.executeUpdate(query);
            stmt.close();
        }
        catch (SQLException e) {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e2) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    public static void executeProcedure(Connection connection, String procedureName, DbProcParameter[] dbProcParameters) throws Exception {
        int i;
        CallableStatement call = null;
        String preparedStatement = null;
        if (dbProcParameters == null || dbProcParameters.length == 0) {
            preparedStatement = "{call " + procedureName + "}";
        } else {
            preparedStatement = "{call " + procedureName + "(";
            for (i = 0; i < dbProcParameters.length; ++i) {
                preparedStatement = preparedStatement + "?";
                if (i == dbProcParameters.length - 1) continue;
                preparedStatement = preparedStatement + ",";
            }
            preparedStatement = preparedStatement + ")}";
        }
        call = connection.prepareCall(preparedStatement);
        if (dbProcParameters != null) {
            for (i = 0; i < dbProcParameters.length; ++i) {
                DbProcParameter dbPP = dbProcParameters[i];
                call.setObject(i + 1, dbPP.getParameterValue(), dbPP.getParameterType());
                if (!dbPP.getIsOutParameter()) continue;
                call.registerOutParameter(i + 1, dbPP.getParameterType());
            }
        }
        call.execute();
        if (dbProcParameters != null) {
            for (i = 0; i < dbProcParameters.length; ++i) {
                if (!dbProcParameters[i].getIsOutParameter()) continue;
                dbProcParameters[i].setParameterValue(call.getObject(i + 1));
            }
        }
        call.close();
    }

    public static List<Map<String, Object>> executeLoopQuery(Connection connection, String query, Object[] parameters) throws Exception {
        ResultSet results;
        Statement stmt = null;
        PreparedStatement pstmt = null;
        ArrayList<Map<String, Object>> array = new ArrayList<Map<String, Object>>();
        if (parameters == null) {
            stmt = connection.createStatement();
            results = stmt.executeQuery(query);
        } else {
            pstmt = connection.prepareStatement(query);
            for (int i = 0; i < parameters.length; ++i) {
                pstmt.setObject(i + 1, parameters[i]);
            }
            results = pstmt.executeQuery();
        }
        ResultSetMetaData meta = results.getMetaData();
        while (results.next()) {
            HashMap<String, Object> h = new HashMap<String, Object>(meta.getColumnCount());
            for (int i = 1; i <= meta.getColumnCount(); ++i) {
                Object ob = results.getObject(i);
                h.put(meta.getColumnLabel(i).toUpperCase(), ob);
            }
            array.add(h);
        }
        results.close();
        if (stmt != null) {
            stmt.close();
        }
        if (pstmt != null) {
            pstmt.close();
        }
        return array;
    }

    private QueryExecutor() {
    }
}

