/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.dbbuilder;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.silverpeas.dbbuilder.util.Configuration;

public final class Console {
    public static final String NEW_LINE = System.getProperty("line.separator");
    private File logFile;
    private PrintWriter logBuffer;

    public Console(String fileName) throws IOException {
        this.logFile = new File(Configuration.getLogDir() + File.separator + fileName);
        this.logFile.getParentFile().mkdirs();
        this.logBuffer = new PrintWriter(new BufferedWriter(new FileWriter(this.logFile.getAbsolutePath(), true)));
    }

    public Console() {
    }

    public void printError(String errMsg, Exception ex) {
        this.printError(errMsg);
        if (this.logBuffer != null) {
            ex.printStackTrace(this.logBuffer);
            this.logBuffer.close();
        }
    }

    public void printError(String errMsg) {
        if (this.logBuffer != null) {
            this.printMessageln(NEW_LINE);
            this.printMessageln(errMsg);
            this.logBuffer.close();
        }
        System.out.println(NEW_LINE + errMsg + NEW_LINE);
    }

    public void printMessageln(String msg) {
        this.printMessage(msg);
        this.printMessage(NEW_LINE);
    }

    public void printMessage(String msg) {
        if (this.logBuffer != null) {
            this.logBuffer.print(msg);
            System.out.print(".");
        } else {
            System.out.print(msg);
        }
    }

    public void close() {
        this.logBuffer.close();
    }
}

