/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.dbbuilder.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.silverpeas.dbbuilder.DBBuilder;
import org.silverpeas.dbbuilder.dbbuilder_dl.DbBuilderDynamicPart;
import org.silverpeas.dbbuilder.util.Configuration;

public class DynamicLoader {
    private URLClassLoader loader;
    private static final String JAR_DIRECTORY = "dynamic";

    public DynamicLoader() {
        ClassLoader parent;
        File jarDirectory = new File(Configuration.getPiecesFilesDir(), JAR_DIRECTORY);
        URL[] classpath = new URL[]{};
        if (jarDirectory.exists() && jarDirectory.isDirectory()) {
            Collection jars = FileUtils.listFiles((File)jarDirectory, (String[])new String[]{"jar"}, (boolean)true);
            ArrayList<URL> urls = new ArrayList<URL>(jars.size());
            DBBuilder.printMessage("We have found " + jars.size() + " jars files");
            for (File jar : jars) {
                try {
                    urls.add(jar.toURI().toURL());
                    for (URL url : urls) {
                        DBBuilder.printError(url.toString());
                    }
                }
                catch (MalformedURLException ex) {
                    Logger.getLogger(DynamicLoader.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            classpath = urls.toArray(new URL[urls.size()]);
        }
        if ((parent = Thread.currentThread().getContextClassLoader()) == null) {
            parent = this.getClass().getClassLoader();
        }
        this.loader = new URLClassLoader(classpath, parent);
    }

    public DbBuilderDynamicPart loadDynamicPart(String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Class<?> dynamicPart = Class.forName(className, true, this.loader);
        return (DbBuilderDynamicPart)dynamicPart.newInstance();
    }
}

