/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.migration.contentmanagement;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.silverpeas.dbbuilder.Console;
import org.silverpeas.dbbuilder.dbbuilder_dl.DbBuilderDynamicPart;

public class DuplicateContentRemoving
extends DbBuilderDynamicPart {
    private static final String DUPLICATE_CLASSIFIED_CONTENT_COUNT_QUERY = "select count(distinct c1.internalContentId) from sb_contentmanager_content c1 where 1 < (select count(c2.internalContentId) from sb_contentmanager_content c2 where c2.contentInstanceId=c1.contentInstanceId and c2.internalContentId = c1.internalContentId) and c1.silverContentId in (select objectid from sb_classifyengine_classify)";
    private static final String DUPLICATE_CONTENT_COUNT_QUERY = "select count(distinct c1.internalContentId) from sb_contentmanager_content c1 where 1 < (select count(c2.internalContentId) from sb_contentmanager_content c2 where c2.contentInstanceId=c1.contentInstanceId and c2.internalContentId = c1.internalContentId) ";
    private static final String REDUNDANT_INSTANCE_OF_DUPLICATE_CONTENT_QUERY = "select c1.silverContentId, c1.internalContentId, c1.contentInstanceId from sb_contentmanager_content c1 where 1 < (select count(c2.internalContentId) from sb_contentmanager_content c2 where c2.contentInstanceId=c1.contentInstanceId and c2.internalContentId = c1.internalContentId) and c1.silverContentId < (select max(c3.silverContentId) from sb_contentmanager_content c3 where c1.contentInstanceId=c3.contentInstanceId and c1.internalContentId=c3.internalContentId and c1.silverContentId != c3.silverContentId)";
    private static final String UNCLASSIFIED_REDUNDANT_CONTENT_INSTANCES_TO_DELETE = "select c1.silverContentId from sb_contentmanager_content c1 where 1 < (select count(c2.internalContentId) from sb_contentmanager_content c2 where c2.contentInstanceId=c1.contentInstanceId and c2.internalContentId = c1.internalContentId) and c1.silverContentId not in (select objectid from sb_classifyengine_classify)and c1.silverContentId < (select max(c3.silverContentId) from sb_contentmanager_content c3 where c1.contentInstanceId=c3.contentInstanceId and c1.internalContentId=c3.internalContentId)";
    private static final String UNCLASSIFIED_REDUNDANT_CONTENT_INSTANCE_WITH_HIGHER_ID_TO_DELETE = "select c1.silverContentId from sb_contentmanager_content c1 where 1 < (select count(c2.internalContentId) from sb_contentmanager_content c2 where c2.contentInstanceId=c1.contentInstanceId and c2.internalContentId = c1.internalContentId) and c1.silverContentId not in (select objectid from sb_classifyengine_classify)";
    private static final String CONTENT_INSTANCE_DELETION = "delete from sb_contentmanager_content where silverContentId in ({0})";
    private static final String CONTENT_INSTANCE_CLASSIFICATION_DELETION = "delete from sb_classifyengine_classify where objectId in ({0})";

    public void migrate() throws Exception {
        Connection connection;
        boolean autocommit;
        Console console = this.getConsole();
        if (console == null) {
            console = new Console();
        }
        if (autocommit = (connection = this.getConnection()).getAutoCommit()) {
            connection.setAutoCommit(false);
        }
        int duplicateContentCount = this.executeQuery(DUPLICATE_CONTENT_COUNT_QUERY).get(0);
        String duplicateContents = "Number of duplicate content: " + duplicateContentCount;
        console.printMessageln(duplicateContents);
        System.out.println();
        System.out.println(duplicateContents);
        int classifiedContents = this.executeQuery(DUPLICATE_CLASSIFIED_CONTENT_COUNT_QUERY).get(0);
        console.printMessageln("Number of duplicate content that are classified on the PdC: " + classifiedContents);
        console.printMessageln("Delete the unclassified redundant instances of duplicate contents");
        List<Integer> contentsToDelete = this.executeQuery(UNCLASSIFIED_REDUNDANT_CONTENT_INSTANCES_TO_DELETE);
        int deletedContents1 = this.executeDeletion(CONTENT_INSTANCE_DELETION, contentsToDelete);
        DuplicateContentRemoving.assertEquals(contentsToDelete.size(), deletedContents1);
        console.printMessageln("-> number of redundant instances deleted: " + deletedContents1);
        console.printMessageln("Delete the rest of unclassified redundant instances of duplicate contents");
        contentsToDelete = this.executeQuery(UNCLASSIFIED_REDUNDANT_CONTENT_INSTANCE_WITH_HIGHER_ID_TO_DELETE);
        int deletedContents2 = this.executeDeletion(CONTENT_INSTANCE_DELETION, contentsToDelete);
        DuplicateContentRemoving.assertEquals(contentsToDelete.size(), deletedContents2);
        console.printMessageln("-> number of redundant instances deleted: " + deletedContents2);
        console.printMessageln("Delete the exceptional redundant instances of duplicate classified content");
        int deletedContents3 = this.deleteRedundantClassifiedInstances();
        console.printMessageln("-> number of redundant instances deleted: " + deletedContents3);
        String deletedContents = "Total number of deleted redundant instances: " + (deletedContents1 + deletedContents2 + deletedContents3);
        console.printMessageln(deletedContents);
        System.out.println();
        System.out.println(deletedContents);
        connection.commit();
        connection.setAutoCommit(autocommit);
    }

    private List<Integer> executeQuery(String query) throws SQLException {
        ArrayList<Integer> result = new ArrayList<Integer>();
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(query);
        while (resultSet.next()) {
            result.add(resultSet.getInt(1));
        }
        return result;
    }

    private int executeDeletion(String query, List<Integer> objectsToDelete) throws SQLException {
        if (objectsToDelete.isEmpty()) {
            return 0;
        }
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        StringBuilder parameterBuilder = new StringBuilder();
        for (Integer anObjectToDelete : objectsToDelete) {
            parameterBuilder.append(anObjectToDelete).append(',');
        }
        String sqlRequest = MessageFormat.format(query, parameterBuilder.toString().substring(0, parameterBuilder.length() - 1));
        return statement.executeUpdate(sqlRequest);
    }

    private int deleteRedundantClassifiedInstances() throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        ResultSet rs = statement.executeQuery(REDUNDANT_INSTANCE_OF_DUPLICATE_CONTENT_QUERY);
        ArrayList<Integer> contentsToDelete = new ArrayList<Integer>();
        while (rs.next()) {
            int silverContentId = rs.getInt("silverContentId");
            contentsToDelete.add(silverContentId);
        }
        int deletedCount = this.executeDeletion(CONTENT_INSTANCE_CLASSIFICATION_DELETION, contentsToDelete);
        DuplicateContentRemoving.assertEquals(contentsToDelete.size(), deletedCount);
        this.executeDeletion(CONTENT_INSTANCE_DELETION, contentsToDelete);
        return deletedCount;
    }

    private static void assertEquals(int expected, int actual) {
        if (expected != actual) {
            throw new AssertionError((Object)("Expected deletion: " + expected + ", actual deletion: " + actual));
        }
    }
}

