/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.dbbuilder;

import com.silverpeas.dbbuilder.DBBuilderPiece;
import com.silverpeas.dbbuilder.Instruction;
import com.silverpeas.file.StringUtil;
import java.sql.Connection;
import java.util.Vector;

public class DBBuilderMultipleStatementPiece
extends DBBuilderPiece {
    private String delimiter = null;
    private boolean keepDelimiter = false;

    private DBBuilderMultipleStatementPiece(String pieceName, String actionName, boolean traceMode) throws Exception {
        super(pieceName, actionName, traceMode);
    }

    private DBBuilderMultipleStatementPiece(String pieceName, String actionName, String content, boolean traceMode) throws Exception {
        super(pieceName, actionName, content, traceMode);
    }

    private DBBuilderMultipleStatementPiece(String actionInternalID, String pieceName, String actionName, int itemOrder, boolean traceMode) throws Exception {
        super(actionInternalID, pieceName, actionName, itemOrder, traceMode);
    }

    public DBBuilderMultipleStatementPiece(String pieceName, String actionName, boolean traceMode, String delimiter, boolean keepDelimiter) throws Exception {
        super(pieceName, actionName, traceMode);
        this.moreInitialize(delimiter, keepDelimiter);
    }

    public DBBuilderMultipleStatementPiece(String pieceName, String actionName, String content, boolean traceMode, String delimiter, boolean keepDelimiter) throws Exception {
        super(pieceName, actionName, content, traceMode);
        this.moreInitialize(delimiter, keepDelimiter);
    }

    public DBBuilderMultipleStatementPiece(String actionInternalID, String pieceName, String actionName, int itemOrder, boolean traceMode, String delimiter, boolean keepDelimiter) throws Exception {
        super(actionInternalID, pieceName, actionName, itemOrder, traceMode);
        this.moreInitialize(delimiter, keepDelimiter);
    }

    private void moreInitialize(String delimiter, boolean keepDelimiter) throws Exception {
        if (delimiter == null) {
            throw new Exception("Missing <delimiter> tag for \"pieceName\" item.");
        }
        String d = new String();
        d = StringUtil.sReplace((String)"\\n", (String)"\n", (String)delimiter);
        this.delimiter = d = StringUtil.sReplace((String)"\\t", (String)"\t", (String)d);
        this.keepDelimiter = keepDelimiter;
        this.setInstructions();
    }

    @Override
    public void setInstructions() {
        if (this.getContent() != null && this.delimiter != null) {
            Vector v = this.tokenizeAll(this.getContent(), this.delimiter, this.keepDelimiter);
            this.instructions = new Instruction[v.size()];
            for (int i = 0; i < v.size(); ++i) {
                this.instructions[i] = new Instruction(1, (String)v.get(i), null);
            }
        }
    }

    @Override
    public void cacheIntoDB(Connection connection, String _package, int _itemOrder) throws Exception {
        Integer kd = this.keepDelimiter ? new Integer(1) : new Integer(0);
        this.cacheIntoDB(connection, _package, _itemOrder, "sqlstatementlist", this.delimiter, kd, null);
    }

    private Vector tokenizeAll(String str, String delimiter, boolean keepDelimiter) {
        Vector<String> c = new Vector<String>();
        int previ = 0;
        int curi = 0;
        while (curi < str.length() && curi >= 0) {
            String instruction;
            previ = curi;
            if ((curi = str.indexOf(delimiter, curi)) < str.length() && curi >= 0) {
                String instruction2;
                int endIndex = curi;
                if (keepDelimiter) {
                    endIndex = curi + delimiter.length();
                }
                if (!" ".equals(instruction2 = str.substring(previ, endIndex).trim()) && !"".equals(instruction2)) {
                    c.add(instruction2);
                }
                curi += delimiter.length();
                continue;
            }
            if (str.length() - previ <= delimiter.length() || " ".equals(instruction = str.substring(previ, str.length()).trim()) || "".equals(instruction)) continue;
            if (keepDelimiter) {
                instruction = instruction + delimiter;
            }
            c.add(instruction);
        }
        return c;
    }
}

