/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.migration.contentmanagement;

import com.silverpeas.dbbuilder.Console;
import com.silverpeas.dbbuilder.dbbuilder_dl.DbBuilderDynamicPart;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DuplicateContentRemoving
extends DbBuilderDynamicPart {
    private static final String DUPLICATE_CLASSIFIED_CONTENT_COUNT_QUERY = "select count(distinct c1.internalContentId) from sb_contentmanager_content as c1 where 1 < (select count(c2.internalContentId) from sb_contentmanager_content as c2 where c2.contentInstanceId=c1.contentInstanceId and c2.internalContentId = c1.internalContentId) and c1.silverContentId in (select objectid from sb_classifyengine_classify)";
    private static final String DUPLICATE_CONTENT_COUNT_QUERY = "select count(distinct c1.internalContentId) from sb_contentmanager_content as c1 where 1 < (select count(c2.internalContentId) from sb_contentmanager_content as c2 where c2.contentInstanceId=c1.contentInstanceId and c2.internalContentId = c1.internalContentId) ";
    private static final String REDUNDANT_INSTANCE_OF_DUPLICATE_CONTENT_QUERY = "select c1.silverContentId, c1.internalContentId, c1.contentInstanceId from sb_contentmanager_content as c1 where 1 < (select count(c2.internalContentId) from sb_contentmanager_content as c2 where c2.contentInstanceId=c1.contentInstanceId and c2.internalContentId = c1.internalContentId) and c1.silverContentId < (select max(c3.silverContentId) from sb_contentmanager_content as c3 where c1.contentInstanceId=c3.contentInstanceId and c1.internalContentId=c3.internalContentId and c1.silverContentId != c3.silverContentId)";
    private static final String UNCLASSIFIED_REDUNDANT_CONTENT_INSTANCE_DELETION = "delete from sb_contentmanager_content as c1 where 1 < (select count(c2.internalContentId) from sb_contentmanager_content as c2 where c2.contentInstanceId=c1.contentInstanceId and c2.internalContentId = c1.internalContentId) and c1.silverContentId not in (select objectid from sb_classifyengine_classify)and c1.silverContentId < (select max(c3.silverContentId) from sb_contentmanager_content as c3 where c1.contentInstanceId=c3.contentInstanceId and c1.internalContentId=c3.internalContentId)";
    private static final String UNCLASSIFIED_REDUNDANT_CONTENT_INSTANCE_WITH_HIGHER_ID_DELETION = "delete from sb_contentmanager_content as c1 where 1 < (select count(c2.internalContentId) from sb_contentmanager_content as c2 where c2.contentInstanceId=c1.contentInstanceId and c2.internalContentId = c1.internalContentId) and c1.silverContentId not in (select objectid from sb_classifyengine_classify)";
    private static final String CONTENT_INSTANCE_DELETION = "delete from sb_contentmanager_content where silverContentId=";
    private static final String CONTENT_INSTANCE_CLASSIFICATION_DELETION = "delete from sb_classifyengine_classify where objectId=";

    public void migrate() throws Exception {
        Connection connection;
        boolean autocommit;
        Console console = this.getConsole();
        if (console == null) {
            console = new Console();
        }
        if (autocommit = (connection = this.getConnection()).getAutoCommit()) {
            connection.setAutoCommit(false);
        }
        int duplicateContentCount = this.executeQuery(DUPLICATE_CONTENT_COUNT_QUERY);
        String duplicateContents = "Number of duplicate content: " + duplicateContentCount;
        console.printMessageln(duplicateContents);
        System.out.println();
        System.out.println(duplicateContents);
        int classifiedContents = this.executeQuery(DUPLICATE_CLASSIFIED_CONTENT_COUNT_QUERY);
        console.printMessageln("Number of duplicate content that are classified on the PdC: " + classifiedContents);
        console.printMessageln("Delete the unclassified redundant instances of duplicate contents");
        int deletedContents1 = this.executeDeletion(UNCLASSIFIED_REDUNDANT_CONTENT_INSTANCE_DELETION);
        console.printMessageln("-> number of redundant instances deleted: " + deletedContents1);
        console.printMessageln("Delete the rest of unclassified redundant instances of duplicate contents");
        int deletedContents2 = this.executeDeletion(UNCLASSIFIED_REDUNDANT_CONTENT_INSTANCE_WITH_HIGHER_ID_DELETION);
        console.printMessageln("-> number of redundant instances deleted: " + deletedContents2);
        console.printMessageln("Delete the exceptional redundant instances of duplicate classified content");
        int deletedContents3 = this.deleteRedundantClassifiedInstances();
        console.printMessageln("-> number of redundant instances deleted: " + deletedContents3);
        String deletedContents = "Total number of deleted redundant instances: " + (deletedContents1 + deletedContents2 + deletedContents3);
        console.printMessageln(deletedContents);
        System.out.println();
        System.out.println(deletedContents);
        connection.commit();
        connection.setAutoCommit(autocommit);
    }

    private int executeQuery(String query) throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(query);
        resultSet.next();
        return resultSet.getInt(1);
    }

    private int executeDeletion(String query) throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        return statement.executeUpdate(query);
    }

    private int deleteRedundantClassifiedInstances() throws SQLException {
        int deletedCount = 0;
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        ResultSet rs = statement.executeQuery(REDUNDANT_INSTANCE_OF_DUPLICATE_CONTENT_QUERY);
        while (rs.next()) {
            int silverContentId = rs.getInt("silverContentId");
            deletedCount += this.executeDeletion(CONTENT_INSTANCE_CLASSIFICATION_DELETION + silverContentId);
            this.executeDeletion(CONTENT_INSTANCE_DELETION + silverContentId);
        }
        return deletedCount;
    }
}

