/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.dbbuilder;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;
import org.silverpeas.dbbuilder.DBXmlDocument;
import org.silverpeas.dbbuilder.sql.ConnectionFactory;

public abstract class DBBuilderItem {
    public static final String MODULENAME_ATTRIB = "product";
    public static final String CURRENT_TAG = "current";
    public static final String PREVIOUS_TAG = "upgrade";
    public static final String VERSION_ATTRIB = "version";
    public static final String NOTINSTALLED = "xxx";
    public static final String CONTRIBUTION_TAG = "contribution";
    public static final String CREATE_TABLE_TAG = "create_table";
    public static final String CREATE_INDEX_TAG = "create_index";
    public static final String CREATE_CONSTRAINT_TAG = "create_constraint";
    public static final String CREATE_DATA_TAG = "init";
    public static final String DROP_TABLE_TAG = "drop_table";
    public static final String DROP_INDEX_TAG = "drop_index";
    public static final String DROP_CONSTRAINT_TAG = "drop_constraint";
    public static final String DROP_DATA_TAG = "clean";
    public static final String FILE_TAG = "file";
    public static final String ROW_TAG = "row";
    public static final String FILENAME_ATTRIB = "name";
    public static final String FILETYPE_ATTRIB = "type";
    public static final String FILEDELIMITER_ATTRIB = "delimiter";
    public static final String FILEKEEPDELIMITER_ATTRIB = "keepdelimiter";
    public static final String FILEDBPROCNAME_ATTRIB = "dbprocname";
    public static final String FILECLASSNAME_ATTRIB = "classname";
    public static final String FILEMETHODNAME_ATTRIB = "methodname";
    public static final String DBORDER_ATTRIB = "sequence";
    public static final String FILEATTRIBSTATEMENT_VALUE = "sqlstatement";
    public static final String FILEATTRIBSEQUENCE_VALUE = "sqlstatementlist";
    public static final String FILEATTRIBDBPROC_VALUE = "dbprocedure";
    public static final String FILEATTRIBJAVALIB_VALUE = "javalib";
    private String module = null;
    protected String versionFromFile = null;
    private String versionFromDB = null;
    private DBXmlDocument fileXml;
    private Element root;

    public void setFileXml(DBXmlDocument fileXml) {
        this.fileXml = fileXml;
    }

    public DBXmlDocument getFileXml() {
        return this.fileXml;
    }

    public void setRoot(Element root) {
        this.root = root;
    }

    public Element getRoot() {
        return this.root;
    }

    public String getModule() {
        return this.module;
    }

    protected void setModule(String module) {
        this.module = module;
    }

    public abstract String getVersionFromFile() throws Exception;

    public String getVersionFromDB() throws Exception {
        if (this.versionFromDB == null) {
            this.versionFromDB = this.extractVersionFromDatabase();
        }
        return this.versionFromDB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String extractVersionFromDatabase() throws SQLException {
        Connection connection = null;
        String version = NOTINSTALLED;
        try {
            connection = ConnectionFactory.getConnection();
            PreparedStatement pstmt = connection.prepareStatement("SELECT SR_VERSION FROM SR_PACKAGES where SR_PACKAGE = ?");
            pstmt.setString(1, this.module);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                version = rs.getString("SR_VERSION");
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        return version;
    }

    public Element getUniqueBlock(String b, String v) throws Exception {
        List listeCurrent = this.getRoot().getChildren(b);
        if (listeCurrent == null) {
            throw new Exception(this.getModule() + ": no <" + b + "> tag found for this module into contribution file.");
        }
        if (listeCurrent.size() == 0) {
            throw new Exception(this.getModule() + ": no <" + b + "> tag found for this module into contribution file.");
        }
        Iterator iterCurrent = listeCurrent.iterator();
        Element myElement = null;
        while (iterCurrent.hasNext()) {
            Element eltCurrent = (Element)iterCurrent.next();
            if (!eltCurrent.getAttributeValue(VERSION_ATTRIB).equals(v)) continue;
            myElement = eltCurrent;
        }
        if (myElement == null) {
            throw new Exception(this.getModule() + ": no version <" + v + "> for <" + b + "> tag found for this module into contribution file.");
        }
        return myElement;
    }
}

