/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.dbbuilder;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Properties;
import org.silverpeas.dbbuilder.Console;
import org.silverpeas.dbbuilder.DBBuilder;
import org.silverpeas.dbbuilder.Instruction;
import org.silverpeas.dbbuilder.dbbuilder_dl.DbBuilderDynamicPart;
import org.silverpeas.dbbuilder.sql.ConnectionFactory;
import org.silverpeas.dbbuilder.sql.DbProcParameter;
import org.silverpeas.dbbuilder.sql.QueryExecutor;
import org.silverpeas.file.StringUtil;

public abstract class DBBuilderPiece {
    private static Integer increment = new Integer(0);
    private String actionInternalID = null;
    private String pieceName = null;
    private String content = null;
    private String actionName = null;
    private boolean traceMode = false;
    protected Instruction[] instructions = null;
    protected Connection connection = null;
    protected Console console = null;

    public DBBuilderPiece(String pieceName, String actionName, boolean traceMode) throws Exception {
        this.traceMode = traceMode;
        this.actionName = actionName;
        this.pieceName = pieceName;
        if (pieceName.endsWith(".jar")) {
            this.content = "";
        } else {
            File myFile = new File(pieceName);
            if (!(myFile.exists() && myFile.isFile() && myFile.canRead())) {
                DBBuilder.printMessageln(Console.NEW_LINE + "\t\t***Unable to load : " + pieceName);
                throw new Exception("Unable to find or load : " + pieceName);
            }
            int fileSize = (int)myFile.length();
            byte[] data = new byte[fileSize];
            DataInputStream in = new DataInputStream(new FileInputStream(pieceName));
            in.readFully(data);
            this.content = new String(data);
            in.close();
        }
        Properties res = DBBuilder.getdbBuilderResources();
        if (res != null) {
            Enumeration<Object> e = res.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = res.getProperty(key);
                this.content = StringUtil.sReplace((String)("${" + key + "}"), (String)value, (String)this.content);
            }
        }
    }

    public DBBuilderPiece(String pieceName, String actionName, String content, boolean traceMode) throws Exception {
        this.traceMode = traceMode;
        this.actionName = actionName;
        this.pieceName = pieceName;
        this.content = content;
    }

    public DBBuilderPiece(String actionInternalID, String pieceName, String actionName, int itemOrder, boolean traceMode) throws Exception {
        this.traceMode = traceMode;
        this.actionName = actionName;
        this.pieceName = pieceName;
        this.actionInternalID = actionInternalID;
        this.content = this.getContentFromDB(actionInternalID);
    }

    public String getActionInternalID() {
        return this.actionInternalID;
    }

    public String getPieceName() {
        return this.pieceName;
    }

    public String getActionName() {
        return this.actionName;
    }

    public String getContent() {
        return this.content;
    }

    public void setConsole(Console console) {
        this.console = console;
    }

    public Console getConsole() {
        return this.console;
    }

    public boolean isTraceMode() {
        return this.traceMode;
    }

    public abstract void setInstructions();

    public abstract void cacheIntoDB(Connection var1, String var2, int var3) throws Exception;

    public Instruction[] getInstructions() {
        return this.instructions;
    }

    public void traceInstructions() {
        for (int i = 0; i < this.instructions.length; ++i) {
            System.out.println(this.instructions[i].getInstructionText());
        }
    }

    public void executeInstructions(Connection connection) throws Exception {
        this.setConnection(connection);
        for (int i = 0; i < this.instructions.length; ++i) {
            String currentInstruction = this.instructions[i].getInstructionText();
            if (this.instructions[i].getInstructionType() == 1) {
                this.executeSingleUpdate(currentInstruction);
                continue;
            }
            if (this.instructions[i].getInstructionType() == 0) {
                this.executeSingleProcedure(currentInstruction, (DbProcParameter[])this.instructions[i].getInstructionDetail());
                continue;
            }
            if (this.instructions[i].getInstructionType() != 2) continue;
            this.executeJavaInvoke(currentInstruction, this.instructions[i].getInstructionDetail());
        }
    }

    public void cacheIntoDB(Connection connexion, String _package, int _itemOrder, String _pieceType, String _delimiter, Integer _keepDelimiter, String _dbProcName) throws Exception {
        this.setConnection(connexion);
        Statement pstmt = null;
        try {
            Long theLong = new Long(System.currentTimeMillis());
            String itemID = theLong.toString() + "-" + this.getIncrement().toString();
            pstmt = connexion.prepareStatement("insert into SR_UNINSTITEMS(SR_ITEM_ID, SR_PACKAGE, SR_ACTION_TAG, SR_ITEM_ORDER, SR_FILE_NAME, SR_FILE_TYPE, SR_DELIMITER, SR_KEEP_DELIMITER, SR_DBPROC_NAME) values ( ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            pstmt.setString(1, itemID);
            pstmt.setString(2, _package);
            pstmt.setString(3, this.actionName);
            pstmt.setInt(4, _itemOrder);
            pstmt.setString(5, this.pieceName);
            pstmt.setString(6, _pieceType);
            pstmt.setString(7, _delimiter);
            pstmt.setInt(8, _keepDelimiter);
            pstmt.setString(9, _dbProcName);
            pstmt.executeUpdate();
            String[] subS = this.getSubStrings(this.content);
            pstmt = connexion.prepareStatement("insert into SR_SCRIPTS(SR_ITEM_ID, SR_SEQ_NUM, SR_TEXT) values (?, ?, ? )");
            for (int i = 0; i < subS.length; ++i) {
                pstmt.setString(1, itemID);
                pstmt.setInt(2, i);
                pstmt.setString(3, subS[i]);
                pstmt.executeUpdate();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new Exception("\n\t\t***ERROR RETURNED BY THE RDBMS : " + ex.getMessage() + "\n", ex);
        }
        finally {
            if (pstmt != null) {
                pstmt.close();
            }
        }
    }

    public void executeSingleUpdate(String currentInstruction) throws Exception {
        if (this.traceMode) {
            String printableInstruction = StringUtil.sReplace((String)"\r\n", (String)" ", (String)currentInstruction);
            if ((printableInstruction = StringUtil.sReplace((String)"\t", (String)" ", (String)printableInstruction)).length() > 147) {
                printableInstruction = printableInstruction.substring(0, 146) + "...";
            }
            DBBuilder.printMessageln("\t\t>" + printableInstruction);
        }
        try {
            Statement stmt = this.connection.createStatement();
            stmt.executeUpdate(currentInstruction);
            stmt.close();
        }
        catch (Exception e) {
            throw new Exception("\n\t\t***ERROR RETURNED BY THE RDBMS : " + e.getMessage() + "\n\t\t***STATEMENT ON ERROR IS : " + "\n" + currentInstruction + "\n\t\t" + this.pieceName, e);
        }
    }

    public void executeSingleProcedure(String currentInstruction, DbProcParameter[] params) throws Exception {
        if (this.traceMode) {
            String printableInstruction = StringUtil.sReplace((String)"\n", (String)" ", (String)currentInstruction);
            if ((printableInstruction = StringUtil.sReplace((String)"\t", (String)" ", (String)printableInstruction)).length() > 147) {
                printableInstruction = printableInstruction.substring(0, 146) + "...";
            }
            DBBuilder.printMessageln("\t\t>" + printableInstruction);
        }
        try {
            QueryExecutor.executeProcedure(this.connection, currentInstruction, params);
        }
        catch (Exception e) {
            throw new Exception("\n\t\t***ERROR RETURNED BY THE RDBMS : " + e.getMessage() + "\n\t\t***STATEMENT ON ERROR IS : " + "\n" + currentInstruction, e);
        }
    }

    public void executeJavaInvoke(String currentInstruction, Object myClass) throws Exception {
        if (this.traceMode) {
            DBBuilder.printMessageln("\t\t>" + myClass.getClass().getName() + "." + currentInstruction + "()");
        }
        ((DbBuilderDynamicPart)myClass).setConnection(this.connection);
        Method methode = myClass.getClass().getMethod(currentInstruction, new Class[0]);
        if (methode == null) {
            throw new Exception("No method \"" + currentInstruction + "\" defined for \"" + myClass.getClass().getName() + "\" class.");
        }
        try {
            methode.invoke(myClass, (Object[])new Class[0]);
        }
        catch (Exception e) {
            throw new Exception("\n\t\t***ERROR RETURNED BY THE JVM : " + e.getMessage());
        }
    }

    private String getSqlStringValue(String s) {
        if (s == null) {
            return s;
        }
        return "'" + StringUtil.sReplace((String)"'", (String)"''", (String)s) + "'";
    }

    private String[] getSubStrings(String str) {
        int maxl = 1100;
        int nbS = str.length() / maxl;
        if (str.length() - nbS * maxl > 0) {
            ++nbS;
        }
        String tmpS = new String(str);
        String[] retS = new String[nbS];
        for (int i = 0; i < nbS; ++i) {
            if (i == nbS - 1) {
                retS[i] = tmpS;
                continue;
            }
            retS[i] = tmpS.substring(0, maxl - 1);
            tmpS = tmpS.substring(maxl - 1);
        }
        return retS;
    }

    private synchronized Integer getIncrement() {
        int i = increment;
        increment = new Integer(++i);
        return increment;
    }

    private String getContentFromDB(String itemID) throws Exception {
        Connection connexion = null;
        StringBuilder dbContent = new StringBuilder("");
        try {
            connexion = ConnectionFactory.getConnection();
            PreparedStatement pstmt = connexion.prepareStatement("select SR_SEQ_NUM, SR_TEXT from SR_SCRIPTS where SR_ITEM_ID = ? order by 1");
            pstmt.setString(1, itemID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                dbContent = dbContent.append(rs.getString("SR_TEXT"));
            }
            rs.close();
            pstmt.close();
        }
        catch (Exception e) {
            throw new Exception("\n\t\t***ERROR RETURNED BY THE JVM : " + e.getMessage() + "\n\t\t\t(" + "select SR_SEQ_NUM, SR_TEXT from " + "SR_SCRIPTS where SR_ITEM_ID = '" + itemID + "'  order by 1" + ")");
        }
        return dbContent.toString();
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }
}

