/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.dbbuilder.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.io.IOUtils;

public class Configuration {
    private static String dbbuilderHome = null;
    private static String dbbuilderData = null;
    private static final String DATA_KEY = "dbbuilder.data";
    private static final String HOME_KEY = "dbbuilder.home";
    private static final String DBREPOSITORY_SUBDIR = "dbRepository";
    private static final String CONTRIB_FILES_SUBDIR = "data";
    private static final String LOG_FILES_SUBDIR = "log";
    private static final String TEMP_FILES_SUBDIR = "temp";
    private static final String DIR_CONTRIBUTIONFILESROOT = Configuration.getHome() + File.separator + "dbRepository" + File.separator + "data";
    private static final String DIR_DBPIECESFILESROOT = Configuration.getHome() + File.separator + "dbRepository";
    private static final String DIR_TEMP = Configuration.getHome() + File.separator + "temp";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadResource(String propertyName) throws IOException {
        Properties properties = new Properties();
        InputStream in = Configuration.class.getClassLoader().getResourceAsStream(propertyName);
        try {
            if (in == null) {
                File configurationFile;
                String path = propertyName.replace('/', File.separatorChar);
                if (!(path = path.replace('\\', File.separatorChar)).startsWith(File.separator)) {
                    path = File.separatorChar + path;
                }
                if ((configurationFile = new File(Configuration.getHome() + File.separatorChar + "properties" + path)).exists()) {
                    in = new FileInputStream(configurationFile);
                }
            }
            if (in != null) {
                properties.load(in);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        return properties;
    }

    public static String getHome() {
        if (dbbuilderHome == null) {
            if (!System.getProperties().containsKey(HOME_KEY)) {
                System.err.println("### CANNOT FIND DBBUILDER INSTALL LOCATION ###");
                System.err.println("please use \"-Ddbbuilder.home=<install location>\" on the command line");
                System.exit(1);
            }
            dbbuilderHome = System.getProperty(HOME_KEY);
        }
        return dbbuilderHome;
    }

    public static String getContributionFilesDir() {
        return DIR_CONTRIBUTIONFILESROOT;
    }

    public static String getPiecesFilesDir() {
        return DIR_DBPIECESFILESROOT;
    }

    public static String getData() {
        if (dbbuilderData == null && System.getProperties().containsKey(DATA_KEY)) {
            dbbuilderData = System.getProperty(DATA_KEY);
        }
        return dbbuilderData;
    }

    public static String getTemp() {
        return DIR_TEMP;
    }

    public static String getLogDir() {
        return Configuration.getHome() + File.separator + LOG_FILES_SUBDIR;
    }

    private Configuration() {
    }
}

