/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.applicationbuilder;

import org.jdom.Content;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.silverpeas.applicationbuilder.ApplicationBuilder;
import org.silverpeas.applicationbuilder.XmlDocument;

public class AppDescriptor
extends XmlDocument {
    private static final String NAME = "application.xml";
    private static final String LOCATION = "META-INF";
    private static final String PUBLIC_ID = "-//Sun Microsystems, Inc.//DTD J2EE Application 1.2//EN";
    private static final String SYSTEM_ID = "http://java.sun.com/j2ee/dtds/application_1_2.dtd";
    private static final String ROOT_ELT = "application";
    private static final String NAME_ELT = "display-name";
    private static final String DESC_ELT = "description";
    private static final String MODULE_ELT = "module";
    private static final String MOD_EJB_ELT = "ejb";
    private static final String MOD_WEB_ELT = "web";
    private static final String MOD_LIB_ELT = "java";
    private static final String MOD_WEB_URI_ELT = "web-uri";
    private static final String MOD_WEB_ROOT_ELT = "context-root";

    public AppDescriptor() {
        super(LOCATION, NAME);
        this.setDocument();
    }

    public void addEJBName(String ejbJarName) {
        Element ejb = new Element(MOD_EJB_ELT);
        ejb.setText(ejbJarName);
        Element module = new Element(MODULE_ELT);
        module.addContent((Content)ejb);
        this.getDocument().getRootElement().addContent((Content)module);
    }

    public void setWARInfos(String webUri, String contextRoot) {
        Element uri = new Element(MOD_WEB_URI_ELT);
        uri.setText(webUri);
        Element rootCntxt = new Element(MOD_WEB_ROOT_ELT);
        rootCntxt.setText(contextRoot);
        Element web = new Element(MOD_WEB_ELT);
        web.addContent((Content)uri);
        web.addContent((Content)rootCntxt);
        Element module = new Element(MODULE_ELT);
        module.addContent((Content)web);
        this.getDocument().getRootElement().addContent((Content)module);
    }

    public void setClientInfos(String clientJarName) {
        Element lib = new Element(MOD_LIB_ELT);
        lib.setText(clientJarName);
        Element module = new Element(MODULE_ELT);
        module.addContent((Content)lib);
        this.getDocument().getRootElement().addContent((Content)module);
    }

    private void setDocument() {
        DocType type = new DocType(ROOT_ELT, PUBLIC_ID, SYSTEM_ID);
        Element root = new Element(ROOT_ELT);
        Element name = new Element(NAME_ELT);
        name.setText(ApplicationBuilder.getApplicationName());
        root.addContent((Content)name);
        Element desc = new Element(DESC_ELT);
        desc.setText(ApplicationBuilder.getApplicationDescription());
        root.addContent((Content)desc);
        Document doc = new Document(root, type);
        super.setDocument(doc);
    }
}

