/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.applicationbuilder;

import java.io.File;
import java.util.Arrays;
import org.silverpeas.applicationbuilder.AppBuilderException;
import org.silverpeas.applicationbuilder.ApplicationBuilderItem;
import org.silverpeas.applicationbuilder.ReadOnlyArchive;
import org.silverpeas.applicationbuilder.XmlDocument;
import org.silverpeas.util.Console;
import org.silverpeas.util.file.DirectoryLocator;

public class Contribution
extends XmlDocument
implements Comparable {
    private static final String CONTRIBUTION_TAG = "contribution";
    private static final String PRODUCT_ATTRIB = "product";
    private static final String TYPE_ATTRIB = "type";
    private static final String VERSION_ATTRIB = "version";
    private static final String WEB_APP_TAG = "web-application";
    private static final String EJB_TAG = "ejb";
    private static final String CLIENT_TAG = "client";
    private static final String LIB_TAG = "library";
    private ReadOnlyArchive theClientPart = null;
    private ApplicationBuilderItem[] theEJBs = null;
    private ReadOnlyArchive theWARPart = null;
    private ReadOnlyArchive[] theLibrairies = null;
    private String packageType = null;
    private final Console console;
    private Integer priority = null;

    public Contribution(File contributionHome, String name, Console console) throws AppBuilderException {
        super(contributionHome, name);
        this.console = console;
        this.load();
        boolean errorFound = false;
        try {
            this.setClientPart();
        }
        catch (AppBuilderException abe) {
            errorFound = true;
        }
        try {
            this.setEJBs();
        }
        catch (AppBuilderException abe) {
            errorFound = true;
        }
        try {
            this.setLibraries();
        }
        catch (AppBuilderException abe) {
            errorFound = true;
        }
        try {
            this.setWARPart();
        }
        catch (AppBuilderException abe) {
            errorFound = true;
        }
        if (errorFound) {
            throw new AppBuilderException("ERRORS related to \"" + this.getName() + "\" contribution file");
        }
    }

    private void setClientPart() throws AppBuilderException {
        String[] values = this.getTagValues(CLIENT_TAG);
        if (values == null) {
            this.theClientPart = null;
            return;
        }
        if (values.length > 1) {
            this.console.printError(this.getName() + " : \"" + CLIENT_TAG + "\" tag must be unique");
            throw new AppBuilderException();
        }
        try {
            this.theClientPart = new ReadOnlyArchive(new File(DirectoryLocator.getClientContribHome()), values[0], this.console);
        }
        catch (AppBuilderException abe) {
            this.console.printMessage(abe.getMessage());
            throw new AppBuilderException();
        }
    }

    public ReadOnlyArchive getClientPart() {
        return this.theClientPart;
    }

    private void setEJBs() throws AppBuilderException {
        String[] names = this.getTagValues(EJB_TAG);
        if (names == null) {
            this.theEJBs = null;
            return;
        }
        this.theEJBs = new ApplicationBuilderItem[names.length];
        boolean errorFound = false;
        File ejbContribHomeDir = new File(DirectoryLocator.getEjbContribHome());
        for (int i = 0; i < names.length; ++i) {
            this.theEJBs[i] = new ApplicationBuilderItem(ejbContribHomeDir, names[i]);
            if (this.theEJBs[i].getPath().exists() && this.theEJBs[i].getPath().canRead()) continue;
            this.console.printMessage('\"' + this.theEJBs[i].getPath().getAbsolutePath() + "\" not found or not readable");
            errorFound = true;
        }
        if (errorFound) {
            this.theEJBs = null;
            throw new AppBuilderException();
        }
    }

    public ApplicationBuilderItem[] getEJBs() {
        return this.theEJBs;
    }

    private void setWARPart() throws AppBuilderException {
        String[] values = this.getTagValues(WEB_APP_TAG);
        if (values == null) {
            this.theWARPart = null;
            return;
        }
        if (values.length > 1) {
            this.console.printMessage(this.getName() + " : found more than one \"" + WEB_APP_TAG + "\" tag");
            throw new AppBuilderException();
        }
        try {
            this.theWARPart = new ReadOnlyArchive(new File(DirectoryLocator.getWarContribHome()), values[0], this.console);
        }
        catch (AppBuilderException abe) {
            this.console.printMessage(abe.getMessage());
            throw new AppBuilderException();
        }
    }

    public ReadOnlyArchive getWARPart() {
        return this.theWARPart;
    }

    private void setLibraries() throws AppBuilderException {
        String[] names = this.getTagValues(LIB_TAG);
        if (names == null) {
            this.theLibrairies = null;
            return;
        }
        this.theLibrairies = new ReadOnlyArchive[names.length];
        boolean errorFound = false;
        for (int i = 0; i < names.length; ++i) {
            try {
                this.theLibrairies[i] = new ReadOnlyArchive(new File(DirectoryLocator.getLibContribHome()), names[i], this.console);
                continue;
            }
            catch (AppBuilderException abe) {
                this.console.printError(abe.getMessage(), abe);
                errorFound = true;
            }
        }
        if (errorFound) {
            this.theLibrairies = null;
            throw new AppBuilderException();
        }
    }

    public ReadOnlyArchive[] getLibraries() {
        return this.theLibrairies;
    }

    public String getPackageName() {
        return this.getAttributeValues(PRODUCT_ATTRIB)[0];
    }

    public String getPackageType() {
        if (this.packageType == null) {
            this.packageType = this.getAttributeValues(TYPE_ATTRIB)[0];
        }
        return this.packageType;
    }

    public boolean isApplicativeBusPackage() {
        return "bus".equalsIgnoreCase(this.getPackageType().trim());
    }

    public String getPackageVersion() {
        return this.getAttributeValues(VERSION_ATTRIB)[0];
    }

    public int compareTo(Object o) {
        if (this.equals(o)) {
            return 0;
        }
        if (this.getPriority().equals(((Contribution)o).getPriority())) {
            return this.getName().compareTo(((Contribution)o).getName());
        }
        return -this.getPriority().compareTo(((Contribution)o).getPriority());
    }

    public boolean equals(Object o) {
        return ((Contribution)o).getName().equals(this.getName());
    }

    private Integer getPriority() {
        if (this.priority == null) {
            boolean intFound = false;
            char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
            Arrays.sort(digits);
            int iChar = 0;
            while (Arrays.binarySearch(digits, this.getName().charAt(iChar)) > 0) {
                intFound = true;
                if (++iChar < this.getName().length()) continue;
            }
            this.priority = intFound ? new Integer(this.getName().substring(0, iChar)) : new Integer(-1);
        }
        return this.priority;
    }
}

