/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.applicationbuilder;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.silverpeas.applicationbuilder.AppBuilderException;
import org.silverpeas.applicationbuilder.Contribution;
import org.silverpeas.util.Console;
import org.silverpeas.util.file.DirectoryLocator;

public class Repository {
    private Contribution[] theContributions = null;
    private List<Contribution> theBusContributions = null;
    private List<Contribution> thePeasContributions = null;
    private final Console console;

    public Repository(Console console) throws AppBuilderException {
        this.console = console;
        this.setContributions();
    }

    public Contribution[] getContributions() {
        return this.theContributions;
    }

    public List<Contribution> getBusContributions() {
        return this.theBusContributions;
    }

    public List<Contribution> getPeasContributions() {
        return this.thePeasContributions;
    }

    private void setContributions() throws AppBuilderException {
        boolean errorFound = false;
        File contribDir = new File(DirectoryLocator.getContribFilesHome());
        String[] contributionNames = contribDir.list(new ContributionFilter());
        if (contributionNames == null) {
            contributionNames = new String[]{};
        }
        this.theContributions = new Contribution[contributionNames.length];
        this.thePeasContributions = new ArrayList<Contribution>();
        this.theBusContributions = new ArrayList<Contribution>();
        int errorCount = 0;
        for (int i = 0; i < contributionNames.length; ++i) {
            try {
                this.theContributions[i] = new Contribution(contribDir, contributionNames[i], this.console);
                if (this.theContributions[i].isApplicativeBusPackage()) {
                    this.theBusContributions.add(this.theContributions[i]);
                    continue;
                }
                this.thePeasContributions.add(this.theContributions[i]);
                continue;
            }
            catch (AppBuilderException abe) {
                this.console.printError("Error in abtaining the contributions ", abe);
                ++errorCount;
                errorFound = true;
            }
        }
        if (errorFound) {
            throw new AppBuilderException("found errors related to " + errorCount + " contribution files");
        }
        Arrays.sort(this.theContributions);
    }

    private class ContributionFilter
    implements FilenameFilter {
        private final String contributionFileSuffix = "-contribution.xml";

        ContributionFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase().endsWith("-contribution.xml".toLowerCase());
        }
    }
}

