/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.applicationbuilder;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;
import org.silverpeas.applicationbuilder.AppBuilderException;
import org.silverpeas.applicationbuilder.XmlDocument;

public class TargetAppServerDescriptor
extends XmlDocument {
    private static final String NAME = "targetAppServer.xml";
    private static final String SERVER_TAG = "app-server";
    private static final String SVRNAME_TAG = "name";
    private static final String SVRHOME_TAG = "home";
    private static final String SVRCLASS_TAG = "deploy-class";
    private static final String SVRSUBDIR_TAG = "repository-subdir";
    private static String repositorySpecificSubdir = null;

    public static void setRepositorySpecificSubdir(String subdir) {
        repositorySpecificSubdir = subdir;
    }

    public static String getRepositorySpecificSubdir() {
        return repositorySpecificSubdir;
    }

    public TargetAppServerDescriptor(File directory) throws AppBuilderException {
        super(directory, NAME);
        this.load();
    }

    public String[] getTargetAppServers() throws AppBuilderException {
        List serverElements = this.getDocument().getRootElement().getChildren(SERVER_TAG);
        if (serverElements.size() == 0) {
            String message = this.getPath().getAbsolutePath() + "\" does not contain any application server description";
            message = message + "\n\tit needs at least one \"app-server\" element";
            throw new AppBuilderException(message);
        }
        String[] result = new String[serverElements.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ((Element)serverElements.get(i)).getChildText(SVRNAME_TAG);
            if (result[i] != null) continue;
            String message = "a \"app-server\" element in " + this.getPath().getAbsolutePath() + "\" does not have a name";
            message = message + "\n\ta \"app-server\" element needs one \"name\" child";
            throw new AppBuilderException(message);
        }
        return result;
    }

    public String getRepositorySpecificSubdir(String appServer) throws AppBuilderException {
        return this.getAppServerInfo(appServer, SVRSUBDIR_TAG);
    }

    private String getAppServerInfo(String appServer, String tag) throws AppBuilderException {
        List serverElements = this.getDocument().getRootElement().getChildren(SERVER_TAG);
        Iterator iServer = serverElements.iterator();
        Element server = null;
        String theText = null;
        while (iServer.hasNext()) {
            theText = null;
            server = (Element)iServer.next();
            if (!server.getChildText(SVRNAME_TAG).equals(appServer)) continue;
            theText = server.getChildText(tag);
            if (theText == null) {
                throw new AppBuilderException(this.getName() + " :could not find \"" + tag + "\" element for \"" + appServer + '\"');
            }
            return theText;
        }
        return null;
    }
}

