/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.applicationbuilder;

import java.io.File;
import java.io.InputStream;
import java.util.HashSet;
import org.apache.commons.io.IOUtils;
import org.silverpeas.applicationbuilder.AppBuilderException;
import org.silverpeas.applicationbuilder.ApplicationBuilderItem;
import org.silverpeas.applicationbuilder.ReadOnlyArchive;
import org.silverpeas.applicationbuilder.WARDescriptor;
import org.silverpeas.applicationbuilder.WARDirectory;
import org.silverpeas.applicationbuilder.XmlDocument;
import org.silverpeas.util.Console;

public class WAR
extends WARDirectory {
    private static final String NAME = "war-ic.war";
    private WARDescriptor theWARDescriptor;
    protected static final String MANIFEST_PATH = "META-INF" + File.separator + "MANIFEST.MF";

    public WAR(File directory, Console console) throws AppBuilderException {
        super(directory, NAME, console);
        this.setWARDescriptor();
    }

    @Override
    public String getName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeWARPart(ReadOnlyArchive warPart) throws AppBuilderException {
        HashSet<String> excludeSet = new HashSet<String>(2);
        excludeSet.add(MANIFEST_PATH);
        excludeSet.add(this.getWARDescriptor().getArchivePath());
        this.mergeWith(warPart, excludeSet);
        ApplicationBuilderItem entry = new ApplicationBuilderItem(this.getWARDescriptor().getLocation(), this.getWARDescriptor().getName());
        InputStream descriptorIn = warPart.getEntry(entry);
        try {
            if (descriptorIn != null) {
                XmlDocument warPartDesc = new XmlDocument("", "web.xml from " + warPart.getName());
                warPartDesc.loadFrom(descriptorIn);
                this.getWARDescriptor().mergeWARPartDescriptor(warPartDesc);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)descriptorIn);
        }
    }

    public void close() throws AppBuilderException {
        this.integrateDescriptor();
    }

    public WARDescriptor getWARDescriptor() {
        return this.theWARDescriptor;
    }

    private void setWARDescriptor() {
        this.theWARDescriptor = new WARDescriptor();
    }

    private void integrateDescriptor() throws AppBuilderException {
        this.getWARDescriptor().sort();
        this.add(this.getWARDescriptor());
    }
}

