/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.applicationbuilder;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.silverpeas.applicationbuilder.AppBuilderException;
import org.silverpeas.applicationbuilder.ApplicationBuilderItem;
import org.silverpeas.applicationbuilder.ReadOnlyArchive;
import org.silverpeas.applicationbuilder.XmlDocument;
import org.silverpeas.util.Console;

public class WARDirectory
extends ApplicationBuilderItem {
    private File warDir = null;
    private Map<String, String> alreadyAddedFiles = new HashMap<String, String>();
    private final Console console;

    public WARDirectory(File directory, String fileName, Console console) throws AppBuilderException {
        super(directory, fileName);
        this.console = console;
        this.warDir = new File(directory, fileName);
    }

    public void add(XmlDocument xmlDoc) throws AppBuilderException {
        BufferedOutputStream out = null;
        try {
            File entry = this.getNormalizedEntry(xmlDoc.getLocation());
            out = new BufferedOutputStream(new FileOutputStream(new File(entry, xmlDoc.getName())));
            xmlDoc.saveTo(out);
            ((OutputStream)out).flush();
        }
        catch (IOException e) {
            try {
                throw new AppBuilderException(this.getName() + " : impossible to add the document \"" + xmlDoc.getArchivePath() + '\"', e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void add(ApplicationBuilderItem entry) throws AppBuilderException {
        InputStream contents = null;
        try {
            contents = entry.getPath().toURI().toURL().openStream();
            this.add(entry, contents);
        }
        catch (MalformedURLException mue) {
            try {
                throw new AppBuilderException(this.getName() + " : could not add \"" + entry.getName() + '\"', mue);
                catch (IOException ioe) {
                    throw new AppBuilderException(this.getName() + " : could not add \"" + entry.getName() + '\"', ioe);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(contents);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)contents);
    }

    public void mergeWith(ReadOnlyArchive archive) throws AppBuilderException {
        this.mergeWith(archive, (Set)null);
    }

    public void mergeWith(ReadOnlyArchive archive, String entryToExclude) throws AppBuilderException {
        HashSet<String> excludeSet = new HashSet<String>(1);
        excludeSet.add(entryToExclude);
        this.mergeWith(archive, excludeSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeWith(ReadOnlyArchive archive, Set entriesToExclude) throws AppBuilderException {
        ApplicationBuilderItem[] entries = archive.getEntries();
        boolean filterOn = entriesToExclude != null && !entriesToExclude.isEmpty();
        for (ApplicationBuilderItem myEntry : entries) {
            if (filterOn && entriesToExclude.contains(myEntry.getArchivePath())) continue;
            if (this.alreadyAddedFiles.containsKey(myEntry.getArchivePath())) {
                this.console.printMessage(this.getName() + " : already added from \"" + this.alreadyAddedFiles.get(myEntry.getArchivePath()) + "\" : \"" + archive.getName() + '!' + myEntry.getArchivePath() + "\" ");
                continue;
            }
            this.alreadyAddedFiles.put(myEntry.getArchivePath(), archive.getName());
            InputStream contents = archive.getEntry(myEntry);
            try {
                this.add(myEntry, contents);
            }
            finally {
                IOUtils.closeQuietly((InputStream)contents);
            }
        }
    }

    public void add(ApplicationBuilderItem entry, InputStream contents) throws AppBuilderException {
        BufferedOutputStream out = null;
        try {
            File destEntry = entry.getLocation() != null ? this.getNormalizedEntry(entry.getLocation()) : this.warDir;
            out = new BufferedOutputStream(new FileOutputStream(new File(destEntry, entry.getName())));
        }
        catch (Exception e) {
            throw new AppBuilderException(this.getName() + " : impossible to create new entry \"" + entry.getArchivePath() + '\"', e);
        }
        try {
            IOUtils.copy((InputStream)contents, (OutputStream)out);
        }
        catch (IOException e) {
            throw new AppBuilderException(this.getName() + " : impossible to write contents of \"" + entry.getArchivePath() + '\"', e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    private File getNormalizedEntry(String path) {
        File normalizedEntry = new File(this.warDir, path);
        normalizedEntry.mkdirs();
        return normalizedEntry;
    }
}

