/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.applicationbuilder;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.apache.commons.io.IOUtils;
import org.silverpeas.applicationbuilder.AppBuilderException;
import org.silverpeas.applicationbuilder.ApplicationBuilderItem;
import org.silverpeas.applicationbuilder.ReadOnlyArchive;
import org.silverpeas.applicationbuilder.XmlDocument;
import org.silverpeas.util.Console;

public class WriteOnlyArchive
extends ApplicationBuilderItem {
    protected Console console;
    protected static final String MANIFEST_PATH = "META-INF" + File.separator + "MANIFEST.MF";
    private Set<String> alreadyAddedDirs = new HashSet<String>();
    private Map<String, String> alreadyAddedFiles = new HashMap<String, String>();
    private JarOutputStream jarOut = null;

    public WriteOnlyArchive(File directory, String fileName, Console sonsole) throws AppBuilderException {
        super(directory, fileName);
        this.console = this.console;
        this.setOutputStream();
    }

    public void add(XmlDocument xmlDoc) throws AppBuilderException {
        try {
            this.addDirectory(xmlDoc.getLocation());
            ZipEntry entry = this.getNormalizedEntry(xmlDoc.getArchivePath());
            entry.setSize(xmlDoc.getDocumentSize());
            this.jarOut.putNextEntry(entry);
            xmlDoc.saveTo(this.getOutputStream());
            this.getOutputStream().flush();
            this.getOutputStream().closeEntry();
        }
        catch (Exception e) {
            throw new AppBuilderException(this.getName() + " : impossible to add the document \"" + xmlDoc.getArchivePath() + '\"', e);
        }
    }

    public void add(ApplicationBuilderItem entry) throws AppBuilderException {
        try {
            this.add(entry, entry.getPath().toURI().toURL().openStream());
        }
        catch (MalformedURLException mue) {
            throw new AppBuilderException(this.getName() + " : could not add \"" + entry.getName() + '\"', mue);
        }
        catch (IOException ioe) {
            throw new AppBuilderException(this.getName() + " : could not add \"" + entry.getName() + '\"', ioe);
        }
    }

    public void mergeWith(ReadOnlyArchive archive) throws AppBuilderException {
        this.mergeWith(archive, (Set<String>)null);
    }

    public void mergeWith(ReadOnlyArchive archive, String entryToExclude) throws AppBuilderException {
        HashSet<String> excludeSet = new HashSet<String>(1);
        excludeSet.add(entryToExclude);
        this.mergeWith(archive, excludeSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeWith(ReadOnlyArchive archive, Set<String> entriesToExclude) throws AppBuilderException {
        ApplicationBuilderItem[] entries = archive.getEntries();
        boolean filterOn = entriesToExclude != null && !entriesToExclude.isEmpty();
        for (ApplicationBuilderItem myEntry : entries) {
            if (filterOn && entriesToExclude.contains(myEntry.getArchivePath())) continue;
            if (this.alreadyAddedFiles.containsKey(myEntry.getArchivePath())) {
                this.console.printMessage(this.getName() + " : already added from \"" + this.alreadyAddedFiles.get(myEntry.getArchivePath()) + "\" : \"" + archive.getName() + '!' + myEntry.getArchivePath() + "\" ");
                continue;
            }
            this.alreadyAddedFiles.put(myEntry.getArchivePath(), archive.getName());
            InputStream contents = archive.getEntry(myEntry);
            try {
                this.add(myEntry, contents);
            }
            finally {
                IOUtils.closeQuietly((InputStream)contents);
            }
        }
    }

    public void close() throws AppBuilderException {
        try {
            this.getOutputStream().close();
        }
        catch (Exception e) {
            throw new AppBuilderException("Impossible to close the stream", e);
        }
    }

    public void add(ApplicationBuilderItem entry, InputStream contents) throws AppBuilderException {
        try {
            this.addDirectory(entry.getLocation());
            ZipEntry destEntry = this.getNormalizedEntry(entry.getArchivePath());
            destEntry.setSize(entry.getSize());
            this.getOutputStream().putNextEntry(destEntry);
        }
        catch (Exception e) {
            throw new AppBuilderException(this.getName() + " : impossible to create new entry \"" + entry.getArchivePath() + '\"', e);
        }
        try {
            IOUtils.copy((InputStream)contents, (OutputStream)this.getOutputStream());
            contents.close();
            this.getOutputStream().flush();
            this.getOutputStream().closeEntry();
        }
        catch (Exception e) {
            throw new AppBuilderException(this.getName() + " : impossible to write contents of \"" + entry.getArchivePath() + '\"', e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)contents);
        }
    }

    private JarOutputStream getOutputStream() {
        return this.jarOut;
    }

    private void setOutputStream() throws AppBuilderException {
        try {
            FileOutputStream out = new FileOutputStream(this.getPath().getAbsolutePath());
            this.jarOut = new JarOutputStream(out);
            this.jarOut.setMethod(8);
        }
        catch (Exception e) {
            throw new AppBuilderException(this.getPath().getAbsolutePath() + " : impossible to create", e);
        }
    }

    private void addDirectory(String directory) throws IOException {
        if (directory == null) {
            return;
        }
        if (this.alreadyAddedDirs.contains(directory)) {
            return;
        }
        if (directory.lastIndexOf(File.separator) != -1) {
            this.addDirectory(directory.substring(0, directory.lastIndexOf(File.separator)));
        }
        this.getOutputStream().putNextEntry(this.getNormalizedEntry(directory + File.separator));
        this.alreadyAddedDirs.add(directory);
    }

    private ZipEntry getNormalizedEntry(String sysDependantPath) {
        String pathOK = sysDependantPath.replace(File.separatorChar, '/');
        return new ZipEntry(pathOK);
    }
}

