/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.dbbuilder;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.jdom.Element;
import org.silverpeas.applicationbuilder.AppBuilderException;
import org.silverpeas.dbbuilder.DBBuilderDBItem;
import org.silverpeas.dbbuilder.DBBuilderDBProcPiece;
import org.silverpeas.dbbuilder.DBBuilderDynamicLibPiece;
import org.silverpeas.dbbuilder.DBBuilderFileItem;
import org.silverpeas.dbbuilder.DBBuilderItem;
import org.silverpeas.dbbuilder.DBBuilderMultipleStatementPiece;
import org.silverpeas.dbbuilder.DBBuilderPiece;
import org.silverpeas.dbbuilder.DBBuilderSingleStatementPiece;
import org.silverpeas.dbbuilder.DBXmlDocument;
import org.silverpeas.dbbuilder.VersionTag;
import org.silverpeas.dbbuilder.sql.ConnectionFactory;
import org.silverpeas.dbbuilder.sql.FileInformation;
import org.silverpeas.dbbuilder.sql.InstallSQLInstruction;
import org.silverpeas.dbbuilder.sql.MetaInstructions;
import org.silverpeas.dbbuilder.sql.RemoveSQLInstruction;
import org.silverpeas.dbbuilder.sql.SQLInstruction;
import org.silverpeas.dbbuilder.sql.UninstallInformations;
import org.silverpeas.dbbuilder.sql.UninstallSQLInstruction;
import org.silverpeas.dbbuilder.util.Action;
import org.silverpeas.dbbuilder.util.CommandLineParameters;
import org.silverpeas.dbbuilder.util.Configuration;
import org.silverpeas.dbbuilder.util.DatabaseType;
import org.silverpeas.util.Console;
import org.silverpeas.util.file.FileUtil;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class DBBuilder {
    public static final ResourceBundle messages = ResourceBundle.getBundle("messages");
    public static final String DBBuilderAppVersion = messages.getString("silverpeas.version");
    protected static Console console;
    public static final String CREATE_TABLE_TAG = "create_table";
    public static final String CREATE_INDEX_TAG = "create_index";
    public static final String CREATE_CONSTRAINT_TAG = "create_constraint";
    public static final String CREATE_DATA_TAG = "init";
    public static final String DROP_TABLE_TAG = "drop_table";
    public static final String DROP_INDEX_TAG = "drop_index";
    public static final String DROP_CONSTRAINT_TAG = "drop_constraint";
    public static final String DROP_DATA_TAG = "clean";
    public static final String[] TAGS_TO_MERGE_4_INSTALL;
    public static final String[] TAGS_TO_MERGE_4_UNINSTALL;
    public static final String[] TAGS_TO_MERGE_4_ALL;
    public static final String[] TAGS_TO_MERGE_4_OPTIMIZE;
    protected static final String FIRST_DBCONTRIBUTION_FILE = "dbbuilder-contribution.xml";
    protected static final String MASTER_DBCONTRIBUTION_FILE = "master-contribution.xml";
    protected static final String REQUIREMENT_TAG = "requirement";
    protected static final String DEPENDENCY_TAG = "dependency";
    protected static final String FILE_TAG = "file";
    protected static final String FILENAME_ATTRIB = "name";
    protected static final String PRODUCT_TAG = "product";
    protected static final String PRODUCTNAME_ATTRIB = "name";
    private static Properties dbBuilderResources;
    protected static final String DBBUILDER_MODULE = "dbbuilder";
    private static CommandLineParameters params;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ClassPathXmlApplicationContext springContext = new ClassPathXmlApplicationContext("classpath:/spring-jdbc-datasource.xml");
        try {
            Date startDate = new Date();
            System.out.println(MessageFormat.format(messages.getString("dbbuilder.start"), DBBuilderAppVersion, startDate));
            console = new Console(DBBuilder.class);
            console.printMessage("*************************************************************");
            console.printMessage(MessageFormat.format(messages.getString("dbbuilder.start"), DBBuilderAppVersion, startDate));
            dbBuilderResources = FileUtil.loadResource("/org/silverpeas/dbBuilder/settings/dbBuilderSettings.properties");
            params = new CommandLineParameters(console, args);
            if (params.isSimulate() && DatabaseType.ORACLE == params.getDbType()) {
                throw new Exception(messages.getString("oracle.simulate.error"));
            }
            console.printMessage(messages.getString("jdbc.connection.configuration"));
            console.printMessage(ConnectionFactory.getConnectionInfo());
            console.printMessage("\tAction        : " + (Object)((Object)params.getAction()));
            console.printMessage("\tVerbose mode  : " + params.isVerbose());
            console.printMessage("\tSimulate mode : " + params.isSimulate());
            if (Action.ACTION_CONNECT == params.getAction()) {
                console.printMessage(messages.getString("connection.success"));
                System.out.println(messages.getString("connection.success"));
            } else {
                console.printMessage("DB Status before build :");
                List<String> packagesIntoDB = DBBuilder.checkDBStatus();
                MetaInstructions sqlMetaInstructions = new MetaInstructions();
                File dirXml = new File(params.getDbType().getDBContributionDir());
                DBXmlDocument destXml = DBBuilder.loadMasterContribution(dirXml);
                UninstallInformations processesToCacheIntoDB = new UninstallInformations();
                Object[] listeFileXml = dirXml.listFiles();
                Arrays.sort(listeFileXml);
                ArrayList<DBXmlDocument> listeDBXmlDocument = new ArrayList<DBXmlDocument>(listeFileXml.length);
                int ignoredFiles = 0;
                console.printMessage(messages.getString("ignored.contribution"));
                for (Object xmlFile : listeFileXml) {
                    if (!((File)xmlFile).isFile() || !"xml".equals(FileUtil.getExtension((File)xmlFile)) || FIRST_DBCONTRIBUTION_FILE.equalsIgnoreCase(((File)xmlFile).getName()) || MASTER_DBCONTRIBUTION_FILE.equalsIgnoreCase(((File)xmlFile).getName())) continue;
                    DBXmlDocument fXml = new DBXmlDocument(dirXml, ((File)xmlFile).getName());
                    fXml.load();
                    if (DBBuilder.hasUnresolvedRequirements((File[])listeFileXml, fXml)) {
                        console.printMessage('\t' + ((File)xmlFile).getName() + " (because of unresolved requirements).");
                        ++ignoredFiles;
                        continue;
                    }
                    if (Action.ACTION_ENFORCE_UNINSTALL == params.getAction()) {
                        console.printMessage('\t' + ((File)xmlFile).getName() + " (because of " + (Object)((Object)Action.ACTION_ENFORCE_UNINSTALL) + " mode).");
                        ++ignoredFiles;
                        continue;
                    }
                    listeDBXmlDocument.add(fXml);
                }
                if (0 == ignoredFiles) {
                    console.printMessage("\t(none)");
                }
                HashMap packagesIntoFile = new HashMap();
                int j = 0;
                console.printMessage(messages.getString("merged.contribution"));
                console.printMessage(params.getAction().toString());
                if (Action.ACTION_ENFORCE_UNINSTALL != params.getAction()) {
                    console.printMessage("\tdbbuilder-contribution.xml");
                    ++j;
                }
                for (DBXmlDocument currentDoc : listeDBXmlDocument) {
                    console.printMessage('\t' + currentDoc.getName());
                    ++j;
                }
                if (0 == j) {
                    console.printMessage("\t(none)");
                }
                console.printMessage("Build decisions are :");
                if (Action.ACTION_ENFORCE_UNINSTALL != params.getAction()) {
                    DBXmlDocument fileXml;
                    try {
                        fileXml = new DBXmlDocument(dirXml, FIRST_DBCONTRIBUTION_FILE);
                        fileXml.load();
                    }
                    catch (Exception e) {
                        fileXml = null;
                    }
                    if (null != fileXml) {
                        DBBuilderFileItem dbbuilderItem = new DBBuilderFileItem(fileXml);
                        packagesIntoFile.put(dbbuilderItem.getModule(), null);
                        DBBuilder.mergeActionsToDo(dbbuilderItem, destXml, processesToCacheIntoDB, sqlMetaInstructions);
                    }
                }
                for (DBXmlDocument currentDoc : listeDBXmlDocument) {
                    DBBuilderFileItem tmpdbbuilderItem = new DBBuilderFileItem(currentDoc);
                    packagesIntoFile.put(tmpdbbuilderItem.getModule(), null);
                    DBBuilder.mergeActionsToDo(tmpdbbuilderItem, destXml, processesToCacheIntoDB, sqlMetaInstructions);
                }
                ArrayList<String> itemsList = new ArrayList<String>();
                boolean foundDBBuilder = false;
                for (String dbPackage : packagesIntoDB) {
                    if (packagesIntoFile.containsKey(dbPackage)) continue;
                    if (DBBUILDER_MODULE.equalsIgnoreCase(dbPackage)) {
                        foundDBBuilder = true;
                        continue;
                    }
                    if (Action.ACTION_ENFORCE_UNINSTALL == params.getAction()) {
                        if (!dbPackage.equals(params.getModuleName())) continue;
                        itemsList.add(0, dbPackage);
                        continue;
                    }
                    itemsList.add(0, dbPackage);
                }
                if (foundDBBuilder) {
                    if (Action.ACTION_ENFORCE_UNINSTALL == params.getAction()) {
                        if (DBBUILDER_MODULE.equals(params.getModuleName())) {
                            itemsList.add(itemsList.size(), DBBUILDER_MODULE);
                        }
                    } else {
                        itemsList.add(itemsList.size(), DBBUILDER_MODULE);
                    }
                }
                for (String item : itemsList) {
                    console.printMessage("**** Treating " + item + " ****");
                    DBBuilderDBItem tmpdbbuilderItem = new DBBuilderDBItem(item);
                    DBBuilder.mergeActionsToDo(tmpdbbuilderItem, destXml, processesToCacheIntoDB, sqlMetaInstructions);
                }
                destXml.setName("res.txt");
                destXml.save();
                console.printMessage("Build parts are :");
                if (Action.ACTION_INSTALL == params.getAction()) {
                    DBBuilder.processDB(destXml, processesToCacheIntoDB, sqlMetaInstructions, TAGS_TO_MERGE_4_INSTALL);
                } else if (Action.ACTION_UNINSTALL == params.getAction() || Action.ACTION_ENFORCE_UNINSTALL == params.getAction()) {
                    DBBuilder.processDB(destXml, processesToCacheIntoDB, sqlMetaInstructions, TAGS_TO_MERGE_4_UNINSTALL);
                } else if (Action.ACTION_OPTIMIZE == params.getAction()) {
                    DBBuilder.processDB(destXml, processesToCacheIntoDB, sqlMetaInstructions, TAGS_TO_MERGE_4_OPTIMIZE);
                } else if (Action.ACTION_ALL == params.getAction()) {
                    DBBuilder.processDB(destXml, processesToCacheIntoDB, sqlMetaInstructions, TAGS_TO_MERGE_4_ALL);
                }
                console.printMessage("Finally DB Status :");
                DBBuilder.checkDBStatus();
            }
            Date endDate = new Date();
            console.printMessage(MessageFormat.format(messages.getString("dbbuilder.success"), endDate));
            System.out.println("*******************************************************************");
            System.out.println(MessageFormat.format(messages.getString("dbbuilder.success"), endDate));
        }
        catch (Exception e) {
            e.printStackTrace();
            console.printError(e.getMessage(), e);
            Date endDate = new Date();
            console.printError(MessageFormat.format(messages.getString("dbbuilder.failure"), endDate));
            System.out.println("*******************************************************************");
            System.out.println(MessageFormat.format(messages.getString("dbbuilder.failure"), endDate));
            System.exit(1);
        }
        finally {
            springContext.close();
            console.close();
        }
    }

    private static boolean hasUnresolvedRequirements(File[] listeFileXml, DBXmlDocument fXml) {
        Element root = fXml.getDocument().getRootElement();
        List listeDependencies = root.getChildren(REQUIREMENT_TAG);
        if (null != listeDependencies) {
            for (Element eltDependencies : listeDependencies) {
                List listeDependencyFiles = eltDependencies.getChildren(FILE_TAG);
                for (Element eltDependencyFile : listeDependencyFiles) {
                    String name = eltDependencyFile.getAttributeValue("name");
                    boolean found = false;
                    for (int i = 0; i < listeFileXml.length; ++i) {
                        File f = listeFileXml[i];
                        if (!f.getName().equals(name)) continue;
                        found = true;
                        i = listeFileXml.length;
                    }
                    if (found) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static Properties getdbBuilderResources() {
        return dbBuilderResources;
    }

    public static void mergeActionsToDo(DBBuilderItem pdbbuilderItem, DBXmlDocument xmlFile, UninstallInformations processesToCacheIntoDB, MetaInstructions sqlMetaInstructions) {
        String versionFile;
        String versionDB;
        String package_name = pdbbuilderItem.getModule();
        try {
            versionDB = pdbbuilderItem.getVersionFromDB();
            versionFile = pdbbuilderItem.getVersionFromFile();
        }
        catch (Exception e) {
            console.printError("", e);
            return;
        }
        String[] tags_to_merge = null;
        List<VersionTag> blocks_merge = new ArrayList<VersionTag>();
        if (pdbbuilderItem instanceof DBBuilderFileItem) {
            int iversionFile;
            DBBuilderFileItem dbbuilderItem = (DBBuilderFileItem)pdbbuilderItem;
            int iversionDB = -1;
            if (!versionDB.equals("xxx")) {
                iversionDB = Integer.parseInt(versionDB);
            }
            if (iversionDB == (iversionFile = Integer.parseInt(versionFile))) {
                if (params.getAction().isMigration()) {
                    console.printMessage('\t' + package_name + " is up to date with version " + versionFile + '.');
                } else {
                    console.printMessage('\t' + package_name + " is up to date with version " + versionFile + " and will be optimized.");
                    tags_to_merge = TAGS_TO_MERGE_4_OPTIMIZE;
                    blocks_merge = Collections.singletonList(new VersionTag("current", versionFile));
                }
            } else if (iversionDB > iversionFile) {
                console.printMessage('\t' + package_name + " will be ignored because this package is newer into DB than installed files.");
            } else {
                if (params.getAction().isMigration()) {
                    if (-1 == iversionDB) {
                        console.printMessage('\t' + package_name + " will be installed with version " + versionFile + '.');
                        tags_to_merge = TAGS_TO_MERGE_4_INSTALL;
                        blocks_merge = Collections.singletonList(new VersionTag("current", versionFile));
                        processesToCacheIntoDB.addInformation(dbbuilderItem.getModule(), package_name, dbbuilderItem.getFileXml());
                        sqlMetaInstructions.addInstruction(dbbuilderItem.getModule(), new InstallSQLInstruction(versionFile, package_name));
                    } else {
                        console.printMessage('\t' + package_name + " will be upgraded from " + versionDB + " to " + versionFile + '.');
                        tags_to_merge = TAGS_TO_MERGE_4_INSTALL;
                        for (int i = 0; i < iversionFile - iversionDB; ++i) {
                            int currentVersion = iversionDB + i;
                            String sversionFile = "000" + currentVersion;
                            sversionFile = sversionFile.substring(sversionFile.length() - 3);
                            VersionTag version = new VersionTag("upgrade", sversionFile);
                            blocks_merge.add(version);
                            sqlMetaInstructions.addInstruction(dbbuilderItem.getModule(), new UninstallSQLInstruction(version.getResultingVersion(), package_name));
                        }
                        processesToCacheIntoDB.addInformation(dbbuilderItem.getModule(), package_name, dbbuilderItem.getFileXml());
                    }
                } else if (Action.ACTION_OPTIMIZE == params.getAction()) {
                    console.printMessage('\t' + package_name + " will be optimized.");
                    tags_to_merge = TAGS_TO_MERGE_4_OPTIMIZE;
                    blocks_merge = Collections.singletonList(new VersionTag("current", versionFile));
                }
                if (!blocks_merge.isEmpty() && null != tags_to_merge) {
                    try {
                        xmlFile.mergeWith(pdbbuilderItem, tags_to_merge, blocks_merge);
                    }
                    catch (Exception e) {
                        console.printError("Error with " + pdbbuilderItem.getModule() + ' ' + e.getMessage(), e);
                    }
                }
            }
        } else if (pdbbuilderItem instanceof DBBuilderDBItem) {
            if (Action.ACTION_UNINSTALL == params.getAction() || Action.ACTION_ALL == params.getAction() || Action.ACTION_ENFORCE_UNINSTALL == params.getAction()) {
                console.printMessage('\t' + package_name + " will be uninstalled.");
                tags_to_merge = TAGS_TO_MERGE_4_UNINSTALL;
                if (!DBBUILDER_MODULE.equalsIgnoreCase(package_name)) {
                    System.out.println("delete from SR_");
                    sqlMetaInstructions.addInstruction(pdbbuilderItem.getModule(), new RemoveSQLInstruction(package_name));
                }
                if (null != tags_to_merge) {
                    try {
                        xmlFile.mergeWith(pdbbuilderItem, tags_to_merge, null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            console.printMessage("");
            console.printMessage("*** AVERTISSEMENT ***");
            console.printMessage("\t Le Module " + package_name + " est pr\u00e9sent en BD mais n'a pas de scripts SQL fichiers");
            console.printMessage("");
            console.printMessage("*** AVERTISSEMENT ***");
            console.printMessage("Le Module " + package_name + " est pr\u00e9sent en BD mais n'a pas de scripts SQL fichiers");
        }
    }

    private static void processDB(DBXmlDocument xmlFile, UninstallInformations processesToCacheIntoDB, MetaInstructions sqlMetaInstructions, String[] tagsToProcess) throws Exception {
        Element root = xmlFile.getDocument().getRootElement();
        List modules = root.getChildren("module");
        for (Element module : modules) {
            Connection connection = null;
            try {
                connection = ConnectionFactory.getConnection();
                connection.setAutoCommit(false);
                DBBuilder.processSQLFiles(connection, module, tagsToProcess, sqlMetaInstructions);
                DBBuilder.cacheIntoDb(connection, processesToCacheIntoDB.getInformations(module.getAttributeValue("id")));
                if (params.isSimulate()) {
                    DbUtils.rollback((Connection)connection);
                    continue;
                }
                connection.commit();
            }
            catch (Exception e) {
                DbUtils.rollback((Connection)connection);
                throw e;
            }
            finally {
                DbUtils.closeQuietly((Connection)connection);
            }
        }
        console.printMessage("DB Status after build :");
        DBBuilder.checkDBStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static List<String> checkDBStatus() {
        ArrayList<String> packagesIntoDB = new ArrayList<String>();
        Connection connection = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            connection = ConnectionFactory.getConnection();
            stmt = connection.createStatement();
            rs = stmt.executeQuery("select SR_PACKAGE, SR_VERSION from SR_PACKAGES order by SR_PACKAGE");
            while (rs.next()) {
                String srPackage = rs.getString("SR_PACKAGE");
                String srVersion = rs.getString("SR_VERSION");
                console.printMessage('\t' + srPackage + " v. " + srVersion);
                packagesIntoDB.add(srPackage);
            }
        }
        catch (SQLException sqlex) {
            DbUtils.closeQuietly(rs);
            DbUtils.closeQuietly((Statement)stmt);
            DbUtils.closeQuietly((Connection)connection);
            catch (Throwable throwable) {
                DbUtils.closeQuietly(rs);
                DbUtils.closeQuietly((Statement)stmt);
                DbUtils.closeQuietly((Connection)connection);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((ResultSet)rs);
        DbUtils.closeQuietly((Statement)stmt);
        DbUtils.closeQuietly((Connection)connection);
        return packagesIntoDB;
    }

    private static void processSQLFiles(Connection connection, Element moduleRoot, String[] tagsToProcess, MetaInstructions metaInstructions) throws Exception {
        DBBuilderPiece dbBuilderPiece = null;
        for (int i = 0; i < tagsToProcess.length; ++i) {
            int nbFiles = 0;
            List listeTags = moduleRoot.getChildren(tagsToProcess[i]);
            for (Element eltTag : listeTags) {
                boolean keepdelimiter;
                String dbprocname;
                String skeepdelimiter;
                String delimiter;
                String nomTag = eltTag.getName();
                List listeRowFiles = eltTag.getChildren("row");
                for (Element eltFile : listeRowFiles) {
                    String name = eltFile.getAttributeValue("name");
                    String value = eltFile.getAttributeValue("type");
                    Integer order = new Integer(eltFile.getAttributeValue("sequence"));
                    delimiter = eltFile.getAttributeValue("delimiter");
                    skeepdelimiter = eltFile.getAttributeValue("keepdelimiter");
                    dbprocname = eltFile.getAttributeValue("dbprocname");
                    keepdelimiter = "YES".equals(skeepdelimiter);
                    console.printMessage('\t' + tagsToProcess[i] + " : internal-id : " + name + "\t type : " + value);
                    ++nbFiles;
                    if ("sqlstatement".equals(value)) {
                        dbBuilderPiece = new DBBuilderSingleStatementPiece(console, name, name + '(' + order + ')', nomTag, order, params.isVerbose());
                    } else if ("sqlstatementlist".equals(value)) {
                        dbBuilderPiece = new DBBuilderMultipleStatementPiece(console, name, name + '(' + order + ')', nomTag, order, params.isVerbose(), delimiter, keepdelimiter);
                    } else if ("dbprocedure".equals(value)) {
                        dbBuilderPiece = new DBBuilderDBProcPiece(console, name, name + '(' + order + ')', nomTag, order, params.isVerbose(), dbprocname);
                    }
                    if (null == dbBuilderPiece) continue;
                    dbBuilderPiece.executeInstructions(connection);
                }
                List listeFiles = eltTag.getChildren(FILE_TAG);
                for (Element eltFile : listeFiles) {
                    String name = DBBuilder.getCleanPath(eltFile.getAttributeValue("name"));
                    String value = eltFile.getAttributeValue("type");
                    delimiter = eltFile.getAttributeValue("delimiter");
                    skeepdelimiter = eltFile.getAttributeValue("keepdelimiter");
                    dbprocname = eltFile.getAttributeValue("dbprocname");
                    keepdelimiter = null != skeepdelimiter && skeepdelimiter.equals("YES");
                    String classname = eltFile.getAttributeValue("classname");
                    String methodname = eltFile.getAttributeValue("methodname");
                    console.printMessage('\t' + tagsToProcess[i] + " : name : " + name + "\t type : " + value);
                    ++nbFiles;
                    if ("sqlstatement".equals(value)) {
                        dbBuilderPiece = new DBBuilderSingleStatementPiece(console, Configuration.getPiecesFilesDir() + File.separatorChar + name, nomTag, params.isVerbose());
                    } else if ("sqlstatementlist".equals(value)) {
                        dbBuilderPiece = new DBBuilderMultipleStatementPiece(console, Configuration.getPiecesFilesDir() + File.separatorChar + name, nomTag, params.isVerbose(), delimiter, keepdelimiter);
                    } else if ("dbprocedure".equals(value)) {
                        dbBuilderPiece = new DBBuilderDBProcPiece(console, Configuration.getPiecesFilesDir() + File.separatorChar + name, nomTag, params.isVerbose(), dbprocname);
                    } else if ("javalib".equals(value)) {
                        dbBuilderPiece = new DBBuilderDynamicLibPiece(console, Configuration.getPiecesFilesDir() + File.separatorChar + name, nomTag, params.isVerbose(), classname, methodname);
                    }
                    if (null == dbBuilderPiece) continue;
                    dbBuilderPiece.executeInstructions(connection);
                }
            }
            if (false != nbFiles) continue;
            console.printMessage('\t' + tagsToProcess[i] + " : (none)");
        }
        List<SQLInstruction> sqlMetaInstructions = metaInstructions.getInstructions(moduleRoot.getAttributeValue("id"));
        if (sqlMetaInstructions.isEmpty()) {
            console.printMessage("\tdbbuilder meta base maintenance : (none)");
        } else {
            console.printMessage("\tdbbuilder meta base maintenance :");
            for (SQLInstruction instruction : sqlMetaInstructions) {
                instruction.execute(connection);
            }
        }
    }

    protected static void cacheIntoDb(Connection connection, List<FileInformation> informations) throws Exception {
        console.printMessage(System.getProperty("line.separator") + "Uninstall stored parts are :");
        String[] tagsToProcessU = TAGS_TO_MERGE_4_UNINSTALL;
        for (FileInformation information : informations) {
            String pName = information.getSrPackage();
            DBXmlDocument xFile = information.getDocument();
            Element rootU = xFile.getDocument().getRootElement();
            int nbFilesU = 0;
            for (int i = 0; i < tagsToProcessU.length; ++i) {
                List listeTagsCU = rootU.getChildren("current");
                for (Element eltTagCU : listeTagsCU) {
                    List listeTagsU = eltTagCU.getChildren(tagsToProcessU[i]);
                    for (Element eltTagU : listeTagsU) {
                        List listeFilesU = eltTagU.getChildren(FILE_TAG);
                        Iterator iterFilesU = listeFilesU.iterator();
                        int iFile = 1;
                        while (iterFilesU.hasNext()) {
                            DBBuilderPiece pU;
                            Element eltFileU = (Element)iterFilesU.next();
                            String nameU = DBBuilder.getCleanPath(eltFileU.getAttributeValue("name"));
                            String valueU = eltFileU.getAttributeValue("type");
                            String delimiterU = eltFileU.getAttributeValue("delimiter");
                            String skeepdelimiterU = eltFileU.getAttributeValue("keepdelimiter");
                            String dbprocnameU = eltFileU.getAttributeValue("dbprocname");
                            boolean keepdelimiterU = null != skeepdelimiterU && skeepdelimiterU.equals("YES");
                            console.printMessage('\t' + tagsToProcessU[i] + " : name : " + nameU + "\t type : " + valueU);
                            if (valueU.equals("sqlstatement")) {
                                pU = new DBBuilderSingleStatementPiece(console, Configuration.getPiecesFilesDir() + File.separatorChar + nameU, tagsToProcessU[i], params.isVerbose());
                                pU.cacheIntoDB(connection, pName, iFile);
                            } else if (valueU.equals("sqlstatementlist")) {
                                pU = new DBBuilderMultipleStatementPiece(console, Configuration.getPiecesFilesDir() + File.separatorChar + nameU, tagsToProcessU[i], params.isVerbose(), delimiterU, keepdelimiterU);
                                pU.cacheIntoDB(connection, pName, iFile);
                            } else if (valueU.equals("dbprocedure")) {
                                pU = new DBBuilderDBProcPiece(console, Configuration.getPiecesFilesDir() + File.separatorChar + nameU, tagsToProcessU[i], params.isVerbose(), dbprocnameU);
                                pU.cacheIntoDB(connection, pName, iFile);
                            }
                            ++iFile;
                            ++nbFilesU;
                        }
                    }
                }
                if (false != nbFilesU) continue;
                console.printMessage('\t' + tagsToProcessU[i] + " : (none)");
            }
        }
    }

    private static String getCleanPath(String name) {
        String path = name.replace('/', File.separatorChar);
        return path.replace('\\', File.separatorChar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DBXmlDocument loadMasterContribution(File dirXml) throws IOException, AppBuilderException {
        DBXmlDocument destXml = new DBXmlDocument(dirXml, MASTER_DBCONTRIBUTION_FILE);
        destXml.setOutputEncoding("UTF-8");
        if (!destXml.getPath().exists()) {
            destXml.getPath().createNewFile();
            BufferedWriter destXmlOut = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(destXml.getPath(), false), Charsets.UTF_8));
            try {
                destXmlOut.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                destXmlOut.newLine();
                destXmlOut.write("<allcontributions>");
                destXmlOut.newLine();
                destXmlOut.write("</allcontributions>");
                destXmlOut.newLine();
                destXmlOut.flush();
            }
            finally {
                IOUtils.closeQuietly((Writer)destXmlOut);
            }
        }
        destXml.load();
        return destXml;
    }

    private DBBuilder() {
    }

    static {
        TAGS_TO_MERGE_4_INSTALL = new String[]{CREATE_TABLE_TAG, CREATE_INDEX_TAG, CREATE_CONSTRAINT_TAG, CREATE_DATA_TAG};
        TAGS_TO_MERGE_4_UNINSTALL = new String[]{DROP_CONSTRAINT_TAG, DROP_INDEX_TAG, DROP_DATA_TAG, DROP_TABLE_TAG};
        TAGS_TO_MERGE_4_ALL = new String[]{DROP_CONSTRAINT_TAG, DROP_INDEX_TAG, DROP_DATA_TAG, DROP_TABLE_TAG, CREATE_TABLE_TAG, CREATE_INDEX_TAG, CREATE_CONSTRAINT_TAG, CREATE_DATA_TAG};
        TAGS_TO_MERGE_4_OPTIMIZE = new String[]{DROP_INDEX_TAG, CREATE_INDEX_TAG};
        dbBuilderResources = new Properties();
        params = null;
    }
}

