/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.dbbuilder;

import java.sql.Connection;
import org.silverpeas.dbbuilder.DBBuilderPiece;
import org.silverpeas.dbbuilder.Instruction;
import org.silverpeas.dbbuilder.dbbuilder_dl.DbBuilderDynamicPart;
import org.silverpeas.dbbuilder.util.Configuration;
import org.silverpeas.dbbuilder.util.DynamicLoader;
import org.silverpeas.util.ConfigurationHolder;
import org.silverpeas.util.Console;

public class DBBuilderDynamicLibPiece
extends DBBuilderPiece {
    private String method;
    private final DynamicLoader loader;
    private DbBuilderDynamicPart dynamicPart = null;

    private DBBuilderDynamicLibPiece(Console console, String pieceName, String actionName, boolean traceMode) throws Exception {
        super(console, pieceName, actionName, traceMode);
        this.loader = new DynamicLoader(console);
    }

    private DBBuilderDynamicLibPiece(Console console, String pieceName, String actionName, String content, boolean traceMode) throws Exception {
        super(console, pieceName, actionName, content, traceMode);
        this.loader = new DynamicLoader(console);
    }

    public DBBuilderDynamicLibPiece(Console console, String pieceName, String actionName, boolean traceMode, String className, String methodName) throws Exception {
        super(console, pieceName, actionName, traceMode);
        this.loader = new DynamicLoader(console);
        this.moreInitialize(className, methodName);
    }

    public DBBuilderDynamicLibPiece(Console console, String pieceName, String actionName, String content, boolean traceMode, String className, String methodName) throws Exception {
        super(console, pieceName, actionName, content, traceMode);
        this.loader = new DynamicLoader(console);
        this.moreInitialize(className, methodName);
    }

    private void moreInitialize(String className, String methodName) throws Exception {
        if (className == null) {
            throw new Exception("Missing <classname> tag for \"pieceName\" item.");
        }
        if (methodName == null) {
            throw new Exception("Missing <methodname> tag for \"pieceName\" item.");
        }
        try {
            this.dynamicPart = this.loader.loadDynamicPart(className);
            this.method = methodName;
        }
        catch (IllegalAccessException e) {
            throw new Exception("Unable to load \"" + className + "\" class.");
        }
        catch (ClassNotFoundException e) {
            throw new Exception("Unable to load \"" + className + "\" class.");
        }
        catch (InstantiationException e) {
            throw new Exception("Unable to load \"" + className + "\" class.");
        }
        this.dynamicPart.setSILVERPEAS_HOME(ConfigurationHolder.getHome());
        this.dynamicPart.setSILVERPEAS_DATA(Configuration.getData());
        this.dynamicPart.setConsole(this.getConsole());
        this.setInstructions();
    }

    @Override
    public void setInstructions() {
        this.instructions = new Instruction[1];
        this.instructions[0] = new Instruction(2, this.method, this.dynamicPart);
    }

    @Override
    public void cacheIntoDB(Connection connection, String _package, int _itemOrder) throws Exception {
    }

    @Override
    public void setConnection(Connection connection) {
        super.setConnection(connection);
        if (this.dynamicPart != null) {
            this.dynamicPart.setConnection(connection);
        }
    }
}

