/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.dbbuilder;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.silverpeas.dbbuilder.DBBuilderPiece;
import org.silverpeas.dbbuilder.Instruction;
import org.silverpeas.util.Console;
import org.silverpeas.util.StringUtil;

public class DBBuilderMultipleStatementPiece
extends DBBuilderPiece {
    private String delimiter = null;
    private boolean keepDelimiter = false;

    private DBBuilderMultipleStatementPiece(Console console, String pieceName, String actionName, boolean traceMode) throws Exception {
        super(console, pieceName, actionName, traceMode);
    }

    private DBBuilderMultipleStatementPiece(Console console, String pieceName, String actionName, String content, boolean traceMode) throws Exception {
        super(console, pieceName, actionName, content, traceMode);
    }

    private DBBuilderMultipleStatementPiece(Console console, String actionInternalID, String pieceName, String actionName, int itemOrder, boolean traceMode) throws Exception {
        super(console, actionInternalID, pieceName, actionName, itemOrder, traceMode);
    }

    public DBBuilderMultipleStatementPiece(Console console, String pieceName, String actionName, boolean traceMode, String delimiter, boolean keepDelimiter) throws Exception {
        super(console, pieceName, actionName, traceMode);
        this.moreInitialize(delimiter, keepDelimiter);
    }

    public DBBuilderMultipleStatementPiece(Console console, String pieceName, String actionName, String content, boolean traceMode, String delimiter, boolean keepDelimiter) throws Exception {
        super(console, pieceName, actionName, content, traceMode);
        this.moreInitialize(delimiter, keepDelimiter);
    }

    public DBBuilderMultipleStatementPiece(Console console, String actionInternalID, String pieceName, String actionName, int itemOrder, boolean traceMode, String delimiter, boolean keepDelimiter) throws Exception {
        super(console, actionInternalID, pieceName, actionName, itemOrder, traceMode);
        this.moreInitialize(delimiter, keepDelimiter);
    }

    private void moreInitialize(String delimiter, boolean keepDelimiter) throws Exception {
        if (delimiter == null) {
            throw new Exception("Missing <delimiter> tag for \"pieceName\" item.");
        }
        String d = StringUtil.sReplace("\\n", "\n", delimiter);
        this.delimiter = d = StringUtil.sReplace("\\t", "\t", d);
        this.keepDelimiter = keepDelimiter;
        this.setInstructions();
    }

    @Override
    public void setInstructions() {
        if (this.getContent() != null && this.delimiter != null) {
            List<String> tokens = this.tokenizeAll(this.getContent(), this.delimiter, this.keepDelimiter);
            this.instructions = new Instruction[tokens.size()];
            for (int i = 0; i < tokens.size(); ++i) {
                this.instructions[i] = new Instruction(1, tokens.get(i), null);
            }
        }
    }

    @Override
    public void cacheIntoDB(Connection connection, String _package, int _itemOrder) throws Exception {
        Integer kd = this.keepDelimiter ? Integer.valueOf(1) : Integer.valueOf(0);
        this.cacheIntoDB(connection, _package, _itemOrder, "sqlstatementlist", this.delimiter, kd, null);
    }

    private List<String> tokenizeAll(String str, String delimiter, boolean keepDelimiter) {
        ArrayList<String> tokens = new ArrayList<String>();
        int curi = 0;
        while (curi < str.length() && curi >= 0) {
            String instruction;
            int previ = curi;
            if ((curi = str.indexOf(delimiter, curi)) < str.length() && curi >= 0) {
                String instruction2;
                int endIndex = curi;
                if (keepDelimiter) {
                    endIndex = curi + delimiter.length();
                }
                if (!" ".equals(instruction2 = str.substring(previ, endIndex).trim()) && instruction2 != null && !instruction2.isEmpty()) {
                    tokens.add(instruction2);
                }
                curi += delimiter.length();
                continue;
            }
            if (str.length() - previ <= delimiter.length() || " ".equals(instruction = str.substring(previ, str.length()).trim()) || instruction == null || instruction.isEmpty()) continue;
            if (keepDelimiter) {
                instruction = instruction + delimiter;
            }
            tokens.add(instruction);
        }
        return tokens;
    }
}

