/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.dbbuilder;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.silverpeas.applicationbuilder.AppBuilderException;
import org.silverpeas.applicationbuilder.ApplicationBuilderItem;
import org.silverpeas.dbbuilder.DBBuilderItem;
import org.silverpeas.dbbuilder.VersionTag;
import org.silverpeas.util.StringUtil;

public class DBXmlDocument
extends ApplicationBuilderItem {
    public static final String ELT_MODULE = "module";
    public static final String ATT_MODULE_ID = "id";
    public static final String ATT_MODULE_VERSION = "version";
    private XMLOutputter outputter = this.defineOutputter();
    private Document underlyingDocument = null;
    private String outputEncoding = "UTF-8";

    public DBXmlDocument() {
    }

    public DBXmlDocument(String directory, String name) {
        super(directory, name);
    }

    public DBXmlDocument(File directory, String name) {
        super(directory, name);
    }

    public void save() throws AppBuilderException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.getPath());
            this.saveTo(out);
        }
        catch (FileNotFoundException fnfe) {
            try {
                throw new AppBuilderException("Could not save \"" + this.getPath().getAbsolutePath() + '\"', fnfe);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    public void saveTo(OutputStream outStream) throws AppBuilderException {
        try {
            this.getOutputter().output(this.getDocument(), outStream);
        }
        catch (IOException ioe) {
            throw new AppBuilderException("Could not save " + this.getName() + " to output stream", ioe);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load() throws AppBuilderException {
        FileInputStream in = null;
        try {
            if (!this.getPath().exists()) throw new AppBuilderException("Could not find \"" + this.getPath().getAbsolutePath() + '\"');
            in = new FileInputStream(this.getPath());
            this.loadFrom(in);
        }
        catch (MalformedURLException mue) {
            try {
                throw new AppBuilderException("Could not load \"" + this.getPath().getAbsolutePath() + '\"', mue);
                catch (IOException ioe) {
                    throw new AppBuilderException("Could not load \"" + this.getPath().getAbsolutePath() + '\"', ioe);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
    }

    public void loadFrom(InputStream xmlStream) throws AppBuilderException, IOException {
        try {
            SAXBuilder builder = new SAXBuilder(false);
            this.underlyingDocument = builder.build(xmlStream);
        }
        catch (JDOMException jde) {
            throw new AppBuilderException("Could not load \"" + this.getName() + "\" from input stream", jde);
        }
    }

    public void mergeWith(String[] tagsToMerge, DBXmlDocument XmlFile) throws AppBuilderException {
        Element root = this.getDocument().getRootElement();
        root.detach();
        Document documentToBeMerged = (Document)XmlFile.getDocument().clone();
        Element tempRoot = documentToBeMerged.getRootElement();
        for (int iTag = 0; iTag < tagsToMerge.length; ++iTag) {
            for (Object child : tempRoot.getChildren(tagsToMerge[iTag])) {
                if (!(child instanceof Content)) continue;
                Content newElement = (Content)((Content)child).clone();
                newElement.detach();
                root.addContent(newElement);
            }
        }
        this.setDocument(new Document(root));
    }

    public void sort(String[] tagsToSort) throws AppBuilderException {
        Document resultDoc = (Document)this.getDocument().clone();
        Element root = resultDoc.getRootElement();
        ArrayList<List> eltLstLst = new ArrayList<List>(tagsToSort.length);
        for (int iTag = 0; iTag < tagsToSort.length; ++iTag) {
            List eltLst = root.getChildren(tagsToSort[iTag]);
            if (!eltLst.isEmpty() && !root.removeChildren(tagsToSort[iTag])) {
                throw new AppBuilderException("Could not remove \"" + tagsToSort[iTag] + "\" elements from \"" + this.getName() + '\"');
            }
            eltLstLst.add(iTag, eltLst);
        }
        List allEltLst = root.getContent();
        for (int iTag = 0; iTag < tagsToSort.length; ++iTag) {
            if (((List)eltLstLst.get(iTag)).isEmpty() || allEltLst.addAll(allEltLst.size(), (List)eltLstLst.get(iTag))) continue;
            throw new AppBuilderException("Could not add \"" + tagsToSort[iTag] + "\" elements to \"" + this.getName() + '\"');
        }
        this.underlyingDocument = resultDoc;
    }

    public void setOutputEncoding(String encoding) {
        this.outputEncoding = encoding;
        this.outputter = this.defineOutputter();
    }

    private String getOutputEncoding() {
        return this.outputEncoding;
    }

    public Document getDocument() {
        return this.underlyingDocument;
    }

    public void setDocument(Document doc) {
        this.underlyingDocument = doc;
    }

    public long getDocumentSize() throws AppBuilderException {
        if (this.getDocument() != null) {
            String docStr = null;
            docStr = this.getOutputter().outputString(this.getDocument());
            long docSize = docStr.length();
            if (this.getOutputEncoding().startsWith("UTF-16")) {
                docSize *= 2L;
            }
            return docSize;
        }
        return -1L;
    }

    public String[] getAttributeValues(String[] tagsToFind, String attribute) throws AppBuilderException {
        Document resultDoc = (Document)this.getDocument().clone();
        Element root = resultDoc.getRootElement();
        ArrayList<List> eltLstLst = new ArrayList<List>(tagsToFind.length);
        for (int iTag = 0; iTag < tagsToFind.length; ++iTag) {
            List eltLst = root.getChildren(tagsToFind[iTag]);
            if (!eltLst.isEmpty() && !root.removeChildren(tagsToFind[iTag])) {
                throw new AppBuilderException("Could not remove \"" + tagsToFind[iTag] + "\" elements from \"" + this.getName() + '\"');
            }
            eltLstLst.add(iTag, eltLst);
        }
        if (eltLstLst.isEmpty()) {
            return null;
        }
        String[] attributeValues = new String[eltLstLst.size()];
        for (int i = 0; i < eltLstLst.size(); ++i) {
            List eltLst = (List)eltLstLst.get(i);
            for (int j = 0; j < eltLst.size(); ++j) {
                Element e = (Element)eltLst.get(j);
                attributeValues[i] = attribute != null ? e.getAttributeValue(attribute) : e.getText();
            }
        }
        return attributeValues;
    }

    public String[] getTagValues(String tagToFind) {
        HashSet<String> result = new HashSet<String>();
        if (this.getDocument().getRootElement().getName().equals(tagToFind)) {
            result.add(this.getDocument().getRootElement().getText());
        }
        Iterator iChildren = this.getDocument().getRootElement().getChildren(tagToFind).iterator();
        while (iChildren.hasNext()) {
            result.add(((Element)iChildren.next()).getText());
        }
        if (result.isEmpty()) {
            return null;
        }
        return result.toArray(new String[result.size()]);
    }

    public String[] getAttributeValues(String attributeToFind) {
        HashSet<String> result = new HashSet<String>();
        if (this.getDocument().getRootElement().getAttribute(attributeToFind) != null) {
            result.add(this.getDocument().getRootElement().getAttributeValue(attributeToFind));
        }
        for (Element currentElement : this.getDocument().getRootElement().getChildren()) {
            if (currentElement.getAttribute(attributeToFind) == null) continue;
            result.add(currentElement.getAttributeValue(attributeToFind));
        }
        if (result.isEmpty()) {
            return null;
        }
        return result.toArray(new String[result.size()]);
    }

    private XMLOutputter getOutputter() {
        if (this.outputter == null) {
            this.outputter = this.defineOutputter();
        }
        return this.outputter;
    }

    private XMLOutputter defineOutputter() {
        if (!StringUtil.isDefined(this.outputEncoding)) {
            this.outputEncoding = "UTF-8";
        }
        Format format = Format.getPrettyFormat();
        format.setTextMode(Format.TextMode.TRIM);
        format.setEncoding(this.outputEncoding);
        format.setIndent("    ");
        return new XMLOutputter(format);
    }

    public void mergeWith(DBBuilderItem dbbuilderItem, String[] tagsToMerge, List<VersionTag> blocks_to_merge) throws Exception {
        Element root = this.getDocument().getRootElement();
        root.detach();
        if (blocks_to_merge == null) {
            System.out.println(" tagsToMerge Length=" + tagsToMerge.length);
            for (String tag : tagsToMerge) {
                for (Object child : dbbuilderItem.getRoot().getChildren(tag)) {
                    if (!(child instanceof Content)) continue;
                    Content newElement = (Content)((Content)child).clone();
                    newElement.detach();
                    root.addContent(newElement);
                }
            }
        } else {
            for (VersionTag version : blocks_to_merge) {
                Element moduleElement = new Element(ELT_MODULE);
                moduleElement.setAttribute(ATT_MODULE_ID, dbbuilderItem.getModule());
                moduleElement.setAttribute(ATT_MODULE_VERSION, version.getResultingVersion());
                Element myElement = dbbuilderItem.getUniqueBlock(version.getCurrent_or_previous(), version.getVersion());
                for (String aTagsToMerge : tagsToMerge) {
                    for (Object child : myElement.getChildren(aTagsToMerge)) {
                        if (!(child instanceof Content)) continue;
                        Content newElement = (Content)((Content)child).clone();
                        newElement.detach();
                        moduleElement.addContent(newElement);
                    }
                }
                moduleElement.detach();
                root.addContent((Content)moduleElement);
            }
        }
        this.setDocument(new Document(root));
    }
}

