/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.dbbuilder.util;

import java.util.Locale;
import org.silverpeas.dbbuilder.util.Action;
import org.silverpeas.dbbuilder.util.DatabaseType;
import org.silverpeas.util.Console;

public class CommandLineParameters {
    private Console console;
    private static final String USAGE = "DBBuilder usage: DBBuilder <action> -T <Targeted DB Server type> [-v(erbose)] [-s(imulate)]\nwhere <action> == -C(onnection only) | -I(nstall only) | -U(ninstall only) | -O(ptimize only) | -A(ll) | -S(tatus) | -FU(Force Uninstall) <module> \n       <Targeted DB Server type> == MSSQL | ORACLE | POSTGRES | H2\n";
    private Action action = null;
    private DatabaseType dbType = null;
    private boolean verbose = false;
    private boolean simulate = false;
    private String moduleName = null;

    public CommandLineParameters(Console console, String[] commandLineArgs) throws Exception {
        this.console = console;
        this.testParams(commandLineArgs);
    }

    public Action getAction() {
        return this.action;
    }

    public DatabaseType getDbType() {
        return this.dbType;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isSimulate() {
        return this.simulate;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    protected final void testParams(String[] args) throws Exception {
        boolean getDBType = false;
        boolean getModuleName = false;
        this.verbose = false;
        this.simulate = false;
        for (int i = 0; i < args.length; ++i) {
            String curArg = args[i];
            if ("-T".equals(curArg)) {
                if (getDBType || getModuleName) {
                    this.console.printError(USAGE);
                    throw new Exception();
                }
                if (null != this.dbType) {
                    this.console.printError(USAGE);
                    throw new Exception();
                }
                getDBType = true;
                continue;
            }
            if (Action.ACTION_NONE != Action.getAction(curArg)) {
                if (getDBType || getModuleName) {
                    this.console.printError(USAGE);
                    throw new Exception();
                }
                if (null != this.action) {
                    this.console.printError(USAGE);
                    throw new Exception();
                }
                this.action = Action.getAction(curArg);
                if (Action.ACTION_ENFORCE_UNINSTALL != this.action) continue;
                getModuleName = true;
                continue;
            }
            if ("-v".equals(curArg)) {
                if (getDBType || getModuleName) {
                    this.console.printError(USAGE);
                    throw new Exception();
                }
                this.verbose = true;
                continue;
            }
            if ("-s".equals(curArg)) {
                if (getDBType || getModuleName) {
                    this.console.printError(USAGE);
                    throw new Exception();
                }
                this.simulate = true;
                continue;
            }
            if (!getDBType && !getModuleName) {
                this.console.printError(USAGE);
                throw new Exception();
            }
            if (getDBType) {
                this.dbType = DatabaseType.valueOf(curArg.toUpperCase(Locale.FRENCH));
            } else if (getModuleName) {
                this.moduleName = curArg;
            }
            getDBType = false;
            getModuleName = false;
        }
        if (null == this.dbType || null == this.action) {
            this.console.printError(USAGE);
            throw new Exception();
        }
        if (null == this.moduleName && getModuleName) {
            this.console.printError(USAGE);
            throw new Exception();
        }
    }
}

