/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.migration.jcr.service;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.util.Text;
import org.silverpeas.dbbuilder.sql.ConnectionFactory;
import org.silverpeas.migration.jcr.service.AttachmentException;
import org.silverpeas.util.DateUtil;
import org.silverpeas.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConverterUtil {
    private static final Logger logger = LoggerFactory.getLogger(ConverterUtil.class);
    public static final String defaultLanguage = "fr";
    private static final Pattern WysiwygLangPattern = Pattern.compile("[0-9]+wysiwyg_([a-z][a-z])\\.txt");
    private static final Pattern WysiwygBaseNamePattern = Pattern.compile("([0-9]+wysiwyg).*\\.txt");
    public static final String SPACE_TOKEN = "__";
    public static final String PATH_SEPARATOR = "/";
    private static final String OPENING_BRACKET = "[";
    private static final String CLOSING_BRACKET = "]";

    public static String extractLanguage(String filename) {
        Matcher matcher = WysiwygLangPattern.matcher(filename);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public static String extractBaseName(String filename) {
        Matcher matcher = WysiwygBaseNamePattern.matcher(filename);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public static String checkLanguage(String language) {
        String lang = language;
        if (!StringUtil.isDefined(language)) {
            lang = defaultLanguage;
        }
        return lang;
    }

    public static final String encodeJcrPath(String path) {
        return ISO9075.encodePath((String)ConverterUtil.convertToJcrPath(path));
    }

    public static String convertToJcrPath(String name) {
        String coolName = name.replaceAll(" ", SPACE_TOKEN);
        StringBuilder buffer = new StringBuilder(coolName.length() + 10);
        StringTokenizer tokenizer = new StringTokenizer(coolName, PATH_SEPARATOR, true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (PATH_SEPARATOR.equals(token)) {
                buffer.append(token);
                continue;
            }
            buffer.append(Text.escapeIllegalJcrChars((String)token));
        }
        return buffer.toString();
    }

    public static String escapeIllegalJcrChars(String name) {
        return StringUtil.escapeQuote(name).replace(OPENING_BRACKET, " ").replace(CLOSING_BRACKET, " ");
    }

    public static String unescapeQuote(String text) {
        return text.replaceAll("%39", "'");
    }

    public static String convertFromJcrPath(String name) {
        return Text.unescapeIllegalJcrChars((String)name.replaceAll(SPACE_TOKEN, " "));
    }

    public static Date parseDate(String date) throws ParseException {
        return DateUtil.parse(date);
    }

    public static String formatDate(Date date) {
        return DateUtil.formatDate(date);
    }

    public static String formatDate(Calendar calend) {
        return DateUtil.formatDate(calend);
    }

    public static void setTime(Calendar calend, String time) {
        DateUtil.setTime(calend, time);
    }

    public static String formatTime(Date date) {
        return DateUtil.formatTime(date);
    }

    public static String formatTime(Calendar calend) {
        return DateUtil.formatTime(calend);
    }

    public static String formatDateForXpath(Date date) {
        return "xs:dateTime('" + ConverterUtil.getXpathFormattedDate(date) + 'T' + ConverterUtil.getXpathFormattedTime(date) + ConverterUtil.getTimeZone(date) + "')";
    }

    public static String formatCalendarForXpath(Calendar date) {
        return "xs:dateTime('" + ConverterUtil.getXpathFormattedDate(date.getTime()) + 'T' + ConverterUtil.getXpathFormattedTime(date.getTime()) + ConverterUtil.getTimeZone(date.getTime()) + "')";
    }

    protected static String getTimeZone(Date date) {
        SimpleDateFormat xpathTimezoneFormat = new SimpleDateFormat("Z");
        String timeZone = xpathTimezoneFormat.format(date);
        return timeZone.substring(0, timeZone.length() - 2) + ':' + timeZone.substring(timeZone.length() - 2);
    }

    protected static String getXpathFormattedTime(Date date) {
        SimpleDateFormat xpathTimeFormatter = new SimpleDateFormat("HH:mm:ss.SSS");
        return xpathTimeFormatter.format(date);
    }

    protected static String getXpathFormattedDate(Date date) {
        SimpleDateFormat xpathDateFormatter = new SimpleDateFormat("yyyy-MM-dd");
        return xpathDateFormatter.format(date);
    }

    public static int getNextId(String tableName, String idName) {
        Connection connection = null;
        try {
            connection = ConnectionFactory.getConnection();
            connection.setAutoCommit(false);
            int n = ConverterUtil.getMaxId(connection, tableName, idName);
            return n;
        }
        catch (SQLException ex) {
            logger.debug("Impossible de recup\u00e9rer le prochain id", (Throwable)ex);
            throw new AttachmentException("Impossible de recup\u00e9rer le prochain id", ex);
        }
        finally {
            DbUtils.closeQuietly((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int getMaxId(Connection connection, String tableName, String idName) throws SQLException {
        logger.debug("DBUtil.getNextId with dBName = " + tableName);
        try {
            int max = ConverterUtil.updateMaxFromTable(connection, tableName);
            connection.commit();
            return max;
        }
        catch (Exception e) {
            int n;
            logger.info("Impossible d'updater, if faut recuperer la valeur initiale", (Throwable)e);
            int max = ConverterUtil.getMaxFromTable(connection, tableName, idName);
            PreparedStatement createStmt = null;
            try {
                String createStatement = "INSERT INTO UniqueId (maxId, tableName) VALUES (?, ?)";
                createStmt = connection.prepareStatement(createStatement);
                createStmt.setInt(1, max);
                createStmt.setString(2, tableName.toLowerCase(Locale.getDefault()));
                createStmt.executeUpdate();
                connection.commit();
                n = max;
            }
            catch (Exception e2) {
                try {
                    logger.info("Impossible de creer, if faut reessayer l'update", (Throwable)e2);
                    DbUtils.rollback((Connection)connection);
                }
                catch (Throwable throwable) {
                    DbUtils.closeQuietly(createStmt);
                    throw throwable;
                }
                DbUtils.closeQuietly((Statement)createStmt);
            }
            DbUtils.closeQuietly((Statement)createStmt);
            return n;
            max = ConverterUtil.updateMaxFromTable(connection, tableName);
            connection.commit();
            return max;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int updateMaxFromTable(Connection connection, String tableName) throws SQLException {
        block9: {
            String table = tableName.toLowerCase(Locale.ROOT);
            int max = 0;
            PreparedStatement prepStmt = null;
            int count = 0;
            try {
                prepStmt = connection.prepareStatement("UPDATE UniqueId SET maxId = maxId + 1 WHERE tableName = ?");
                prepStmt.setString(1, table);
                count = prepStmt.executeUpdate();
                connection.commit();
            }
            catch (SQLException sqlex) {
                DbUtils.rollback((Connection)connection);
                throw sqlex;
            }
            finally {
                DbUtils.closeQuietly((Statement)prepStmt);
            }
            if (count != 1) break block9;
            PreparedStatement selectStmt = null;
            ResultSet rs = null;
            try {
                selectStmt = connection.prepareStatement("SELECT maxId FROM UniqueId WHERE tableName = ?");
                selectStmt.setString(1, table);
                rs = selectStmt.executeQuery();
                if (!rs.next()) {
                    logger.error("No row for " + table + " found.");
                    throw new RuntimeException("Erreur Interne DBUtil.getNextId()");
                }
                max = rs.getInt(1);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(rs);
                DbUtils.closeQuietly((Statement)selectStmt);
                throw throwable;
            }
            DbUtils.closeQuietly((ResultSet)rs);
            DbUtils.closeQuietly((Statement)selectStmt);
            return max;
        }
        throw new SQLException("Update impossible : Ligne non existante");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getMaxFromTable(Connection con, String tableName, String idName) throws SQLException {
        int n;
        if (!StringUtil.isDefined(tableName) || !StringUtil.isDefined(idName)) {
            return 1;
        }
        Statement prepStmt = con.createStatement();
        ResultSet rs = null;
        try {
            int maxFromTable = 0;
            String nextPKStatement = "SELECT MAX(" + idName + ") " + "FROM " + tableName;
            rs = prepStmt.executeQuery(nextPKStatement);
            if (rs.next()) {
                maxFromTable = rs.getInt(1);
            }
            n = maxFromTable + 1;
            DbUtils.closeQuietly((ResultSet)rs);
        }
        catch (SQLException ex) {
            DbUtils.rollback((Connection)con);
            int n2 = 1;
            return n2;
        }
        finally {
            DbUtils.closeQuietly(rs);
            DbUtils.closeQuietly((Statement)prepStmt);
        }
        DbUtils.closeQuietly((Statement)prepStmt);
        return n;
    }

    public static void deleteFile(File file) {
        File parent = file.getParentFile();
        FileUtils.deleteQuietly((File)file);
        if (parent.isDirectory() && parent.list().length == 0) {
            FileUtils.deleteQuietly((File)parent);
        }
    }

    private ConverterUtil() {
    }
}

