/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.migration.jcr.service;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.InvalidNodeTypeDefinitionException;
import javax.jcr.nodetype.NodeTypeExistsException;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.commons.cnd.CndImporter;
import org.apache.jackrabbit.commons.cnd.ParseException;
import org.silverpeas.util.ConfigurationHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryManager {
    private static final Logger logger = LoggerFactory.getLogger(RepositoryManager.class);
    private JackrabbitRepository repository;

    public RepositoryManager() {
        try {
            String conf = ConfigurationHolder.getHome() + File.separatorChar + "setup" + File.separatorChar + "jackrabbit" + File.separatorChar + "repository.xml";
            String repositoryHome = ConfigurationHolder.getDataHome() + File.separatorChar + "jackrabbit";
            this.initRepository(repositoryHome, conf);
        }
        catch (RepositoryException ex) {
            logger.error("Error during JCR repository initalisation", (Throwable)ex);
        }
        catch (IOException ex) {
            logger.error("Error during JCR repository initalisation", (Throwable)ex);
        }
    }

    public RepositoryManager(String repositoryHome, String repositoryXml) {
        try {
            this.initRepository(repositoryHome, repositoryXml);
        }
        catch (RepositoryException ex) {
            logger.error("Error during JCR repository initalisation", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRepository(String repositoryHome, String conf) throws RepositoryException {
        HashMap<String, String> parameters = new HashMap<String, String>(2);
        parameters.put("org.apache.jackrabbit.repository.home", repositoryHome);
        parameters.put("org.apache.jackrabbit.repository.conf", conf);
        this.repository = (JackrabbitRepository)JcrUtils.getRepository(parameters);
        InputStreamReader reader = new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("silverpeas-jcr.txt"), Charsets.UTF_8);
        try {
            Session session = this.getSession();
            CndImporter.registerNodeTypes((Reader)reader, (Session)session);
            session.save();
            session.logout();
        }
        catch (InvalidNodeTypeDefinitionException ex) {
            logger.error("Error during JCR repository initalisation", (Throwable)ex);
        }
        catch (NodeTypeExistsException ex) {
            logger.error("Error during JCR repository initalisation", (Throwable)ex);
        }
        catch (UnsupportedRepositoryOperationException ex) {
            logger.error("Error during JCR repository initalisation", (Throwable)ex);
        }
        catch (ParseException ex) {
            logger.error("Error during JCR repository initalisation", (Throwable)ex);
        }
        catch (IOException ex) {
            logger.error("Error during JCR repository initalisation", (Throwable)ex);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    public Session getSession() throws RepositoryException {
        return this.repository.login((Credentials)new SimpleCredentials("admin", "admin".toCharArray()));
    }

    public void logout(Session session) {
        if (session != null) {
            session.logout();
        }
    }

    public void shutdown() {
        this.repository.shutdown();
    }
}

