/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.migration.jcr.service;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.IOUtils;
import org.silverpeas.migration.jcr.service.AttachmentException;
import org.silverpeas.migration.jcr.service.RepositoryManager;
import org.silverpeas.migration.jcr.service.model.SimpleDocument;
import org.silverpeas.migration.jcr.service.model.SimpleDocumentPK;
import org.silverpeas.migration.jcr.service.repository.DocumentRepository;
import org.silverpeas.util.StringUtil;

public class SimpleDocumentService {
    private final DocumentRepository repository;
    private final RepositoryManager repositoryManager;

    public SimpleDocumentService(String repositoryHome, String repositoryXml) throws AttachmentException {
        this.repositoryManager = new RepositoryManager(repositoryHome, repositoryXml);
        this.repository = new DocumentRepository(this.repositoryManager);
    }

    public SimpleDocumentService() throws AttachmentException {
        this.repositoryManager = new RepositoryManager();
        this.repository = new DocumentRepository(this.repositoryManager);
    }

    public DocumentRepository getDocumentRepository() {
        return this.repository;
    }

    public RepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }

    public SimpleDocument searchDocumentById(SimpleDocumentPK primaryKey, String lang) {
        Session session = null;
        try {
            session = this.repositoryManager.getSession();
            if (StringUtil.isDefined(primaryKey.getId())) {
                SimpleDocument simpleDocument = this.repository.findDocumentById(session, primaryKey, lang);
                return simpleDocument;
            }
            SimpleDocument doc = this.repository.findDocumentByOldSilverpeasId(session, primaryKey.getComponentName(), primaryKey.getOldSilverpeasId(), false, lang);
            if (doc == null) {
                doc = this.repository.findDocumentByOldSilverpeasId(session, primaryKey.getComponentName(), primaryKey.getOldSilverpeasId(), true, lang);
            }
            SimpleDocument simpleDocument = doc;
            return simpleDocument;
        }
        catch (RepositoryException ex) {
            throw new AttachmentException(ex);
        }
        finally {
            this.repositoryManager.logout(session);
        }
    }

    public void updateAttachment(SimpleDocument document, File content) {
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(content));
            this.updateAttachment(document, in);
        }
        catch (FileNotFoundException ex) {
            try {
                throw new AttachmentException(ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
    }

    public void updateAttachment(SimpleDocument document, InputStream in) {
        Session session = null;
        try {
            session = this.repositoryManager.getSession();
            String owner = document.getEditedBy();
            if (!StringUtil.isDefined(owner)) {
                owner = document.getUpdatedBy();
            }
            boolean checkinRequired = this.repository.lock(session, document, owner);
            this.repository.updateDocument(session, document);
            this.repository.addContent(session, document.getPk(), document.getAttachment());
            this.repository.fillNodeName(session, document);
            SimpleDocument finalDocument = document;
            if (checkinRequired) {
                finalDocument = this.repository.unlock(session, document, false);
            }
            this.repository.storeContent(finalDocument, in);
            this.repository.duplicateContent(document, finalDocument);
            session.save();
        }
        catch (RepositoryException ex) {
            throw new AttachmentException(ex);
        }
        catch (IOException ex) {
            throw new AttachmentException(ex);
        }
        finally {
            this.repositoryManager.logout(session);
        }
    }

    public SimpleDocument mergeDocument(SimpleDocument document, SimpleDocument merge) {
        File content = new File(merge.getAttachmentPath());
        if (!content.exists() || !content.isFile()) {
            merge.setLanguage("fr");
            content = new File(merge.getAttachmentPath());
        }
        if (content.exists() && content.isFile()) {
            this.updateAttachment(document, content);
            this.deleteAttachment(merge);
        }
        return this.searchDocumentById(document.getPk(), document.getLanguage());
    }

    public List<String> listBasenames(String instanceId) {
        Session session = null;
        try {
            session = this.repositoryManager.getSession();
            ArrayList<String> arrayList = new ArrayList<String>(this.repository.listWysiwygFileNames(session, instanceId));
            return arrayList;
        }
        catch (RepositoryException ex) {
            throw new AttachmentException(ex);
        }
        finally {
            this.repositoryManager.logout(session);
        }
    }

    public List<SimpleDocument> listWysiwygForBasename(String basename, String instanceId) {
        Session session = null;
        try {
            session = this.repositoryManager.getSession();
            List<SimpleDocument> list = this.repository.listWysiwygAttachmentsByBasename(session, instanceId, basename);
            return list;
        }
        catch (RepositoryException ex) {
            throw new AttachmentException(ex);
        }
        finally {
            this.repositoryManager.logout(session);
        }
    }

    public List<String> listComponentIdsWithWysiwyg() {
        Session session = null;
        try {
            session = this.repositoryManager.getSession();
            List<String> list = this.repository.listComponentsWithWysiwyg(session);
            return list;
        }
        catch (RepositoryException ex) {
            throw new AttachmentException(ex);
        }
        finally {
            this.repositoryManager.logout(session);
        }
    }

    public void shutdown() {
        this.repositoryManager.shutdown();
    }

    public void deleteAttachment(SimpleDocument document) {
        Session session = null;
        try {
            session = this.repositoryManager.getSession();
            this.repository.fillNodeName(session, document);
            this.repository.deleteDocument(session, document.getPk());
            session.save();
        }
        catch (RepositoryException ex) {
            throw new AttachmentException(ex);
        }
        finally {
            this.repositoryManager.logout(session);
        }
    }
}

