/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.migration.jcr.service.model;

import java.util.regex.Pattern;
import org.silverpeas.util.StringUtil;

public enum DocumentType {
    attachment("attachments"),
    form("forms"),
    wysiwyg("wysiwyg"),
    image("images"),
    video("video"),
    node("node");

    private static final Pattern nodePattern;
    private static final Pattern wysiwygImagePattern;
    private static final Pattern externalWysiwygImagePattern;
    private String folderName;

    private DocumentType(String folder) {
        this.folderName = folder;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public static DocumentType fromFolderName(String folder) {
        if (DocumentType.attachment.folderName.equals(folder)) {
            return attachment;
        }
        if (DocumentType.form.folderName.equals(folder)) {
            return form;
        }
        if (DocumentType.wysiwyg.folderName.equals(folder)) {
            return wysiwyg;
        }
        if (DocumentType.image.folderName.equals(folder)) {
            return image;
        }
        if (DocumentType.video.folderName.equals(folder)) {
            return video;
        }
        return attachment;
    }

    public static DocumentType fromOldContext(String instanceId, String oldContext) {
        if (StringUtil.isDefined(oldContext)) {
            if ("Images".equalsIgnoreCase(oldContext)) {
                if (instanceId.startsWith("classifieds")) {
                    return form;
                }
                return attachment;
            }
            if ("wysiwyg".equalsIgnoreCase(oldContext)) {
                return wysiwyg;
            }
            if ("XMLFormImages".equalsIgnoreCase(oldContext)) {
                return form;
            }
            if ("XMLFormVideo".equalsIgnoreCase(oldContext)) {
                return form;
            }
            if (wysiwygImagePattern.matcher(oldContext).matches()) {
                return image;
            }
            if (nodePattern.matcher(oldContext).matches()) {
                return node;
            }
            if (externalWysiwygImagePattern.matcher(oldContext).matches()) {
                return image;
            }
        }
        return attachment;
    }

    static {
        nodePattern = Pattern.compile("Node_\\d+Images");
        wysiwygImagePattern = Pattern.compile("\\d+Images");
        externalWysiwygImagePattern = Pattern.compile("[a-zA-Z]+\\d+Images");
    }
}

