/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.migration.jcr.service.model;

import java.io.File;
import java.io.Serializable;
import java.util.Date;
import org.silverpeas.migration.jcr.service.ConverterUtil;

public class SimpleAttachment
implements Serializable {
    private static final long serialVersionUID = -6153003608158238503L;
    private String filename;
    private String language = "fr";
    private String title;
    private String description;
    private long size;
    private String contentType;
    private String createdBy;
    private Date created;
    private String updatedBy;
    private Date updated;
    private String xmlFormId;
    private File file;

    public SimpleAttachment(String filename, String language, String title, String description, long size, String contentType, String createdBy, Date created, String xmlFormId) {
        this.filename = filename;
        this.language = ConverterUtil.checkLanguage(language);
        this.title = title;
        this.description = description;
        this.size = size;
        this.contentType = contentType;
        this.createdBy = createdBy;
        this.setCreated(created);
        this.xmlFormId = xmlFormId;
    }

    public SimpleAttachment() {
    }

    public String getNodeName() {
        return "file_" + this.getLanguage();
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = ConverterUtil.checkLanguage(language);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Date getCreated() {
        if (this.created == null) {
            return null;
        }
        return new Date(this.created.getTime());
    }

    public final void setCreated(Date creationDate) {
        this.created = creationDate == null ? null : new Date(creationDate.getTime());
    }

    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public Date getUpdated() {
        if (this.updated == null) {
            return null;
        }
        return new Date(this.updated.getTime());
    }

    public final void setUpdated(Date updateDate) {
        this.updated = updateDate == null ? null : new Date(updateDate.getTime());
    }

    public String getXmlFormId() {
        return this.xmlFormId;
    }

    public void setXmlFormId(String xmlFormId) {
        this.xmlFormId = xmlFormId;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public int hashCode() {
        int hash = 7;
        hash = 61 * hash + (this.filename != null ? this.filename.hashCode() : 0);
        hash = 61 * hash + (this.language != null ? this.language.hashCode() : 0);
        hash = 61 * hash + (this.title != null ? this.title.hashCode() : 0);
        hash = 61 * hash + (this.description != null ? this.description.hashCode() : 0);
        hash = 61 * hash + (int)(this.size ^ this.size >>> 32);
        hash = 61 * hash + (this.contentType != null ? this.contentType.hashCode() : 0);
        hash = 61 * hash + (this.createdBy != null ? this.createdBy.hashCode() : 0);
        hash = 61 * hash + (this.created != null ? this.created.hashCode() : 0);
        hash = 61 * hash + (this.updatedBy != null ? this.updatedBy.hashCode() : 0);
        hash = 61 * hash + (this.updated != null ? this.updated.hashCode() : 0);
        hash = 61 * hash + (this.xmlFormId != null ? this.xmlFormId.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleAttachment other = (SimpleAttachment)obj;
        if (this.filename == null ? other.filename != null : !this.filename.equals(other.filename)) {
            return false;
        }
        if (this.language == null ? other.language != null : !this.language.equals(other.language)) {
            return false;
        }
        if (this.title == null ? other.title != null : !this.title.equals(other.title)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.size != other.size) {
            return false;
        }
        if (this.contentType == null ? other.contentType != null : !this.contentType.equals(other.contentType)) {
            return false;
        }
        if (this.createdBy == null ? other.createdBy != null : !this.createdBy.equals(other.createdBy)) {
            return false;
        }
        if (!(this.created == other.created || this.created != null && this.created.equals(other.created))) {
            return false;
        }
        if (this.updatedBy == null ? other.updatedBy != null : !this.updatedBy.equals(other.updatedBy)) {
            return false;
        }
        if (!(this.updated == other.updated || this.updated != null && this.updated.equals(other.updated))) {
            return false;
        }
        return !(this.xmlFormId == null ? other.xmlFormId != null : !this.xmlFormId.equals(other.xmlFormId));
    }

    public String toString() {
        return "SimpleAttachment{filename=" + this.filename + ", language=" + this.language + ", title=" + this.title + ", description=" + this.description + ", size=" + this.size + ", contentType=" + this.contentType + ", createdBy=" + this.createdBy + ", created=" + this.created + ", updatedBy=" + this.updatedBy + ", updated=" + this.updated + ", xmlFormId=" + this.xmlFormId + '}';
    }
}

