/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.migration.jcr.service.repository;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.qom.ChildNode;
import javax.jcr.query.qom.Comparison;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DescendantNode;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.Ordering;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.QueryObjectModelFactory;
import javax.jcr.query.qom.Selector;
import javax.jcr.query.qom.Source;
import javax.jcr.query.qom.StaticOperand;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import javax.jcr.version.VersionManager;
import org.apache.commons.io.FileUtils;
import org.silverpeas.migration.jcr.service.ConverterUtil;
import org.silverpeas.migration.jcr.service.RepositoryManager;
import org.silverpeas.migration.jcr.service.model.DocumentType;
import org.silverpeas.migration.jcr.service.model.SimpleAttachment;
import org.silverpeas.migration.jcr.service.model.SimpleDocument;
import org.silverpeas.migration.jcr.service.model.SimpleDocumentPK;
import org.silverpeas.migration.jcr.service.repository.DocumentConverter;
import org.silverpeas.util.Console;
import org.silverpeas.util.StringUtil;
import org.silverpeas.util.file.FileUtil;

public class DocumentRepository {
    private static final Console console = new Console(DocumentConverter.class);
    private final RepositoryManager repositoryManager;
    private static final Pattern COMPONENTNAME_PATTERN = Pattern.compile("[a-zA-Z]+\\d+");
    private static final String SIMPLE_ATTACHMENT_ALIAS = "SimpleAttachments";
    private static final String SIMPLE_DOCUMENT_ALIAS = "SimpleDocuments";
    final DocumentConverter converter = new DocumentConverter();

    public DocumentRepository(RepositoryManager repositoryManager) {
        this.repositoryManager = repositoryManager;
    }

    public Node prepareComponentAttachments(Session session, String instanceId, String folder) throws RepositoryException {
        Node targetInstanceNode = this.converter.getFolder(session.getRootNode(), instanceId);
        return this.converter.getFolder(targetInstanceNode, folder);
    }

    public SimpleDocumentPK createDocument(Session session, SimpleDocument document) throws RepositoryException {
        SimpleDocument last = this.findLast(session, document.getInstanceId(), document.getForeignId());
        if (null != last && 0 >= document.getOrder()) {
            document.setOrder(last.getOrder() + 1);
        }
        Node docsNode = this.prepareComponentAttachments(session, document.getInstanceId(), document.getFolder());
        Node documentNode = docsNode.addNode(document.computeNodeName(), "slv:simpleDocument");
        this.converter.fillNode(document, documentNode);
        if (document.isVersioned()) {
            documentNode.addMixin("{http://www.jcp.org/jcr/mix/1.0}simpleVersionable");
        }
        document.setId(documentNode.getIdentifier());
        document.setOldSilverpeasId(documentNode.getProperty("slv:oldSilverpeasId").getLong());
        return document.getPk();
    }

    public void updateDocument(Session session, SimpleDocument document) throws RepositoryException, IOException {
        Node documentNode = session.getNodeByIdentifier(document.getPk().getId());
        if (StringUtil.isDefined(document.getEditedBy())) {
            document.setUpdatedBy(document.getEditedBy());
        }
        this.converter.fillNode(document, documentNode);
    }

    public void deleteDocument(Session session, SimpleDocumentPK documentPk) throws RepositoryException {
        try {
            Node documentNode = session.getNodeByIdentifier(documentPk.getId());
            this.deleteContent(documentNode, documentPk.getInstanceId());
            this.deleteDocumentNode(documentNode);
        }
        catch (ItemNotFoundException infex) {
            console.printError("DocumentRepository.deleteDocument()", (Exception)((Object)infex));
        }
    }

    public SimpleDocument findDocumentById(Session session, SimpleDocumentPK documentPk, String lang) throws RepositoryException {
        try {
            Node documentNode = session.getNodeByIdentifier(documentPk.getId());
            return this.converter.convertNode(documentNode, lang);
        }
        catch (ItemNotFoundException infex) {
            console.printError("DocumentRepository.findDocumentById()", (Exception)((Object)infex));
            return null;
        }
    }

    public SimpleDocument findDocumentByOldSilverpeasId(Session session, String instanceId, long oldSilverpeasId, boolean versioned, String lang) throws RepositoryException {
        Comparison versionedComparison;
        Comparison oldSilverpeasIdComparison;
        DescendantNode descendantdNodeConstraint;
        Selector source;
        QueryManager manager = session.getWorkspace().getQueryManager();
        QueryObjectModelFactory factory = manager.getQOMFactory();
        QueryObjectModel query = factory.createQuery((Source)(source = factory.selector("slv:simpleDocument", SIMPLE_DOCUMENT_ALIAS)), (Constraint)factory.and((Constraint)(descendantdNodeConstraint = factory.descendantNode(SIMPLE_DOCUMENT_ALIAS, session.getRootNode().getPath() + instanceId)), (Constraint)factory.and((Constraint)(oldSilverpeasIdComparison = factory.comparison((DynamicOperand)factory.propertyValue(SIMPLE_DOCUMENT_ALIAS, "slv:oldSilverpeasId"), "jcr.operator.equal.to", (StaticOperand)factory.literal(session.getValueFactory().createValue(oldSilverpeasId)))), (Constraint)(versionedComparison = factory.comparison((DynamicOperand)factory.propertyValue(SIMPLE_DOCUMENT_ALIAS, "slv:versioned"), "jcr.operator.equal.to", (StaticOperand)factory.literal(session.getValueFactory().createValue(versioned)))))), null, null);
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        if (iter.hasNext()) {
            return this.converter.convertNode(iter.nextNode(), lang);
        }
        return null;
    }

    public void addContent(Session session, SimpleDocumentPK documentPk, SimpleAttachment attachment) throws RepositoryException {
        Node documentNode = session.getNodeByIdentifier(documentPk.getId());
        if (this.converter.isVersioned(documentNode) && !documentNode.isCheckedOut()) {
            String owner = attachment.getUpdatedBy();
            if (!StringUtil.isDefined(owner)) {
                owner = attachment.getCreatedBy();
            }
            this.checkoutNode(documentNode, owner);
        }
        this.converter.addAttachment(documentNode, attachment);
    }

    private void deleteDocumentNode(Node documentNode) throws RepositoryException {
        if (null != documentNode) {
            if (this.converter.isVersioned(documentNode)) {
                this.removeHistory(documentNode);
            }
            documentNode.remove();
        }
    }

    private SimpleDocument findLast(Session session, String instanceId, String foreignId) throws RepositoryException {
        NodeIterator iter = this.selectDocumentsByForeignIdAndType(session, instanceId, foreignId, DocumentType.attachment);
        while (iter.hasNext()) {
            Node node = iter.nextNode();
            if (iter.hasNext()) continue;
            return this.converter.convertNode(node, "fr");
        }
        return null;
    }

    private NodeIterator selectDocumentsByForeignIdAndType(Session session, String instanceId, String foreignId, DocumentType type) throws RepositoryException {
        QueryManager manager = session.getWorkspace().getQueryManager();
        QueryObjectModelFactory factory = manager.getQOMFactory();
        Selector source = factory.selector("slv:simpleDocument", SIMPLE_DOCUMENT_ALIAS);
        ChildNode childNodeConstraint = factory.childNode(SIMPLE_DOCUMENT_ALIAS, session.getRootNode().getPath() + instanceId + '/' + type.getFolderName());
        Comparison foreignIdComparison = factory.comparison((DynamicOperand)factory.propertyValue(SIMPLE_DOCUMENT_ALIAS, "slv:foreignKey"), "jcr.operator.equal.to", (StaticOperand)factory.literal(session.getValueFactory().createValue(foreignId)));
        Ordering order = factory.ascending((DynamicOperand)factory.propertyValue(SIMPLE_DOCUMENT_ALIAS, "slv:order"));
        QueryObjectModel query = factory.createQuery((Source)source, (Constraint)factory.and((Constraint)childNodeConstraint, (Constraint)foreignIdComparison), new Ordering[]{order}, null);
        QueryResult result = query.execute();
        return result.getNodes();
    }

    public boolean lock(Session session, SimpleDocument document, String owner) throws RepositoryException {
        if (document.isVersioned()) {
            Node documentNode = session.getNodeByIdentifier(document.getId());
            if (!documentNode.isCheckedOut()) {
                this.checkoutNode(documentNode, owner);
            }
            return true;
        }
        return false;
    }

    public Node unlock(Session session, SimpleDocument document) throws RepositoryException {
        Node documentNode = session.getNodeByIdentifier(document.getId());
        if (document.isVersioned() && documentNode.isCheckedOut()) {
            this.converter.fillNode(document, documentNode);
            VersionManager versionManager = documentNode.getSession().getWorkspace().getVersionManager();
            String versionLabel = this.converter.updateVersion(documentNode, document.getLanguage(), document.isPublic());
            session.save();
            Version lastVersion = versionManager.checkin(documentNode.getPath());
            lastVersion.getContainingHistory().addVersionLabel(lastVersion.getName(), versionLabel, false);
            Node versionNode = this.converter.getCurrentNodeForVersion(lastVersion);
            document.setMajorVersion(this.converter.getIntProperty(documentNode, "slv:major"));
            document.setMinorVersion(this.converter.getIntProperty(documentNode, "slv:minor"));
            return versionNode;
        }
        if (!document.isVersioned()) {
            this.converter.fillNode(document, documentNode);
            session.save();
            return documentNode;
        }
        return null;
    }

    public SimpleDocument unlock(Session session, SimpleDocument document, boolean restore) throws RepositoryException {
        Node documentNode;
        try {
            documentNode = session.getNodeByIdentifier(document.getId());
        }
        catch (ItemNotFoundException ex) {
            return document;
        }
        if (document.isVersioned() && documentNode.isCheckedOut()) {
            if (restore) {
                VersionIterator iter = session.getWorkspace().getVersionManager().getVersionHistory(document.getFullJcrPath()).getAllVersions();
                Version lastVersion = null;
                while (iter.hasNext()) {
                    lastVersion = iter.nextVersion();
                }
                if (null != lastVersion) {
                    session.getWorkspace().getVersionManager().restore(lastVersion, true);
                    return this.converter.convertNode(lastVersion.getFrozenNode(), document.getLanguage());
                }
            }
            this.converter.fillNode(document, documentNode);
            return this.checkinNode(documentNode, document.getLanguage(), document.isPublic());
        }
        if (!document.isVersioned()) {
            this.converter.fillNode(document, documentNode);
            this.converter.releaseDocumentNode(documentNode, document.getLanguage());
            return this.converter.convertNode(documentNode, document.getLanguage());
        }
        document.release();
        return document;
    }

    private void checkoutNode(Node node, String owner) throws RepositoryException {
        node.getSession().getWorkspace().getVersionManager().checkout(node.getPath());
        this.converter.addStringProperty(node, "slv:owner", owner);
    }

    private SimpleDocument checkinNode(Node documentNode, String lang, boolean isMajor) throws RepositoryException {
        VersionManager versionManager = documentNode.getSession().getWorkspace().getVersionManager();
        String versionLabel = this.converter.updateVersion(documentNode, lang, isMajor);
        documentNode.getSession().save();
        Version lastVersion = versionManager.checkin(documentNode.getPath());
        lastVersion.getContainingHistory().addVersionLabel(lastVersion.getName(), versionLabel, false);
        SimpleDocument doc = this.converter.convertNode(documentNode, lang);
        return doc;
    }

    private void removeHistory(Node documentNode) throws RepositoryException {
        VersionHistory history = documentNode.getSession().getWorkspace().getVersionManager().getVersionHistory(documentNode.getPath());
        Version root = history.getRootVersion();
        VersionIterator versions = history.getAllVersions();
        while (versions.hasNext()) {
            Version version = versions.nextVersion();
            if (version.isSame((Item)root)) continue;
            history.removeVersion(version.getName());
        }
    }

    public void fillNodeName(Session session, SimpleDocument document) throws RepositoryException {
        Node documentNode = session.getNodeByIdentifier(document.getId());
        if (!StringUtil.isDefined(document.getNodeName())) {
            document.setNodeName(documentNode.getName());
        }
    }

    public long storeContent(SimpleDocument document, InputStream in) throws RepositoryException, IOException {
        File file = new File(document.getAttachmentPath());
        console.printTrace("Storing file for document in " + document.getAttachmentPath());
        FileUtils.copyInputStreamToFile((InputStream)in, (File)file);
        return file.length();
    }

    public void duplicateContent(SimpleDocument origin, SimpleDocument document) throws IOException, RepositoryException {
        String originDir = origin.getDirectoryPath(null);
        String targetDir = document.getDirectoryPath(null);
        targetDir = targetDir.replace('/', File.separatorChar);
        File target = new File(targetDir).getParentFile();
        File source = new File(originDir).getParentFile();
        if (!source.exists() || !source.isDirectory() || source.listFiles() == null) {
            return;
        }
        if (!target.exists()) {
            target.mkdir();
        }
        for (File langDir : source.listFiles()) {
            File targetLangDir = new File(target, langDir.getName());
            if (targetLangDir.exists()) continue;
            FileUtils.copyDirectory((File)langDir, (File)targetLangDir);
        }
    }

    public void deleteContent(Node documentNode, String instanceId) throws RepositoryException {
        String directory = FileUtil.getAbsolutePath(instanceId) + documentNode.getName();
        File documentDirectory = new File(directory = directory.replace('/', File.separatorChar));
        if (documentDirectory.exists() && documentDirectory.isDirectory()) {
            FileUtils.deleteQuietly((File)documentDirectory);
        }
    }

    public List<String> listComponentsWithWysiwyg(Session session) throws RepositoryException {
        ArrayList<String> componentIds = new ArrayList<String>(5000);
        NodeIterator iter = session.getRootNode().getNodes();
        while (iter.hasNext()) {
            Node childNode = iter.nextNode();
            if (!COMPONENTNAME_PATTERN.matcher(childNode.getName()).matches() || !childNode.hasNode(DocumentType.wysiwyg.getFolderName())) continue;
            componentIds.add(childNode.getName());
        }
        return componentIds;
    }

    public Set<String> listWysiwygFileNames(Session session, String instanceId) throws RepositoryException {
        HashSet<String> baseFileNames = new HashSet<String>(5000);
        if (session.getRootNode().hasNode(instanceId) && session.getRootNode().getNode(instanceId).hasNode(DocumentType.wysiwyg.getFolderName())) {
            NodeIterator iter = session.getRootNode().getNode(instanceId).getNode(DocumentType.wysiwyg.getFolderName()).getNodes();
            while (iter.hasNext()) {
                Node documentNode = iter.nextNode();
                NodeIterator attachmentsIter = documentNode.getNodes();
                while (attachmentsIter.hasNext()) {
                    Node attachmentNode = attachmentsIter.nextNode();
                    String basename = ConverterUtil.extractBaseName(attachmentNode.getProperty("slv:name").getString());
                    if (!StringUtil.isDefined(basename)) continue;
                    baseFileNames.add(basename);
                }
            }
        }
        return baseFileNames;
    }

    public List<SimpleDocument> listWysiwygAttachmentsByBasename(Session session, String instanceId, String baseName) throws RepositoryException {
        NodeIterator iter = this.selectWysiwygAttachmentsByBasename(session, instanceId, baseName);
        ArrayList<SimpleDocument> result = new ArrayList<SimpleDocument>((int)iter.getSize());
        while (iter.hasNext()) {
            Node attachmentNode = iter.nextNode();
            String language = attachmentNode.getProperty("{http://www.jcp.org/jcr/1.0}language").getString();
            result.add(this.converter.convertNode(attachmentNode.getParent(), language));
        }
        return result;
    }

    protected NodeIterator selectWysiwygAttachmentsByBasename(Session session, String instanceId, String baseName) throws RepositoryException {
        QueryManager manager = session.getWorkspace().getQueryManager();
        QueryObjectModelFactory factory = manager.getQOMFactory();
        Selector source = factory.selector("slv:simpleAttachment", SIMPLE_ATTACHMENT_ALIAS);
        DescendantNode descendantdNodeConstraint = factory.descendantNode(SIMPLE_ATTACHMENT_ALIAS, session.getRootNode().getPath() + instanceId);
        Comparison baseNameLike = factory.comparison((DynamicOperand)factory.propertyValue(SIMPLE_ATTACHMENT_ALIAS, "slv:name"), "jcr.operator.like", (StaticOperand)factory.literal(session.getValueFactory().createValue(baseName + "%.txt")));
        Ordering order = factory.ascending((DynamicOperand)factory.propertyValue(SIMPLE_ATTACHMENT_ALIAS, "slv:name"));
        QueryObjectModel query = factory.createQuery((Source)source, (Constraint)factory.and((Constraint)descendantdNodeConstraint, (Constraint)baseNameLike), new Ordering[]{order}, null);
        QueryResult result = query.execute();
        return result.getNodes();
    }
}

