/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.migration.jcr.version;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.silverpeas.dbbuilder.sql.ConnectionFactory;
import org.silverpeas.migration.jcr.service.AttachmentException;
import org.silverpeas.migration.jcr.service.ConverterUtil;
import org.silverpeas.migration.jcr.service.RepositoryManager;
import org.silverpeas.migration.jcr.service.model.HistorisedDocument;
import org.silverpeas.migration.jcr.service.model.SimpleAttachment;
import org.silverpeas.migration.jcr.service.model.SimpleDocument;
import org.silverpeas.migration.jcr.service.model.SimpleDocumentPK;
import org.silverpeas.migration.jcr.service.repository.DocumentConverter;
import org.silverpeas.migration.jcr.service.repository.DocumentRepository;
import org.silverpeas.migration.jcr.version.model.OldDocumentMetadata;
import org.silverpeas.migration.jcr.version.model.Version;
import org.silverpeas.util.Console;
import org.silverpeas.util.DateUtil;
import org.silverpeas.util.StringUtil;

class VersionedDocumentMigration
implements Callable<Long> {
    public static final String SELECT_DOCUMENTS = "SELECT documentid, documentname, documentdescription, documentstatus, documentownerid, documentcheckoutdate, documentinfo, foreignid, instanceid, typeworklist, currentworklistorder, alertdate, expirydate, documentordernum FROM sb_version_document WHERE instanceid = ? ORDER BY foreignid, documentordernum";
    public static final String SELECT_DOCUMENT_VERSION = "SELECT versionid, documentid, versionmajornumber, versionminornumber, versionauthorid, versioncreationdate, versioncomments, versiontype,  versionstatus, versionphysicalname, versionlogicalname, versionmimetype, versionsize, instanceid, xmlform FROM sb_version_version WHERE documentid = ? ORDER BY versionmajornumber, versionminornumber";
    public static final String DELETE_DOCUMENT_VERSIONS = "DELETE FROM sb_version_version WHERE documentid = ?";
    public static final String DELETE_DOCUMENT = "DELETE FROM sb_version_document WHERE documentid = ?";
    private final String componentId;
    private final RepositoryManager repositoryManager;
    private final DocumentRepository documentRepository;
    private final Console console;
    private static final DocumentConverter converter = new DocumentConverter();

    VersionedDocumentMigration(String instanceId, RepositoryManager repositoryManager, Console console) {
        this.componentId = instanceId;
        this.repositoryManager = repositoryManager;
        this.documentRepository = new DocumentRepository(repositoryManager);
        this.console = console;
    }

    protected long migrateComponent() throws Exception {
        long processStart = System.currentTimeMillis();
        this.console.printMessage("Migrating component " + this.componentId);
        long migratedDocumentCount = 0L;
        Session session = null;
        try {
            List<OldDocumentMetadata> documents = this.listAllDocuments();
            session = this.openJCRSession();
            for (OldDocumentMetadata document : documents) {
                migratedDocumentCount += this.migrateAllDocumentVersions(session, document);
            }
            if (session.hasPendingChanges()) {
                session.save();
            }
            this.cleanAll(documents);
        }
        catch (Exception ex) {
            this.console.printError("Error during the migration of the versioned documents in component " + this.componentId + ": " + ex.getMessage(), ex);
            throw ex;
        }
        finally {
            this.repositoryManager.logout(session);
        }
        long processEnd = System.currentTimeMillis();
        this.console.printMessage("Migrating the component " + this.componentId + " required the migration of " + migratedDocumentCount + " documents in " + (processEnd - processStart) + "ms");
        this.console.printMessage("");
        return migratedDocumentCount;
    }

    private long migrateAllDocumentVersions(Session session, OldDocumentMetadata metadata) throws SQLException, ParseException, IOException {
        this.console.printMessage("=> Creating document for " + metadata.getTitle() + " with " + metadata.getHistory().size() + " versions");
        long processStart = System.currentTimeMillis();
        long migratedDocumentCount = 0L;
        HistorisedDocument document = this.buildHistorisedDocument(metadata);
        this.createDocumentNodeInJCR(session, document);
        this.createDocumentPermalink(document, metadata);
        for (Version version : metadata.getHistory()) {
            this.migrateDocumentVersion(session, document, version, metadata);
            this.createVersionPermalink(this.getDocumentVersionUUID(document, version), version.getId());
            ++migratedDocumentCount;
        }
        long processEnd = System.currentTimeMillis();
        this.console.printMessage("   we have created  " + migratedDocumentCount + " for " + metadata.getTitle() + " with " + metadata.getHistory().size() + " versions in " + (processEnd - processStart) + "ms");
        return migratedDocumentCount;
    }

    private HistorisedDocument buildHistorisedDocument(OldDocumentMetadata metadata) {
        HistorisedDocument document = new HistorisedDocument();
        document.setPK(new SimpleDocumentPK(null, metadata.getInstanceId()));
        document.setAlert(metadata.getAlert());
        document.setForeignId(metadata.getForeignId());
        document.setReservation(metadata.getReservation());
        document.setExpiry(metadata.getExpiry());
        document.setOrder(metadata.getOrder());
        return document;
    }

    private SimpleAttachment buildSimpleAttachment(Version version, OldDocumentMetadata metadata) throws IOException {
        SimpleAttachment attachment = new SimpleAttachment(version.getFileName(), "fr", metadata.getTitle(), metadata.getDescription(), version.getSize(), version.getContentType(), version.getCreatedBy(), version.getCreation(), version.getXmlFormId());
        attachment.setFile(version.getAttachment());
        return attachment;
    }

    private void setVersioningAttributes(HistorisedDocument document, Version version) {
        document.setComment(version.getComment());
        document.setPublicDocument(version.isPublic());
        document.setUpdated(version.getCreation());
        document.setUpdatedBy(version.getCreatedBy());
    }

    private void createDocumentNodeInJCR(Session session, HistorisedDocument document) {
        try {
            this.documentRepository.createDocument(session, document);
            session.save();
        }
        catch (RepositoryException ex) {
            throw new AttachmentException(ex);
        }
    }

    private void createVersionNodeInJCR(Session session, HistorisedDocument document) throws IOException {
        try {
            String owner;
            File previousVersionDirectory = null;
            if (!document.getHistory().isEmpty()) {
                String path = document.getDirectoryPath(document.getLanguage());
                previousVersionDirectory = new File(path).getParentFile();
            }
            if (!StringUtil.isDefined(owner = document.getEditedBy())) {
                owner = document.getUpdatedBy();
            }
            this.documentRepository.lock(session, document, owner);
            Node versionNode = this.documentRepository.unlock(session, document);
            document.getHistory().add(converter.convertNode(versionNode, document.getLanguage()));
            session.save();
            this.copyContent(document);
            if (previousVersionDirectory != null) {
                String path = document.getDirectoryPath(document.getLanguage()).replace('/', File.separatorChar);
                File currentVersionDirectory = new File(path).getParentFile();
                this.duplicateContents(previousVersionDirectory, currentVersionDirectory);
            }
        }
        catch (RepositoryException ex) {
            throw new AttachmentException(ex);
        }
    }

    private void migrateDocumentVersion(Session session, HistorisedDocument document, Version version, OldDocumentMetadata metadata) throws IOException {
        SimpleAttachment attachment = this.buildSimpleAttachment(version, metadata);
        document.setAttachment(attachment);
        this.setVersioningAttributes(document, version);
        if (!StringUtil.isDefined(version.getCreatedBy())) {
            this.console.printWarning("We have a null id for the author of document " + document + " and version " + metadata);
        }
        this.createVersionNodeInJCR(session, document);
    }

    private Session openJCRSession() {
        try {
            return this.repositoryManager.getSession();
        }
        catch (RepositoryException ex) {
            throw new AttachmentException(ex);
        }
    }

    private void copyContent(SimpleDocument document) throws IOException, RepositoryException {
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(document.getAttachment().getFile()));
            this.documentRepository.storeContent(document, in);
        }
        catch (FileNotFoundException ex) {
            try {
                throw new AttachmentException(ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
    }

    private void duplicateContents(File source, File target) throws IOException {
        if (!source.exists() || !source.isDirectory() || source.listFiles() == null) {
            return;
        }
        if (!target.exists()) {
            target.mkdir();
        }
        for (File langDir : source.listFiles()) {
            File targetLangDir = new File(target, langDir.getName());
            if (targetLangDir.exists()) continue;
            FileUtils.copyDirectory((File)langDir, (File)targetLangDir);
        }
    }

    private String getDocumentVersionUUID(HistorisedDocument document, Version version) {
        for (SimpleDocument doc : document.getHistory()) {
            if (doc.getMajorVersion() != version.getMajor() || doc.getMinorVersion() != version.getMinor()) continue;
            return doc.getId();
        }
        return document.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanAll(List<OldDocumentMetadata> metadata) throws SQLException {
        this.console.printMessage("   Clean all the deprecated documents in " + this.componentId);
        Connection connection = this.getConnection();
        connection.setAutoCommit(false);
        PreparedStatement deleteVersions = connection.prepareStatement(DELETE_DOCUMENT_VERSIONS);
        PreparedStatement deleteAttachment = connection.prepareStatement(DELETE_DOCUMENT);
        try {
            for (OldDocumentMetadata document : metadata) {
                try {
                    deleteVersions.setLong(1, document.getOldSilverpeasId());
                    deleteVersions.executeUpdate();
                    deleteAttachment.setLong(1, document.getOldSilverpeasId());
                    deleteAttachment.executeUpdate();
                    connection.commit();
                    deleteVersions.clearParameters();
                    deleteAttachment.clearParameters();
                }
                catch (SQLException ex) {
                    this.console.printError("Error while cleaning up in database the document " + document.getTitle() + " (id = " + document.getOldSilverpeasId() + ")");
                    throw ex;
                }
                for (Version version : document.getHistory()) {
                    File file = null;
                    try {
                        file = version.getAttachment();
                        if (file == null) continue;
                        ConverterUtil.deleteFile(file);
                    }
                    catch (IOException ioex) {
                        String fileName = file != null ? file.getPath() : "";
                        this.console.printError("Error deleting file " + fileName, ioex);
                    }
                }
            }
        }
        finally {
            DbUtils.closeQuietly((Statement)deleteVersions);
            DbUtils.closeQuietly((Statement)deleteAttachment);
            DbUtils.closeQuietly((Connection)connection);
        }
    }

    @Override
    public Long call() throws Exception {
        this.console.printMessage("Migrating component " + this.componentId);
        return this.migrateComponent();
    }

    private List<OldDocumentMetadata> listAllDocuments() throws ParseException, IOException, SQLException {
        Connection connection = this.getConnection();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<OldDocumentMetadata> documents = new ArrayList<OldDocumentMetadata>(500);
        try {
            pstmt = connection.prepareStatement(SELECT_DOCUMENTS);
            pstmt.setString(1, this.componentId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                OldDocumentMetadata metadata = new OldDocumentMetadata(rs.getInt("documentordernum"), rs.getString("documentdescription"), DateUtil.parse(rs.getString("alertdate")), DateUtil.parse(rs.getString("expirydate")), rs.getString("documentownerid"), DateUtil.parse(rs.getString("documentcheckoutdate")), rs.getString("instanceid"), rs.getString("foreignid"), rs.getLong("documentid"), rs.getString("documentname"));
                OldDocumentMetadata aDocument = this.fillWithVersion(metadata);
                if (aDocument.getHistory().isEmpty()) {
                    this.console.printWarning("The document " + metadata + " doesn't belong to any component instance! So it is not taken into account");
                    continue;
                }
                documents.add(aDocument);
            }
        }
        catch (SQLException sqlex) {
            try {
                throw sqlex;
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(rs);
                DbUtils.closeQuietly((Statement)pstmt);
                DbUtils.closeQuietly((Connection)connection);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((ResultSet)rs);
        DbUtils.closeQuietly((Statement)pstmt);
        DbUtils.closeQuietly((Connection)connection);
        return documents;
    }

    private OldDocumentMetadata fillWithVersion(OldDocumentMetadata document) throws ParseException, IOException, SQLException {
        Connection connection = this.getConnection();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = connection.prepareStatement(SELECT_DOCUMENT_VERSION);
            pstmt.setLong(1, document.getOldSilverpeasId());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                Version version = new Version(rs.getInt("versionid"), rs.getInt("versionminornumber"), rs.getInt("versionmajornumber"), DateUtil.parse(rs.getString("versioncreationdate")), rs.getString("versionauthorid"), rs.getString("versionlogicalname"), rs.getString("versionphysicalname"), rs.getString("versionmimetype"), rs.getLong("versionsize"), rs.getString("xmlform"), rs.getString("versioncomments"), document.getInstanceId());
                File attachment = version.getAttachment();
                if (attachment != null && attachment.exists() && attachment.isFile() && attachment.length() > 0L) {
                    document.addVersion(version);
                    continue;
                }
                this.console.printWarning("The file refered by " + version + " doesn't exist in the filesystem! So, it is not taken into account");
            }
        }
        catch (SQLException sqlex) {
            try {
                throw sqlex;
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(rs);
                DbUtils.closeQuietly((Statement)pstmt);
                DbUtils.closeQuietly((Connection)connection);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((ResultSet)rs);
        DbUtils.closeQuietly((Statement)pstmt);
        DbUtils.closeQuietly((Connection)connection);
        return document;
    }

    private void createDocumentPermalink(HistorisedDocument document, OldDocumentMetadata metadata) throws SQLException {
        Connection connection = this.getConnection();
        PreparedStatement pstmt = null;
        try {
            pstmt = connection.prepareStatement("INSERT INTO permalinks_document (documentId, documentUuid) VALUES( ?, ?)");
            pstmt.setLong(1, metadata.getOldSilverpeasId());
            pstmt.setString(2, document.getId());
            pstmt.executeUpdate();
            connection.commit();
        }
        catch (SQLException sqlex) {
            throw sqlex;
        }
        finally {
            DbUtils.closeQuietly((Statement)pstmt);
            DbUtils.closeQuietly((Connection)connection);
        }
    }

    private void createVersionPermalink(String uuid, int versionId) throws SQLException {
        Connection connection = this.getConnection();
        PreparedStatement pstmt = null;
        try {
            pstmt = connection.prepareStatement("INSERT INTO permalinks_version (versionId, versionUuid) VALUES( ?, ?)");
            pstmt.setLong(1, versionId);
            pstmt.setString(2, uuid);
            pstmt.executeUpdate();
            connection.commit();
        }
        catch (SQLException sqlex) {
            throw sqlex;
        }
        finally {
            DbUtils.closeQuietly((Statement)pstmt);
            DbUtils.closeQuietly((Connection)connection);
        }
    }

    private Connection getConnection() throws SQLException {
        return ConnectionFactory.getConnection();
    }
}

