/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.migration.jcr.wysiwyg;

import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.io.FilenameUtils;
import org.silverpeas.migration.jcr.service.ConverterUtil;
import org.silverpeas.migration.jcr.service.SimpleDocumentService;
import org.silverpeas.migration.jcr.service.model.SimpleAttachment;
import org.silverpeas.migration.jcr.service.model.SimpleDocument;
import org.silverpeas.util.Console;
import org.silverpeas.util.StringUtil;

class WysiwygDocumentMerger
implements Callable<Long> {
    private final String componentId;
    private final SimpleDocumentService service;
    private final Console console;

    WysiwygDocumentMerger(String instanceId, SimpleDocumentService service, Console console) {
        this.componentId = instanceId;
        this.service = service;
        this.console = console;
    }

    @Override
    public Long call() throws Exception {
        this.console.printMessage("Migrating wysiwyg for " + this.componentId);
        return this.mergeWysiwyg();
    }

    private Long mergeWysiwyg() {
        long nbMigratedDocuments = 0L;
        List<String> basenames = this.service.listBasenames(this.componentId);
        for (String basename : basenames) {
            this.console.printMessage("Migrating wysiwyg for basename " + basename);
            List<SimpleDocument> documents = this.service.listWysiwygForBasename(basename, this.componentId);
            if (documents.size() <= 1) continue;
            this.console.printMessage("We have " + documents.size() + " to merge for basename " + basename);
            SimpleDocument merge = this.getMergeDocument(documents, basename);
            documents.remove(merge);
            this.mergeDocuments(merge, documents);
            ++nbMigratedDocuments;
        }
        return nbMigratedDocuments;
    }

    private SimpleDocument getMergeDocument(List<SimpleDocument> documents, String basename) {
        for (SimpleDocument document : documents) {
            if (!basename.equals(FilenameUtils.getBaseName((String)document.getFilename()))) continue;
            return document;
        }
        return documents.get(0);
    }

    public SimpleDocument mergeDocuments(SimpleDocument document, List<SimpleDocument> documents) {
        SimpleDocument mergedDocument = document;
        for (SimpleDocument doc : documents) {
            String lang = ConverterUtil.extractLanguage(doc.getFilename());
            if (!StringUtil.isDefined(lang)) {
                lang = doc.getLanguage();
            }
            mergedDocument.setAttachment(new SimpleAttachment(doc.getFilename(), lang, doc.getTitle(), doc.getDescription(), doc.getSize(), doc.getContentType(), doc.getCreatedBy(), doc.getCreated(), doc.getXmlFormId()));
            File content = new File(doc.getAttachmentPath());
            if (!content.exists() || !content.isFile()) {
                this.console.printMessage("We have not found " + content.getAbsolutePath());
                doc.setLanguage("fr");
                content = new File(doc.getAttachmentPath());
            }
            if (content.exists() && content.isFile()) {
                mergedDocument = this.service.mergeDocument(mergedDocument, doc);
                this.console.printMessage(content.getAbsolutePath() + " was merged into " + mergedDocument.getAttachmentPath());
                continue;
            }
            this.console.printMessage("We have not found " + content.getAbsolutePath());
        }
        return mergedDocument;
    }
}

