/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.migration.pdc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import org.apache.commons.dbutils.DbUtils;
import org.silverpeas.dbbuilder.dbbuilder_dl.DbBuilderDynamicPart;
import org.silverpeas.util.Console;

public class IdGenerationByUsingUniqueId
extends DbBuilderDynamicPart {
    private static final String NEW_ENTRY_IN_UNIQUEID = "insert into UniqueId(maxId, tableName) values(?, ?)";
    private static final String GREATER_ID_FETCHING = "select max(id) from {0}";
    private static final String[] TABLES_TO_MIGRATE = new String[]{"PdcPosition", "PdcClassification"};
    private boolean defaultAutocommitStatus = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrate() throws Exception {
        Statement preparedStatement = null;
        try {
            Console console = this.prepareConsole();
            this.openTransaction();
            preparedStatement = this.getConnection().prepareStatement(NEW_ENTRY_IN_UNIQUEID);
            for (String aTable : TABLES_TO_MIGRATE) {
                long maxId = this.getGreaterIdentifier(aTable);
                if (maxId >= 0L) {
                    preparedStatement.setLong(1, maxId + 1L);
                    preparedStatement.setString(2, aTable);
                    int success = preparedStatement.executeUpdate();
                    if (success < 1) {
                        console.printError("The entry creation in the UniqueId for table " + aTable + " has failed.");
                        continue;
                    }
                    console.printMessage("The entry creation in UniqueId for table " + aTable + " has succeeded");
                    continue;
                }
                console.printError("The table " + aTable + " doesn't have any column id!");
            }
            this.commitTransaction();
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            this.closeTransaction();
        }
    }

    private void openTransaction() throws SQLException {
        this.defaultAutocommitStatus = this.getConnection().getAutoCommit();
        this.getConnection().setAutoCommit(false);
    }

    private void commitTransaction() throws SQLException {
        this.getConnection().commit();
    }

    private void closeTransaction() throws SQLException {
        this.getConnection().setAutoCommit(this.defaultAutocommitStatus);
    }

    private Console prepareConsole() {
        Console console = this.getConsole();
        if (console == null) {
            console = new Console();
        }
        return console;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getGreaterIdentifier(String inTable) throws SQLException {
        long maxId = -1L;
        Statement statement = null;
        ResultSet results = null;
        try {
            statement = this.getConnection().createStatement();
            String sqlQuery = MessageFormat.format(GREATER_ID_FETCHING, inTable);
            results = statement.executeQuery(sqlQuery);
            if (results.next()) {
                maxId = results.getLong(1);
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(results);
            DbUtils.closeQuietly((Statement)statement);
            throw throwable;
        }
        DbUtils.closeQuietly((ResultSet)results);
        DbUtils.closeQuietly((Statement)statement);
        return maxId;
    }
}

