/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.migration.sqldomain;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.silverpeas.dbbuilder.dbbuilder_dl.DbBuilderDynamicPart;
import org.silverpeas.util.Console;
import org.silverpeas.util.file.FileUtil;

public class PasswordSizeIncrease
extends DbBuilderDynamicPart {
    static final String DOMAINS_SQL = "SELECT * FROM ST_DOMAIN WHERE className='com.stratelia.silverpeas.domains.sqldriver.SQLDriver'";
    static final String TABLE_OF_USERS = "database.SQLUserTableName";
    static final String PASSWORD_FIELD = "database.SQLUserPasswordColumnName";
    static final String SQL_DRIVER = "database.SQLClassName";
    static final String DATABASE_URL = "database.SQLJDBCUrl";
    static final String DATABASE_LOGIN = "database.SQLAccessLogin";
    static final String DATABASE_PASSWORD = "database.SQLAccessPasswd";
    static final String H2_DATABASE = "org.h2.Driver";
    static final String POSTGRESQL_DATABASE = "org.postgresql.Driver";
    static final String MSSQL_DATABASE = "net.sourceforge.jtds.jdbc.Driver";
    static final String ORACLE_DATABASE = "oracle.jdbc.driver.OracleDriver";
    static final String H2_SQL = "ALTER TABLE {0} ALTER COLUMN {1} varchar(123)";
    static final String POSTGRESQL_SQL = "ALTER TABLE {0} ALTER COLUMN {1} TYPE varchar(123)";
    static final String MSSQL_SQL = "ALTER TABLE {0} ALTER COLUMN {1} varchar(123)";
    static final String ORACLE_SQL = "ALTER TABLE {0} MODIFY ({1} varchar(123))";
    private Connection sharedConnection;
    private Console console;

    public void migrate() throws Exception {
        this.getConsole().printMessage("Migration of the user password length to 123 characters");
        List<String> sqlDomains = this.getAllSQLCustomerDomains();
        for (String resourcePath : sqlDomains) {
            String name = resourcePath.replace('.', File.separatorChar) + ".properties";
            Properties resource = FileUtil.loadResource(name);
            if (resource.isEmpty()) {
                name = name.replace("com" + File.separatorChar + "stratelia" + File.separatorChar, "org" + File.separatorChar);
                resource = FileUtil.loadResource(name);
            }
            if (resource.isEmpty()) continue;
            this.updatePasswordTypeInDBs(name, resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getAllSQLCustomerDomains() throws Exception {
        ArrayList<String> sqlDomains = new ArrayList<String>();
        Connection connection = this.getConnection();
        Statement statement = null;
        ResultSet rs = null;
        try {
            statement = connection.createStatement();
            rs = statement.executeQuery(DOMAINS_SQL);
            while (rs.next()) {
                sqlDomains.add(rs.getString("propFileName"));
            }
        }
        catch (Throwable throwable) {
            PasswordSizeIncrease.closeResultSet(rs);
            PasswordSizeIncrease.closeStatement(statement);
            throw throwable;
        }
        PasswordSizeIncrease.closeResultSet(rs);
        PasswordSizeIncrease.closeStatement(statement);
        return sqlDomains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePasswordTypeInDBs(String domainName, Properties domainProps) {
        Statement statement;
        Connection connection;
        block4: {
            Console out = this.getConsole();
            connection = null;
            statement = null;
            try {
                if (!PasswordSizeIncrease.isSQLDomain(domainProps)) break block4;
                connection = this.openConnection(domainProps);
                statement = connection.createStatement();
                statement.execute(PasswordSizeIncrease.sqlInstructionFor(domainProps));
            }
            catch (Exception ex) {
                try {
                    out.printError("Error while processing the domain in " + domainName, ex);
                }
                catch (Throwable throwable) {
                    PasswordSizeIncrease.closeStatement(statement);
                    this.closeConnection(connection);
                    throw throwable;
                }
                PasswordSizeIncrease.closeStatement(statement);
                this.closeConnection(connection);
            }
        }
        PasswordSizeIncrease.closeStatement(statement);
        this.closeConnection(connection);
    }

    private static boolean isSQLDomain(Properties domain) {
        return domain.containsKey(SQL_DRIVER);
    }

    private static String sqlInstructionFor(Properties domain) {
        String sql = null;
        String database = domain.getProperty(SQL_DRIVER);
        String table = domain.getProperty(TABLE_OF_USERS);
        String password = domain.getProperty(PASSWORD_FIELD);
        if (POSTGRESQL_DATABASE.equals(database)) {
            sql = MessageFormat.format(POSTGRESQL_SQL, table, password);
        } else if (MSSQL_DATABASE.equals(database)) {
            sql = MessageFormat.format("ALTER TABLE {0} ALTER COLUMN {1} varchar(123)", table, password);
        } else if (ORACLE_DATABASE.equals(database)) {
            MessageFormat.format(ORACLE_SQL, table, password);
        } else if (H2_DATABASE.equals(database)) {
            sql = MessageFormat.format("ALTER TABLE {0} ALTER COLUMN {1} varchar(123)", table, password);
        } else {
            throw new IllegalArgumentException("The database '" + database + "' isn't supported by" + "Silverpeas");
        }
        return sql;
    }

    private Connection openConnection(Properties domain) throws Exception {
        Connection connection = this.getSharedConnection();
        if (connection == null) {
            Class.forName(domain.getProperty(SQL_DRIVER)).newInstance();
            String password = domain.getProperty(DATABASE_PASSWORD);
            if (password == null) {
                password = "";
            }
            connection = DriverManager.getConnection(domain.getProperty(DATABASE_URL), domain.getProperty(DATABASE_LOGIN), password);
        }
        return connection;
    }

    private void closeConnection(Connection connection) {
        if (connection != null && connection != this.getSharedConnection()) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static void closeStatement(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static void closeResultSet(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private Connection getSharedConnection() {
        return this.sharedConnection;
    }

    protected void setSharedConnection(Connection connection) {
        this.sharedConnection = connection;
    }

    @Override
    public Console getConsole() {
        if (this.console == null) {
            Console theConsole = super.getConsole();
            this.console = theConsole == null ? new Console() : theConsole;
        }
        return this.console;
    }
}

