/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.passwordencryption;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.dbutils.DbUtils;
import org.silverpeas.dbbuilder.dbbuilder_dl.DbBuilderDynamicPart;
import org.silverpeas.passwordencryption.CryptographicFunction;
import org.silverpeas.passwordencryption.Sha512Crypt;

public class UserPasswordEncryption
extends DbBuilderDynamicPart {
    private static final String PASSWORD_UPDATE = "UPDATE DomainSP_User SET password = ? WHERE id = ?";
    private final CryptographicFunction crypt = new Sha512Crypt();

    public void run() throws Exception {
        Connection connection = this.getConnection();
        ResultSet rs = null;
        Statement stmt = null;
        PreparedStatement stmtUpdate = null;
        try {
            stmt = connection.createStatement();
            rs = stmt.executeQuery("SELECT * FROM DomainSP_User");
            while (rs.next()) {
                String sClearPass = rs.getString("password");
                if (sClearPass == null) {
                    sClearPass = "";
                }
                stmtUpdate = connection.prepareStatement(PASSWORD_UPDATE);
                stmtUpdate.setString(1, this.crypt.encrypt(sClearPass));
                stmtUpdate.setInt(2, rs.getInt("id"));
                stmtUpdate.executeUpdate();
                stmtUpdate.close();
                stmtUpdate = null;
            }
        }
        catch (SQLException ex) {
            try {
                throw new Exception("Error during password encryption: " + ex.getMessage());
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(rs);
                DbUtils.closeQuietly((Statement)stmt);
                DbUtils.closeQuietly(stmtUpdate);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((ResultSet)rs);
        DbUtils.closeQuietly((Statement)stmt);
        DbUtils.closeQuietly(stmtUpdate);
    }
}

