/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.settings.file;

import java.io.File;
import java.util.ArrayList;

public class BackupFile {
    private static final String EXT = ".bak~";
    private File file = null;
    private File[] listFileBackup = null;
    private File firstFileBackup = null;
    private File lastFileBackup = null;
    private int nbFileBackup = 0;
    private int lastNumFileBackup = 0;

    public BackupFile(File pathname) throws Exception {
        this.file = pathname;
        if (!this.file.exists()) {
            throw new Exception("file not found : " + this.file.getAbsolutePath());
        }
        this.refresh();
    }

    public void makeBackup() throws Exception {
    }

    private void refresh() throws Exception {
        this.setList();
        this.setFirst();
        this.setLast();
    }

    public File[] getListBackup() throws Exception {
        return this.listFileBackup;
    }

    public File getFirstBackup() throws Exception {
        return this.firstFileBackup;
    }

    public File getLastBackup() throws Exception {
        return this.lastFileBackup;
    }

    public int getNumberBackup() throws Exception {
        return this.nbFileBackup;
    }

    public boolean existBackup() throws Exception {
        return 0 != this.nbFileBackup;
    }

    private void setList() throws Exception {
        File[] listeAll = this.file.getParentFile().listFiles();
        if (listeAll == null) {
            listeAll = new File[]{};
        }
        ArrayList<File> listeGood = new ArrayList<File>(listeAll.length);
        for (int i = 0; i < listeAll.length; ++i) {
            File tmpFile = listeAll[i];
            if (!tmpFile.isFile() || -1 == tmpFile.getName().indexOf(this.file.getName()) || -1 == tmpFile.getName().indexOf(EXT)) continue;
            listeGood.add(tmpFile);
        }
        File[] listeF = new File[listeGood.size()];
        for (int i = 0; i < listeF.length; ++i) {
            listeF[i] = (File)listeGood.get(i);
        }
        this.listFileBackup = listeF;
        this.nbFileBackup = this.listFileBackup.length;
    }

    private void setFirst() throws Exception {
        File f = null;
        if (this.existBackup()) {
            f = this.listFileBackup[0];
            for (int i = 0; i < this.nbFileBackup; ++i) {
                if (this.listFileBackup[i].lastModified() >= f.lastModified()) continue;
                f = this.listFileBackup[i];
            }
        }
        this.firstFileBackup = f;
    }

    private void setLast() throws Exception {
        this.lastFileBackup = null;
        if (this.existBackup()) {
            this.lastFileBackup = this.listFileBackup[0];
            for (int i = 0; i < this.nbFileBackup; ++i) {
                if (this.listFileBackup[i].lastModified() <= this.lastFileBackup.lastModified()) continue;
                this.lastFileBackup = this.listFileBackup[i];
            }
        }
        this.lastNumFileBackup = -1;
        if (this.existBackup()) {
            String name = this.lastFileBackup.getName();
            String endName = name.substring(name.lastIndexOf(EXT) + EXT.length(), name.length());
            int i = 1;
            while (i <= endName.length()) {
                try {
                    this.lastNumFileBackup = Integer.parseInt(endName.substring(0, i));
                    ++i;
                }
                catch (Exception e) {
                    i = endName.length() + 2;
                }
            }
        }
    }
}

