/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.settings.file;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.silverpeas.settings.file.ElementModif;
import org.silverpeas.settings.file.ModifFile;
import org.silverpeas.settings.file.RegexpElementMotif;

public class ModifText
extends ModifFile {
    public ModifText(String path) throws Exception {
        super.setPath(path);
    }

    public void setModif(String[] str) throws Exception {
        for (int i = 0; i < str.length; ++i) {
            this.addModification(str[i]);
        }
    }

    protected String analyseLigne(String line) {
        String tmpLine = line;
        for (ElementModif modif : this.listeModifications) {
            tmpLine = this.analyseLine(tmpLine, modif);
        }
        if (tmpLine != null && tmpLine.isEmpty()) {
            tmpLine = line;
        }
        return tmpLine;
    }

    protected String analyseLine(String line, ElementModif modification) {
        StringBuffer resStr = new StringBuffer();
        if (modification instanceof RegexpElementMotif) {
            RegexpElementMotif emv = (RegexpElementMotif)modification;
            Pattern pattern = emv.getPattern();
            Matcher match = pattern.matcher(line);
            while (match.find()) {
                match.appendReplacement(resStr, emv.getRemplacement());
            }
            match.appendTail(resStr);
        } else {
            int res = line.lastIndexOf(modification.getSearch());
            if (res != -1) {
                resStr.append(line.substring(0, res)).append(modification.getModif()).append(line.substring(res + modification.getSearch().length(), line.length()));
            }
        }
        return resStr.toString().trim();
    }

    @Override
    public void executeModification() throws Exception {
        File inFile = new File(this.path);
        List lines = FileUtils.readLines((File)inFile);
        ArrayList<String> newLines = new ArrayList<String>(lines.size());
        for (String line : lines) {
            newLines.add(this.analyseLigne(line));
        }
        FileUtils.writeLines((File)inFile, newLines);
        if ((this.path.endsWith(".sh") || this.path.endsWith(".csh") || this.path.endsWith(".ksh")) && '/' == File.separatorChar) {
            String[] commande = new String[]{"/bin/chmod", "755", this.path};
            Runtime.getRuntime().exec(commande);
        }
    }
}

