/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.settings.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.silverpeas.settings.file.BackupFile;
import org.silverpeas.settings.file.ElementModif;
import org.silverpeas.settings.file.ModifFile;

public class ModifXMLSilverpeas
extends ModifFile {
    public ModifXMLSilverpeas(String path) throws Exception {
        super(path);
    }

    public void setModif(String[] str) throws Exception {
        for (int i = 0; i < str.length; ++i) {
            this.addModification(str[i]);
        }
    }

    private void traiteChildren(List children) throws Exception {
        for (int i = 0; i < children.size(); ++i) {
            List chil;
            Element currentNode = (Element)children.get(i);
            if (currentNode.getName().compareTo("param-name") == 0) {
                String value = currentNode.getTextTrim();
                for (ElementModif em : this.listeModifications) {
                    String val;
                    if (em.getSearch().compareTo(value) != 0 || (val = currentNode.getParentElement().getChild("param-value").getTextTrim()).equals(em.getModif())) continue;
                    if (!this.isModified) {
                        this.isModified = true;
                        BackupFile bf = new BackupFile(new File(this.path));
                        bf.makeBackup();
                    }
                    currentNode.getParentElement().getChild("param-value").setText(em.getModif());
                }
            }
            if ((chil = currentNode.getChildren()) == null) continue;
            this.traiteChildren(chil);
        }
    }

    @Override
    public void executeModification() throws Exception {
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(new File(this.path));
        Element root = doc.getRootElement();
        this.traiteChildren(root.getChildren());
        FileOutputStream out = new FileOutputStream(this.path);
        Format format = Format.getPrettyFormat();
        format.setIndent("\t");
        format.setTextMode(Format.TextMode.TRIM);
        XMLOutputter serializer = new XMLOutputter(format);
        serializer.output(doc, (OutputStream)out);
        out.flush();
        out.close();
    }
}

