/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.silverpeas.dbbuilder.util.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Console {
    private static final String newline = System.getProperty("line.separator");
    private final Logger logger;
    private File logFile;
    private PrintWriter logBuffer;
    private boolean echoAsDotEnabled = true;

    public Console(String fileName, Class builderClass) throws IOException {
        this.logger = LoggerFactory.getLogger((Class)builderClass);
        this.logFile = new File(Configuration.getLogDir(), fileName);
        FileUtils.forceMkdir((File)this.logFile.getParentFile());
        this.logBuffer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.logFile.getAbsolutePath(), true), Charsets.UTF_8)));
    }

    public Console(Class builderClass) {
        this.logger = LoggerFactory.getLogger((Class)builderClass);
    }

    public Console() {
        this.logger = LoggerFactory.getLogger(Console.class);
    }

    public synchronized void printError(String errMsg, Exception ex) {
        this.printMessage(errMsg, true);
        if (null != this.logBuffer) {
            ex.printStackTrace(this.logBuffer);
        }
        this.logger.error(errMsg, (Throwable)ex);
    }

    public synchronized void printError(String errMsg) {
        this.printMessage(errMsg, true);
        this.logger.error(errMsg);
    }

    public synchronized void printWarning(String errMsg) {
        this.printMessage(errMsg, true);
        this.logger.warn(errMsg);
    }

    public synchronized void printWarning(String errMsg, Exception ex) {
        this.printMessage(errMsg, true);
        this.logger.warn(errMsg, (Throwable)ex);
    }

    public synchronized void printMessage(String msg) {
        this.printMessage(msg, false);
    }

    public synchronized void printTrace(String msg) {
        this.logger.debug(msg);
    }

    private synchronized void printMessage(String msg, boolean isError) {
        if (null != this.logBuffer) {
            this.logBuffer.print(msg);
        }
        if (this.echoAsDotEnabled) {
            System.out.print(".");
        } else {
            System.out.println(newline + msg + newline);
        }
        if (!isError) {
            this.logger.info(msg);
        }
    }

    public synchronized void close() {
        if (null != this.logBuffer) {
            this.logBuffer.close();
        }
    }

    public synchronized void setEchoAsDotEnabled(boolean on) {
        this.echoAsDotEnabled = on;
    }
}

