/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.util;

import bsh.EvalError;
import bsh.Interpreter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

public class GestionVariables {
    private Properties listeVariables = new Properties();

    private GestionVariables() {
        for (String string : System.getProperties().stringPropertyNames()) {
            this.listeVariables.put(string, System.getProperties().getProperty(string));
        }
        for (Map.Entry entry : System.getenv().entrySet()) {
            this.listeVariables.put(entry.getKey(), entry.getValue());
        }
    }

    public GestionVariables(Properties defaultConfig) throws IOException {
        this();
        for (String key : defaultConfig.stringPropertyNames()) {
            if (this.listeVariables.containsKey(key)) continue;
            this.listeVariables.put(key, this.resolveAndEvalString(defaultConfig.getProperty(key)));
        }
    }

    public GestionVariables(Properties config, Properties defaultConfig) throws IOException {
        this(defaultConfig);
        for (String key : config.stringPropertyNames()) {
            this.listeVariables.put(key, this.resolveAndEvalString(config.getProperty(key)));
        }
    }

    public void addVariable(String variable, String value) {
        this.listeVariables.put(variable, value);
    }

    public void modifyVariable(String varName, String varValue) {
        this.listeVariables.remove(varName);
        this.listeVariables.put(varName, varValue);
    }

    public Enumeration<String> getVariableNames() {
        return this.listeVariables.propertyNames();
    }

    public final String resolveString(String unresolvedString) throws IOException {
        StringBuilder newString = new StringBuilder("");
        int index = unresolvedString.indexOf("${");
        if (-1 != index) {
            String currentStringPortion = unresolvedString;
            while (-1 != index) {
                newString.append(currentStringPortion.substring(0, index));
                int index_fin = currentStringPortion.indexOf(125);
                newString.append(this.getValue(currentStringPortion.substring(index + 2, index_fin)));
                currentStringPortion = currentStringPortion.substring(index_fin + 1);
                index = currentStringPortion.indexOf("${");
            }
            newString.append(currentStringPortion);
            return newString.toString();
        }
        return unresolvedString;
    }

    public final String resolveAndEvalString(String unresolvedString) throws IOException {
        int index = unresolvedString.indexOf("$eval{{");
        if (-1 == index) {
            return this.resolveString(unresolvedString);
        }
        if (0 != index) {
            throw new IllegalArgumentException("(Unable to evaluate " + unresolvedString + " because string is not beginning with \"$eval{{\" sequence.");
        }
        int index_fin = unresolvedString.indexOf("}}");
        if (index_fin != unresolvedString.length() - 2) {
            throw new IllegalArgumentException("(unable to evaluate " + unresolvedString + " because string is not endding with \"}}\" sequence.");
        }
        String resolvedString = unresolvedString.substring(0, index_fin);
        resolvedString = resolvedString.substring(7);
        resolvedString = this.resolveString(resolvedString);
        String evaluatedString = null;
        try {
            Interpreter bsh = new Interpreter();
            bsh.set("value", (Object)"");
            bsh.eval(resolvedString);
            evaluatedString = (String)bsh.get("value");
        }
        catch (EvalError e) {
            throw new IllegalArgumentException("(unable to evaluate " + resolvedString, e);
        }
        return evaluatedString;
    }

    public String getValue(String variable) throws IOException {
        String tmp = this.listeVariables.getProperty(variable);
        if (null == tmp) {
            throw new IOException("La variable :\"" + variable + "\" n'existe pas dans la base");
        }
        return tmp;
    }
}

